VERSION 5.00
Object = "{FE69BD77-3946-4641-8613-6FC7144F2E05}#9.0#0"; "DFPGE9.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   ClientHeight    =   8400
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   11070
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   MouseIcon       =   "Main.frx":08CA
   MousePointer    =   99  'Custom
   ScaleHeight     =   8400
   ScaleWidth      =   11070
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin VB.Timer tmrStart 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   10020
      Top             =   120
   End
   Begin DFPGELib.DFPGE DGE 
      Height          =   7155
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   9915
      Visible         =   0   'False
      _Version        =   589824
      _ExtentX        =   17489
      _ExtentY        =   12621
      _StockProps     =   0
   End
   Begin VB.Label lblLoading 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Loading"
      BeginProperty Font 
         Name            =   "Impact"
         Size            =   21.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   540
      Left            =   120
      TabIndex        =   1
      Top             =   7260
      Width           =   1410
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'This example demonstrates bone animation using an array of bone data (bone frame) that is used by the character's vertex shaders.
'The actor class is simplified for this example and it's physics is not enough for a real game.

Option Explicit

'You may change these constants
Const BloomSize As Single = 2.4

'Data for the camera
Dim Camera_Main As Long
Dim Longitude As Single
Dim Lattitude As Single
Const CameraDistance As Single = 4

'References to draw durfaces
Dim DrawSurface_D As Long 'Default draw surface
Dim DrawSurface_B As Long 'Blur draw surface with a lower resolution
Dim DrawSurface_Final As Long 'Final draw surface for showing the final image

'The player
Dim Model_Human As Long
Dim Player As Actor

'Global light
Dim LightSource_Sun As Long

'Measure rendering speed
Dim TimePerFrame As Single

Private Function StartEngine() As Boolean
    StartEngine = DGE.Engine_Initiate: RE
End Function

Private Sub DGE_KeyDown(KeyCode As Integer, Shift As Integer)
    'Exit the application when escape is pressed
    If KeyCode = vbKeyEscape Then End
End Sub

Private Sub Form_Load()
    Randomize Timer
    If StartEngine Then
        'Set the default folder so that relative paths can be used
        SetRelativeWorkingDirectory "..\CommonMediaFiles"
        
        'We start a timer to let this routine exit before we render anything
        'The graphical user interface will not be drawn until Form_Load has finished and therefor the main loop can't be placed in Form_Load
        tmrStart.Enabled = True
    End If
End Sub

Private Sub LoadThings()
    Static I As Long
    Static NewInstance As Long
    
    'Load and use our default material shader that will be used when something don't have a shader in the current shader channel
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultMaterialShader": DGE.Shader_UseAsDefaultMaterialShader DGE.Shader_LoadAsMaterial_InSB: RE

    'Load and use our default texture that is used when a texture is missing
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultTexture": DGE.Texture_UseAsDefaultTexture DGE.Texture_Load_InSB: RE
    
    'Create a camera and take the reference number
    Camera_Main = DGE.Camera_Create: RE
    DGE.Camera_SetVerticalFOV_InDegrees Camera_Main, 60
    Longitude = 0.4
    Lattitude = 0
    
    'Get the version specific ID to the final draw surface
    DrawSurface_Final = DGE.DrawSurface_GetFinalOutput: RE
    
    'Set the background color that the fog will also have.
    DGE.Enviroment_SetBackgroundColor 0.6, 0.7, 0.8, 1
    
    'Set the amount of ambient light
    DGE.LightSource_SetAmbientLight 0.2, 0.3, 0.4: RE
    
    'Set the depth atlas resolution
    DGE.LightSource_SetDepthAtlasResolution 1024: RE
    
    'Create sun light
    LightSource_Sun = DGE.LightSource_Create_Sun_Shadowcasting_SingleLayer(0, 0, 0, 0.5, -1, -1, 0, 1, 0, -1000, 1000, 2.6, 2.6, 2.6, 3, 2, 0, 0, 1, 0.1): RE
    
    'Load and use the ground model
    DGE.Instance_Create LoadModel("Model_FlatGround"): RE
    
    'Create some draw surfaces for the bloom effect
    DrawSurface_D = DGE.DrawSurface_CreateAutoSized(1, 1, 0, 0, 1, True): RE 'Allow rendering a 3D scene to it but not using soft particles and allow rendering from and to itself.
    DrawSurface_B = DGE.DrawSurface_CreateAutoSized(0.25, 0.25, 0, 0, 0, True): RE 'Allow rendering from and to itself.
    
    'Load the post effects
    PostEffects_Init
    
    'Load the human model
    Model_Human = LoadModel("Model_Bone_Human")
    
    'Create the player
    Set Player = New Actor
    Player.GiveModel Model_Human
    Player.SizeMultiplier = 1 'This can be changed to make the actor bigger or smaller
    Player.Position_X = 0
    Player.Position_Y = Player.DefaultHeightAboveGround * Player.SizeMultiplier
    Player.Position_Z = 0
    Player.DirectionAngle = Longitude
    
    'Start measuring mouse moves
    Mouse_Init
    
    lblLoading.Visible = False
    DGE.Visible = True
End Sub

Private Sub Form_Resize()
    'Scale the component to cover the screen
    DGE.Width = Screen.Width
    DGE.Height = Screen.Height
    lblLoading.Left = (Screen.Width - lblLoading.Width) / 2
    lblLoading.Top = (Screen.Height - lblLoading.Height) / 2
End Sub

Private Sub tmrStart_Timer()
    Static TenCycleStartTime As Single
    Static CycleCount As Long
    tmrStart.Enabled = False
    LoadThings
    Do
        'Start 10 frame counting
        If CycleCount = 0 Then TenCycleStartTime = Timer
        
        DoStuff
        DoEvents
        
        'End 10 frame counting
        CycleCount = CycleCount + 1
        If CycleCount = 10 Then
            If Timer > TenCycleStartTime Then
                'Only update if the time was positive to remove overflow during midnight.
                TimePerFrame = (Timer - TenCycleStartTime) / 10
            End If
            CycleCount = 0
        End If
    Loop
End Sub

Private Sub DoStuff()
    Static I As Long
    Static CameraDir As Vector3
    Static CameraPos As Vector3
    Static MouseOffset As Vector2
    MouseOffset = Mouse_GetOffsetSinceLastCall
    
    'Move the camera
    Longitude = Longitude + (MouseOffset.X * 0.015)
    Lattitude = Clamp(Lattitude + (MouseOffset.Y * 0.015), -1.5, 1.5)
    
    'Calculate the camera direction
    Longitude = FixRadianPositive(Longitude)
    CameraDir = MakeVector3(Sin(Longitude) * Cos(Lattitude), -Sin(Lattitude), Cos(Longitude) * Cos(Lattitude))
    
    'Handle the player
    Player.WalkForward = KeyDown_ZeroToOne(vbKeyW) - KeyDown_ZeroToOne(vbKeyS)
    Player.WalkRight = KeyDown_ZeroToOne(vbKeyD) - KeyDown_ZeroToOne(vbKeyA)
    Player.Acceleration_Target = Lerp(0.7, 1.5, KeyDown_ZeroToOne(vbKeyShift))
    Player.Crouching_Target = KeyDown_ZeroToOne(vbKeyControl)
    Player.DirectionAngle_Target = Longitude
    Player.TryToLookAtDirection CameraDir.X, CameraDir.Y, CameraDir.Z
    If KeyDown_Truth(vbKeyE) Then
        Player.Move TimePerFrame / 10
    Else
        Player.Move TimePerFrame
    End If
    
    'Place camera
    CameraPos = AddVector3(MakeVector3(Player.Position_X, Player.Position_Y, Player.Position_Z), MulVector3(CameraDir, -CameraDistance))
    CameraPos.Y = Max(0.1, CameraPos.Y)
    DGE.Camera_Place Camera_Main, CameraPos.X, CameraPos.Y, CameraPos.Z, CameraPos.X + CameraDir.X, CameraPos.Y + CameraDir.Y, CameraPos.Z + CameraDir.Z, 0, 1, 0: RE
    
    'Clear shadows
    DGE.LightSource_ClearShadows
    
    'Let light follow the player
    DGE.LightSource_SetPos LightSource_Sun, Player.Position_X, Player.Position_Y, Player.Position_Z
    
    'Render with post effects
        'Render the scene with shader channel 0 to surface D
            DGE.Camera_RenderScene Camera_Main, DrawSurface_D, 0: RE
        'Apply a bloom effect and show the result
            'PostEffects_DownSample from D to B
            PostEffects_DownSample DrawSurface_D, DrawSurface_B
            'Apply blur to B
            PostEffects_ApplyDiffuseBlur DrawSurface_B, 0.4 * BloomSize
            'Lower the gamma for B
            PostEffects_RaiseToPower DrawSurface_B, 1.3
            'Show a mix of D and B
            PostEffects_Mix2Surfaces DrawSurface_D, 0.35, DrawSurface_B, 0.9, DrawSurface_Final
    
End Sub
