
// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	// Convert vertice positions from object space to world space
	output.Pos = mul( input.Pos, ObjectToWorld );
	// Convert vertice positions from world space to camera space
	output.Pos = mul( output.Pos, WorldToCamera );
	// Convert vertice positions from camera space to 2D projection
	output.Pos = mul( output.Pos, CameraToImage );
	
	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	if ((round(input.Pos.x / 8) + round(input.Pos.y / 8)) % 2 == 0) {
		return InstanceColor;
	} else {
		return float4(0.0f,0.0f,0.0f,1.0f);
	}

}
