
// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
	float4 Tex : TEXCOORD0;
	float4 Color : COLOR;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	float3 Offset;
	Offset = (float3(0.1f,0.0f,0.0f) * input.Color.r * sin((GlobalTime + input.Pos.y + ObjectToWorld._41) * 1.9f))
		+(float3(0.0f,0.03f,0.0f) * input.Color.g * sin((GlobalTime + input.Pos.y + ObjectToWorld._42) * 2.3f))
		+(float3(0.0f,0.0f,0.1f) * input.Color.b * sin((GlobalTime + input.Pos.y + ObjectToWorld._43) * 2.8f));
	
	// Convert vertice positions from object space to 2D projection
	output.Pos = mul( mul( mul( input.Pos + float4(Offset,0), ObjectToWorld ), WorldToCamera ), CameraToImage );
	
	// Give the texture coordinates to the pixel shader
	output.Tex = input.Tex;
	
	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	clip(tex_0.Sample( samAnisotropicMipmap, input.Tex.xy ).w - 0.5f);
	
	return float4(0.0f, 0.0f, 1.0f, 0.0f);
}
