
// A diffuse map at tex_0
// A tangent space normal map at tex_1.rgb

// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
	float4 Tex : TEXCOORD0;
	float4 Color : COLOR;
	float3 Normal_WorldSpace : NORMAL;
	float4 Pos_WorldSpace : TEXCOORD1;
	float4 Pos_CameraSpace : TEXCOORD2;
	float3 UAxis_WorldSpace : TEXCOORD3;
	float3 VAxis_WorldSpace : TEXCOORD4;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	// Convert vertice positions and normals from bone space to object space
	float4x4 BoneToObject;
	float4 Pos_ObjectSpace;
	float3 Normal_ObjectSpace;
	float3 UAxis_ObjectSpace;
	float3 VAxis_ObjectSpace;
	int BoneIndex;
	BoneIndex = floor(input.BoneData.w);
	if (BoneIndex > -1) {
		// Get the axis system from the bone
		Engine_GetBoneMatrix(BoneIndex,BoneToObject);
		
		// Convert vertice positions from bone space to object space
		Pos_ObjectSpace = mul(float4(input.BoneData.xyz,1.0f),BoneToObject);
		
		// Transform normals and tangent space from bone space to object space
		Normal_ObjectSpace = mul(input.Normal,(float3x3)BoneToObject);
		UAxis_ObjectSpace = mul(input.A.xyz,(float3x3)BoneToObject);
		VAxis_ObjectSpace = mul(input.B.xyz,(float3x3)BoneToObject);
	} else {
		// Take the static object space position
		Pos_ObjectSpace = input.Pos;
		
		// Copy normals and tangent space
		Normal_ObjectSpace = input.Normal;
		UAxis_ObjectSpace = input.A.xyz;
		VAxis_ObjectSpace = input.B.xyz;
	}
	// Convert vertice positions from object space to world space
	output.Pos_WorldSpace = mul( Pos_ObjectSpace, ObjectToWorld );
	// Convert vertice positions from world space to camera space
	output.Pos_CameraSpace = mul( output.Pos_WorldSpace, WorldToCamera );
	// Convert vertice positions from camera space to 2D projection
	output.Pos = mul( output.Pos_CameraSpace, CameraToImage );
	
	// Transform normals and tangent space from object space to world space
	output.Normal_WorldSpace = mul(Normal_ObjectSpace,(float3x3)ObjectToWorld);
	output.UAxis_WorldSpace = mul(UAxis_ObjectSpace,(float3x3)ObjectToWorld);
	output.VAxis_WorldSpace = mul(VAxis_ObjectSpace,(float3x3)ObjectToWorld);
	
	// Give the texture coordinates to the pixel shader
	output.Tex = input.Tex;
	
	// Give the vertex color multiplied with the instance color to the pixel shader
	output.Color = lerp(input.Color * InstanceColor, float4(0.0f,0.0f,1.0f,1.0f), input.Selected);
	
	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	// If the camera has a world space cutting plane, clip on the negative side.
	UseCuttingPlane(input.Pos_WorldSpace)
	
	float4 finalColor = tex_0.Sample( samAnisotropicMipmap, input.Tex.xy ) * input.Color;
	
	float3x3 TangentSpace;
	float3 FinalNormal;
	TangentSpace = float3x3(normalize(input.UAxis_WorldSpace),normalize(input.VAxis_WorldSpace),normalize(input.Normal_WorldSpace));
	FinalNormal = normalize(mul((tex_1.Sample( samAnisotropicMipmap, input.Tex.xy ).xyz * 2.0f) - 1.0f,TangentSpace));
	
	float3 DiffuseLight;
	float3 SpecularLight;
	Engine_GetDiffuseAndSpecularLight(input.Pos_WorldSpace,FinalNormal,30,DiffuseLight,SpecularLight);
	// finalColor = (finalColor * float4(DiffuseLight,1.0f)) + float4(SpecularLight,1.0f);
	finalColor = (finalColor * float4(DiffuseLight + SpecularLight,1.0f));
	
	// Show the final color with fog on R,G,B channels
	return float4((lerp(finalColor,FogColor,saturate(length(input.Pos_CameraSpace) / FogDistance) * MaxFogIntensity)).xyz,finalColor.w);
}
