
// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
	float4 Color : COLOR;
	float3 Normal_WorldSpace : NORMAL;
	float4 Pos_WorldSpace : TEXCOORD1;
	float4 Pos_CameraSpace : TEXCOORD2;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	// Convert vertice positions and normals from bone space to object space
	float4x4 BoneToObject;
	float4 Pos_ObjectSpace;
	float3 Normal_ObjectSpace;
	int BoneIndex;
	BoneIndex = floor(input.BoneData.w);
	if (BoneIndex > -1) {
		// Get the axis system from the bone
		Engine_GetBoneMatrix(BoneIndex,BoneToObject);
		
		// Convert vertice positions from bone space to object space
		Pos_ObjectSpace = mul(float4(input.BoneData.xyz,1.0f),BoneToObject);
		
		// Transform normals from bone space to object space
		Normal_ObjectSpace = mul(input.Normal,(float3x3)BoneToObject);
	} else {
		// Take the static object space position
		Pos_ObjectSpace = input.Pos;
		
		// Copy normals
		Normal_ObjectSpace = input.Normal;
	}
	// Convert vertice positions from object space to world space
	output.Pos_WorldSpace = mul( Pos_ObjectSpace, ObjectToWorld );
	// Convert vertice positions from world space to camera space
	output.Pos_CameraSpace = mul( output.Pos_WorldSpace, WorldToCamera );
	// Convert vertice positions from camera space to 2D projection
	output.Pos = mul( output.Pos_CameraSpace, CameraToImage );
	// Transform normals from object space to world space
	output.Normal_WorldSpace = mul(Normal_ObjectSpace,(float3x3)ObjectToWorld);
	
	// Give the vertex color multiplied with the instance color to the pixel shader
	output.Color = lerp(input.Color * InstanceColor, float4(0.0f,0.0f,1.0f,1.0f), input.Selected);
	
	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	// If the camera has a world space cutting plane, clip on the negative side.
	UseCuttingPlane(input.Pos_WorldSpace)
	
	float4 finalColor = input.Color;
	
	float3 DiffuseLight;
	float3 SpecularLight;
	Engine_GetDiffuseAndSpecularLight(input.Pos_WorldSpace,normalize(input.Normal_WorldSpace),30,DiffuseLight,SpecularLight);
	// finalColor = (finalColor * float4(DiffuseLight,1.0f)) + float4(SpecularLight,1.0f);
	finalColor = (finalColor * float4(DiffuseLight + SpecularLight,1.0f));
	
	// Show the final color with fog on R,G,B channels
	return float4((lerp(finalColor,FogColor,saturate(length(input.Pos_CameraSpace) / FogDistance) * MaxFogIntensity)).xyz,finalColor.w);
}
