
// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	// Convert vertice positions from bone space to object space
	float4x4 BoneToObject;
	float4 Pos_ObjectSpace;
	int BoneIndex;
	BoneIndex = floor(input.BoneData.w);
	if (BoneIndex > -1) {
		// Get the axis system from the bone
		Engine_GetBoneMatrix(BoneIndex,BoneToObject);
		
		// Convert vertice positions from bone space to object space
		Pos_ObjectSpace = mul(float4(input.BoneData.xyz,1.0f),BoneToObject);
	} else {
		// Take the static object space position
		Pos_ObjectSpace = input.Pos;
	}
	// Convert vertice positions from object space to 2D projection
	output.Pos = mul( mul( Pos_ObjectSpace, ObjectToWorld ), WorldToImage );
	
	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	return float4(0.0f, 1.0f, 0.0f, 0.0f);
}

