
// Like M_Multiply_1Tex but with the UV coordinates lerped using Arg[0].
// UV equal to (0,0) is becomes MinUV (Arg[0].xy)
// UV equal to (1,1) is becomes MaxUV (Arg[0].zw)
// MaxU is allowed to be less than MinUV to mirror the source rectangle in the texture atlas.

#define MinUV Arg[0].xy
#define MaxUV Arg[0].zw

// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
	float2 Tex : TEXCOORD0;
	float4 Color : COLOR;
	float3 Normal_WorldSpace : NORMAL;
	float4 Pos_WorldSpace : TEXCOORD1;
	float4 Pos_CameraSpace : TEXCOORD2;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	// Convert vertice positions from object space to world space
	output.Pos_WorldSpace = mul( input.Pos, ObjectToWorld );
	// Convert vertice positions from world space to camera space
	output.Pos_CameraSpace = mul( output.Pos_WorldSpace, WorldToCamera );
	// Convert vertice positions from camera space to 2D projection
	output.Pos = mul( output.Pos_CameraSpace, CameraToImage );
	
	// Transform normals to world space
	output.Normal_WorldSpace = mul(input.Normal,(float3x3)ObjectToWorld);
	
	// Lerp the texture coordinates from MinUV to MaxUV
	output.Tex = lerp(MinUV,MaxUV,input.Tex.xy);
	
	// Give the vertex color multiplied with the instance color to the pixel shader
	output.Color = lerp(input.Color * InstanceColor, float4(0.0f,0.0f,1.0f,1.0f), input.Selected);
	
	return output;
}

//tex_0 is the diffuse texture

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	// If the camera has a world space cutting plane, clip on the negative side.
	UseCuttingPlane(input.Pos_WorldSpace)
	
	float4 finalColor = tex_0.Sample( samAnisotropicMipmap, input.Tex ) * input.Color;
	
	float3 DiffuseLight;
	float3 SpecularLight;
	Engine_GetDiffuseAndSpecularLight(input.Pos_WorldSpace,normalize(input.Normal_WorldSpace),30,DiffuseLight,SpecularLight);
	// finalColor = (finalColor * float4(DiffuseLight,1.0f)) + float4(SpecularLight,1.0f);
	finalColor = (finalColor * float4(DiffuseLight + SpecularLight,1.0f));
	
	// Show the final color with fog on R,G,B channels
	return float4((lerp(finalColor,FogColor,saturate(length(input.Pos_CameraSpace) / FogDistance) * MaxFogIntensity)).xyz,finalColor.w);
}
