
// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
};

// Arguments
#define HeightMapScale Arg[0].xy
#define HeightMapOffset Arg[0].zw

// Textures
#define HeightAndBlendMap tex_0

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	float2 Tex;
	float4 Pos_WorldSpace;
	float4 Pos_CameraSpace;
	
	// Convert vertice positions from object space to world space
	Pos_WorldSpace = mul( input.Pos, ObjectToWorld );
	
	// Get the texture coordinates
	Tex = (Pos_WorldSpace.xz / HeightMapScale) + HeightMapOffset;
	
	// Apply offset
	float4 HeightMap = HeightAndBlendMap.SampleLevel(samClampedConstant,Tex,0);
	Pos_WorldSpace.y = Pos_WorldSpace.y + HeightMap.r;
	
	// Convert vertice positions from world space to camera space
	Pos_CameraSpace = mul( Pos_WorldSpace, WorldToCamera );
	// Convert vertice positions from camera space to 2D projection
	output.Pos = mul( Pos_CameraSpace, CameraToImage );
	
	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	return float4(0.0f,1.0f,0.0f,1.0f);
}
