
// Returns the average of 4 linear interpolated samples from the input texture.
// It is used for extreme scaling from large to small surfaces but can also
// be used from small to large because it has linear interpolation.

float4 PS( VS_to_PS input) : SV_Target {
	return (tex_0.Sample( samClampedLinear, (PixelPos + float2(-0.4f, 0.2f)) / Dimensions )
	      + tex_0.Sample( samClampedLinear, (PixelPos + float2(0.2f, 0.4f)) / Dimensions )
	      + tex_0.Sample( samClampedLinear, (PixelPos + float2(0.4f, -0.2f)) / Dimensions )
	      + tex_0.Sample( samClampedLinear, (PixelPos + float2(-0.2f, -0.4f)) / Dimensions )) * 0.25f;
}
