
// Blending 2 textures by multiplying and adding.
// Use it for fading between images or stereoscopic 3D from 2 cameras.
// Returns (T0 * Arg[0]) + (T1 * Arg[1])

float4 PS( VS_to_PS input) : SV_Target {
	float4 ColorA = tex_0.Sample( samClampedLinear, PixelPos / Dimensions );
	float4 ColorB = tex_1.Sample( samClampedLinear, PixelPos / Dimensions );
	return (ColorA * Arg[0]) + (ColorB * Arg[1]);
}
