
// Blending 2 textures with a ratio given by the red channel in tex_2.
// Returns lerp(tex_0, tex_1, tex_2.Red)

float4 PS( VS_to_PS input) : SV_Target {
	float4 ColorA = tex_0.Sample( samClampedLinear, PixelPos / Dimensions );
	float4 ColorB = tex_1.Sample( samClampedLinear, PixelPos / Dimensions );
	float Mask = tex_2.Sample( samClampedLinear, PixelPos / Dimensions ).r;
	return lerp(ColorA,ColorB,Mask);
}
