
// Blending 4 textures by multiplying and adding.
// Returns (T0 * Arg[0]) + (T1 * Arg[1]) + (T2 * Arg[2]) + (T3 * Arg[3])

float4 PS( VS_to_PS input) : SV_Target {
	float4 ColorA = tex_0.Sample( samClampedLinear, PixelPos / Dimensions );
	float4 ColorB = tex_1.Sample( samClampedLinear, PixelPos / Dimensions );
	float4 ColorC = tex_2.Sample( samClampedLinear, PixelPos / Dimensions );
	float4 ColorD = tex_3.Sample( samClampedLinear, PixelPos / Dimensions );
	return (ColorA * Arg[0]) + (ColorB * Arg[1]) + (ColorC * Arg[2]) + (ColorD * Arg[3]);
}
