
// Circular hough transform.
// Useful after edge detection filters to detect circles in the image.

// tex_0 is the texture to sample from.
// Arg[0].x is the radius.
// Arg[0].y is the number of samples.

#define ADDSAMPLE(INDEX,WEIGHT) sum = sum + ((WEIGHT) * tex_0.Sample( samClampedLinear, (PixelPos + float2((float)(INDEX) * Arg[0].z,(float)(INDEX) * Arg[0].w)) / Dimensions ));
#define Radius Arg[0].x
#define PI 3.1415926535897932384626433832795f

float4 PS( VS_to_PS input) : SV_Target {
	int A; float Angle;
	int Angles = (int)floor(Arg[0].y);
	float4 Sum = float4(0.0f,0.0f,0.0f,0.0f);
	for(A = 0; A < Angles; A++) {
		Angle = (A * (PI * 2.0f)) / Angles;
		float2 UV = (PixelPos + float2(sin(Angle) * Radius,cos(Angle) * Radius)) / Dimensions;
		if (UV.x < 0.0f || UV.y < 0.0f || UV.x > 1.0f || UV.y > 1.0f) {
			// Ignore it as if black was sampled
		} else {
			Sum += tex_0.Sample( samClampedLinear, UV );
		}
		
	}
	return Sum / Angles;
}
