
// This is the first step of the distance transform.
// The radius of each obstacle is written in the red channel in tex_0.
// Everything that is not the center of an obstacle shoud be -1 in the red channel.
// Complete the distance transform by using PE_DistanceTransform_Iterate on the result multiple times.

#define ObstacleMap tex_0
#define HeightMap tex_1

float4 PS( VS_to_PS input) : SV_Target {
	float Radius = ObstacleMap.Sample( samClampedConstant, PixelPos / Dimensions ).r;
	float Height = HeightMap.Sample( samClampedConstant, PixelPos / Dimensions ).r;
	float HeightLeft = HeightMap.Sample( samClampedConstant, (PixelPos + float2(-1.0f,0.0f)) / Dimensions ).r;
	float HeightRight = HeightMap.Sample( samClampedConstant, (PixelPos + float2(1.0f,0.0f)) / Dimensions ).r;
	float HeightUp = HeightMap.Sample( samClampedConstant, (PixelPos + float2(0.0f,-1.0f)) / Dimensions ).r;
	float HeightDown = HeightMap.Sample( samClampedConstant, (PixelPos + float2(0.0f,1.0f)) / Dimensions ).r;
	float Wall = max(max(abs(HeightLeft-Height),abs(Height-HeightRight)),max(abs(HeightUp-Height),abs(Height-HeightDown)));
	float Distance;
	if (Radius > -0.5f) {
		// Obstacle
		Distance = -Radius;
	} else if (PixelPos.x < 1.0f || PixelPos.y < 1.0f || PixelPos.x > Dimensions.x - 1.0f || PixelPos.y > Dimensions.y - 1.0f ) {
		// Map edge
		Distance = 0.0f;
	} else if (Wall > 0.6f){
		// Wall of uneven ground
		Distance = 0.0f;
	} else {
		// No Obstacle
		Distance = 10000.0f;
	}
	return float4(Radius,Distance,PixelPos.x,PixelPos.y);
}
