// tex_0.r is the height above water
// tex_0.g is the amount of earth
// tex_0.b is the amount of grass
// tex_0.a is the amount of sand

float4 PS( VS_to_PS input) : SV_Target {
	float4 Original = tex_0.Sample( samClampedLinear, PixelPos / Dimensions );
	float EarthGrassRatio = saturate(lerp(-7.0f,8.0f,Original.g / (Original.g + Original.b)));
	float SandRatio = saturate(1.0f - Original.r);
	float EarthRatio = EarthGrassRatio * (1.0f - SandRatio);
	float GrassRatio = (1.0f - EarthGrassRatio) * (1.0f - SandRatio);
	return float4(Original.r,EarthRatio,GrassRatio,SandRatio);
}
