
// tex_0 must be a depth buffer by setting SubresourceType to 1 in PostEffect_GiveInputSurface.
// The result is the blur radius from the depth buffer in tex_0.

#define SharpDepth Arg[0].x
#define MaxRadius Arg[0].y

float4 PS( VS_to_PS input) : SV_Target {
	float LinearDepth = ZWCorrection[0].y / (tex_0.Sample( samClampedLinear, PixelPos / Dimensions ).x - ZWCorrection[0].x);
	
	return min(MaxRadius,abs(SharpDepth - LinearDepth) / LinearDepth);
}
