
// Blending 1 textures with itself many times.
// It is used for lens effects but not very reusable without modification.

void SampleImage ( in float2 Position, in float Scale, out float4 ReturnColor ) {
	float2 ScaledPosition;
	ScaledPosition = Position / Scale;
	ReturnColor = tex_0.Sample( samClampedLinear, 0.5f + ScaledPosition) * (1.0f - (length(ScaledPosition) * 2.0f));
}

float4 PS( VS_to_PS input) : SV_Target {
	float4 Color0; float4 Color1; float4 Color2; float4 Color3;
	float4 ColorBase = tex_0.Sample( samClampedLinear, PixelPos / Dimensions );
	float2 DestPos = (PixelPos / Dimensions) - 0.5f;
	SampleImage(DestPos,Arg[0].w,Color0);
	SampleImage(DestPos,Arg[1].w,Color1);
	SampleImage(DestPos,Arg[2].w,Color2);
	SampleImage(DestPos,Arg[3].w,Color3);
	return ColorBase + saturate((Color0 * Arg[0]) - 0.05f)
			 + saturate((Color1 * Arg[1]) - 0.05f)
			 + saturate((Color2 * Arg[2]) - 0.05f)
			 + saturate((Color3 * Arg[3]) - 0.05f);
}
