
// This linear blur shader takes the mean color of all pixels in a line.
//
// tex_0 is the texture to sample from.
// tex_1 is the blur size multiplier that use it's first channel to scale the interval.
// Arg[0].x is the start multiplier. (It may not be greater than 0)
// Arg[0].y is the end multiplier. (It may not be less than 0)
// Arg[0].z is the x offset made each step. (Only use -1.0f, 0.0f or 1.0f)
// Arg[0].w is the y offset made each step. (Only use -1.0f, 0.0f or 1.0f)
// 
// Use this post effect shader 4 times in different directions on a draw
//   surface with extra color buffer to make round bloom with extreme speed.
// 
// Example Arg[0] = (-1.5f, 2.0f, -1.0f, 1.0f)
//   Takes 5 samples in a diagonal line with one half sample in the negative end.
// 
//          0.5
//        1.0
//      1.0
//    1.0
//  1.0

#define ADDSAMPLE(INDEX,WEIGHT) sum = sum + ((WEIGHT) * tex_0.SampleLevel( samClampedConstant, (PixelPos + float2((float)(INDEX) * Arg[0].z,(float)(INDEX) * Arg[0].w)) / Dimensions, 0 ));

float4 PS( VS_to_PS input) : SV_Target {
	float4 sum; int i; int start; int end;
	float fractionAtStart; float fractionAtEnd;
	float scaleMultiplier = tex_1.Sample( samClampedLinear, PixelPos / Dimensions ).x;
	start = (int)ceil(Arg[0].x * scaleMultiplier);
	end = (int)floor(Arg[0].y * scaleMultiplier);
	fractionAtStart = start - (Arg[0].x * scaleMultiplier);
	fractionAtEnd = (Arg[0].y * scaleMultiplier) - end;
	sum = 0;
	if (fractionAtStart > 0.00001f) {
		ADDSAMPLE(start - 1,fractionAtStart)
	}
	for(i=start;i<=end;i++) {
		ADDSAMPLE(i,1)
	}
	if (fractionAtEnd > 0.00001f) {
		ADDSAMPLE(end + 1,fractionAtEnd)
	}
	return sum / ((end - start) + 1 + fractionAtStart + fractionAtEnd);
}
