
// Sample texture 0 with UV offset from R,G in texture 1
// Texture 0 is the diffuse map and texture 1 is the offset map.
// Arg[0].x will multiply the U offset.
// Arg[0].y will multiply the V offset.
// Arg[0].z will add to the U offset.
// Arg[0].w will add to the V offset.

#define SAMPLEONCE \
	UV = tex_1.Sample( samLinear, (PixelPos + MultisampleOffset) / Dimensions ) - float2(0.5f, 0.5f); \
	Sum = Sum + tex_0.Sample( samLinear, ((PixelPos + MultisampleOffset) / Dimensions) + ((UV * Arg[0].xy) + Arg[0].zw) );

float4 PS( VS_to_PS input) : SV_Target {
	float2 UV;
	float2 MultisampleOffset;
	float4 Sum;
	Sum = 0;
	MultisampleOffset = float2(-0.4f, 0.2f);
	SAMPLEONCE
	MultisampleOffset = float2(0.2f, 0.4f);
	SAMPLEONCE
	MultisampleOffset = float2(0.4f, -0.2f);
	SAMPLEONCE
	MultisampleOffset = float2(-0.2f, -0.4f);
	SAMPLEONCE
	return Sum * 0.25f;
}
