
// Returns a soft road presence in the red channel from the road UV map in tex_0

// The amount of the U coordinate that contain a road for each road type
#define LargeRoadRatio Arg[0].x
#define SmallRoadRatio Arg[0].y

#define RoadMap tex_0

float InverseLerp(float A, float B, float Value) {
	return (Value - A) / (B - A);
}

float Cubic(float X) {
	return (3 * pow(X, 2)) - (2 * pow(X, 3));
}

float4 PS( VS_to_PS input) : SV_Target {
	float4 OriginalRoadMap = RoadMap.Sample( samClampedLinear, PixelPos / Dimensions );
	float LargeRoad;
	float SmallRoad;
	if (OriginalRoadMap.b < 0.5f) {
		LargeRoad = InverseLerp(0.0f,0.5f - (LargeRoadRatio * 0.5f),OriginalRoadMap.b);
	} else {
		LargeRoad = InverseLerp(1.0f,0.5f + (LargeRoadRatio * 0.5f),OriginalRoadMap.b);
	}
	if (OriginalRoadMap.r < 0.5f) {
		SmallRoad = InverseLerp(0.0f,0.5f - (SmallRoadRatio * 0.5f),OriginalRoadMap.r);
	} else {
		SmallRoad = InverseLerp(1.0f,0.5f + (SmallRoadRatio * 0.5f),OriginalRoadMap.r);
	}
	float Presence = Cubic(max(saturate(LargeRoad),saturate(SmallRoad)));
	return float4(Presence,0.0f,0.0f,1.0f);
}
