
//Sobel edge detection in each channel separatelly
//Take the length, sum or maximum of RGB to convert the result to grayscale

#define SAMPLE(X,Y) tex_0.SampleLevel( samClampedConstant, (PixelPos + float2(X,Y)) / Dimensions, 0 )

float4 PS( VS_to_PS input) : SV_Target {
	float4 Gx = (SAMPLE(-1,-1) * -1) + (SAMPLE(1,-1) * 1)
		 + (SAMPLE(-1,0)  * -2) + (SAMPLE(1,0)  * 2)
		 + (SAMPLE(-1,1)  * -1) + (SAMPLE(1,1)  * 1);
	float4 Gy = (SAMPLE(-1,-1) * -1) + (SAMPLE(-1,1) * 1)
		 + (SAMPLE(0,-1)  * -2) + (SAMPLE(0,1)  * 2)
		 + (SAMPLE(1,-1)  * -1) + (SAMPLE(1,1)  * 1);
	return float4(length(float2(Gx.r,Gy.r)),length(float2(Gx.g,Gy.g)),length(float2(Gx.b,Gy.b)),length(float2(Gx.a,Gy.a)));
}
