VERSION 5.00
Object = "{FE69BD77-3946-4641-8613-6FC7144F2E05}#10.0#0"; "DFPGE10.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   ClientHeight    =   9090
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   12555
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   MouseIcon       =   "Main.frx":08CA
   MousePointer    =   99  'Custom
   ScaleHeight     =   9090
   ScaleWidth      =   12555
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin VB.Timer tmrFPS 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   10500
      Top             =   120
   End
   Begin VB.Timer tmrStart 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   10020
      Top             =   120
   End
   Begin DFPGELib.DFPGE DGE 
      Height          =   7155
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   9915
      Visible         =   0   'False
      _Version        =   655360
      _ExtentX        =   17489
      _ExtentY        =   12621
      _StockProps     =   0
   End
   Begin VB.Label lblLoading 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Loading"
      BeginProperty Font 
         Name            =   "Impact"
         Size            =   21.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   540
      Left            =   120
      TabIndex        =   1
      Top             =   7260
      Width           =   1410
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'To do:
'   Remove the bookshelf tile and create a system with collidable and movable objects.
'       A strong enough character should be able to pick them up.
'       This is important for explosive barrels.
'   Use the alpha channel in the map for AI.
'       1 will be a solid obstacle, 0.5 will be an obstacle that can be destroyed and 0 will be open space.
'       Obstacles that can be destroyed will have a large distance penalty in the AI since noone want to make a lot of noise for no reason.
'       For many to many pathfinding at a short distance, the GPU is more efficient.
'       For long distance path finding, the CPU can be more efficient by only traversing active tiles.
'   Handle gravity or remove fallpits as a plan B.
'   Make a tile that hold the roof while looking good.
'       If a random place have nothing holding the roof around it, place it there.
'       It will be a decorative tile that replace the floor base tile.
'   Design more wall and floor textures.
'   Make decorative and functional interior props.
'       Barracks:
'           Kitchen, bathroom and bedroom stuff that match the floor.
'       Horror:
'           Decorate the rooms with torture devices and skeletons.
'       Library:
'           Books and magic items.
'       Hallway
'           Creapy posters for the cult.
'   Make an implementation of A* for pathfinding.
'   Make static collision detection.
'   Make animated doors.
'       Doors can be 2 quads before opened to save rendering time.
'       Place keys to the doors on random locations and make it possible to break the doors.
'   Automatic pattern matching
'       Generate a list of base tile types for automated pattern matching when generating a level.
'           Check if the room ID is 0 or non 0 before pattern matching.
'       Generate a list of decorative tiles that will replace base tiles with the same pattern.
'           The designed tile patterns will be inherited from the base tiles.
'       Find a type of door base tile that matches the pattern of a non door base tile.
'           TileType_Wall will refer to TileType_Door.
'           Use the pattern to get the possible places for making a door and not just +ZAxis.
'           2 door tiles with the same pattern is pointless.
'           One tile may not have more than one door so that the game will know what door the player is trying to open.

Option Explicit

'You may change this
Const BloomSize As Single = 2.5
Const AmbientLight As Single = 0.5

'Depending on the tile models
Const WallRadius As Single = 0.125

'The main camera
Dim Camera_Main As Long
Dim CameraDistance As Single

'The mouse
Dim MouseOffset As Vector2

'Actors
Dim Model_Dummy As Long
Private Type Actor
    Instance As Long
    Longitude As Single
    Forward As Vector3
    Right As Vector3
    Pos As Vector3
    Vel As Vector3
    CollisionRadius As Single
End Type
Dim Player As Actor

'Tile types
Private Enum TimeFunction
    Linear
    Quadratic
End Enum
Private Enum AnimationBehaviour
    ForwardWhenActivated
    ForwardStop
    ForwardLoop
End Enum
Private Type TileType
    'Models
    Model_Static As Long
    Model_Moving As Long
    
    'Activation
    CanBeActive As Boolean
    StartActive As Boolean
    
    'Properties
    HasDoor As Boolean 'Allow walking to another room
    Outside As Match 'Used where RoomID = 0
    Base As Boolean 'Used for generating the shape of the level
    Invalid As Boolean 'Used to show that something is wrong
    
    'Animation
    Moving_StartPos As Vector3
    Moving_EndPos As Vector3
    Moving_StartHidden As Boolean
    Moving_EndHidden As Boolean
    Moving_StartWithLowDetailLevel As Boolean
    Moving_Behaviour As AnimationBehaviour
    Moving_Speed As Single
    Moving_TimeFunction As TimeFunction
    
    'Rules for what neighbours may have another room ID
    Pattern As NeighbourhoodMatch
    
    'What sides are we colliding against
    Collision As NeighbourhoodBoolean
End Type

'The goal is to remove these constants and generate levels with an arbitrary tile set.
'These values affect the order of matching and not the order that it is entered in.
Const TileType_BlackEnd As Long = 0
Const TileType_Floor As Long = 1
Const TileType_Corner As Long = 2
Const TileType_Edge As Long = 3
Const TileType_Edge2 As Long = 4
Const TileType_BookShelf As Long = 5
Const TileType_Door As Long = 6
Const TileType_FallPit As Long = 7
Const TileType_SpikeTrap As Long = 8
Const TileType_Wall As Long = 9
Const TileType_BlackRoof As Long = 10
Const TileType_Empty As Long = 11
Const TileType_BlackWall As Long = 12
Const TileType_BlackAlley As Long = 13
Const TileType_BlackCorner As Long = 14
Const TileType_Wall_Light_Bars As Long = 15
Const TileType_Wall_Light_Hallway As Long = 16
Const TileType_Wall_Light_Scull As Long = 17
Const TileType_Wall_Light_Octagon As Long = 18
Const TileType_Unknown As Long = 19
Const NumberOfTileTypes As Long = 20
Dim TileTypes(0 To NumberOfTileTypes - 1) As TileType

'Map
Const RoomID_Outside As Byte = 0
Const RoomID_Horror As Byte = 1
Const RoomID_Library As Byte = 2
Const RoomID_Kitchen As Byte = 3
Const RoomID_Hallway As Byte = 4
Const NumberOfRoomIDs As Byte = 5
Private Type TileInstance
    'Save this
    RoomID As Byte 'To move from one room to another, there must be a door on each side.
    TileTypeIndex As Integer
    Direction As Byte
    'Generate this from the saved data
    Instance_Static As Long
    Instance_Moving As Long
    VisibleTileTypeIndex As Integer
    HasLight As Boolean
    'Modify this when playing
    AnimationTime As Single
    MovingDirection As Single
    'Temporary for calculations
    LockedRoomID As Boolean 'The room ID is final and may not be changed any more.
End Type
Dim Tiles(0 To MapSizeX - 1, 0 To MapSizeZ - 1) As TileInstance
Dim TileTemplate As TileInstance 'Use this to reset a tile's memory to zero
Dim VisibleRect As TileRect
Dim ActiveTiles As TileSubset 'Used for animation
Dim CurrentTiles As TileQueue 'Used for traversing tiles

'References to draw durfaces for the bloom effect
Dim DrawSurface_D As Long 'Default draw surface
Dim DrawSurface_B As Long 'Blur draw surface with a lower resolution
Dim DrawSurface_Final As Long 'Final draw surface for showing the final image

'Rectangles in the light projection atlas
Dim AtlasRect_Bars As UVRect
Dim AtlasRect_OctagonPattern As UVRect
Dim AtlasRect_Scull As UVRect
Dim AtlasRect_Hallway As UVRect

'The player's map
Dim DrawSurface_Map As Long
Dim Model_Map As Long
Dim Instance_Map As Long

'Measure rendering speed
Dim TimePerFrame As Single 'The time it takes to do one cycle
Dim FPSCount As Long
Dim FPS As Long

'Instance texture slots as instance override is used in the models
Const InstanceTexture_Wall As Integer = 0 'Arbitrary wall textures will listen to channel 0 from the instance
Const InstanceTexture_Floor As Integer = 1 'Arbitrary floor textures will listen to channel 1 from the instance
Const NumberOfInstanceTextureChannels As Integer = 2

'Instance textures that are applied per instance instead of parts of models
Dim InstanceTexture(0 To NumberOfInstanceTextureChannels - 1, 0 To NumberOfRoomIDs - 1) As Long

Private Sub LoadThings()
    Static I As Long
    Static X As Long
    Static Z As Long
    
    'Set initial data
    VisibleRect.MinX = 0
    VisibleRect.MaxX = -1
    VisibleRect.MinZ = 0
    VisibleRect.MaxZ = -1
    For X = 0 To MapSizeX - 1
        For Z = 0 To MapSizeZ - 1
            Tiles(X, Z).VisibleTileTypeIndex = -1
        Next Z
    Next X
    
    'Allocate classes
    Set ActiveTiles = New TileSubset
    Set CurrentTiles = New TileQueue
    
    'Load and use our default material shader that will be used when something don't have a shader in the current shader channel
    SetDefaultMaterialShader "DefaultMaterialShader"
    
    'Load and use our default texture that is used when a texture is missing
    SetDefaultTexture "DefaultTexture"
    
    'Load textures for walls and floors
    InstanceTexture(InstanceTexture_Wall, RoomID_Horror) = LoadTexture("Stone")
    InstanceTexture(InstanceTexture_Floor, RoomID_Horror) = LoadTexture("Stone")
    InstanceTexture(InstanceTexture_Wall, RoomID_Library) = LoadTexture("Grass3")
    InstanceTexture(InstanceTexture_Floor, RoomID_Library) = LoadTexture("Wood")
    InstanceTexture(InstanceTexture_Wall, RoomID_Kitchen) = LoadTexture("Brick")
    InstanceTexture(InstanceTexture_Floor, RoomID_Kitchen) = LoadTexture("FloorPattern")
    InstanceTexture(InstanceTexture_Wall, RoomID_Hallway) = LoadTexture("Brick")
    InstanceTexture(InstanceTexture_Floor, RoomID_Hallway) = LoadTexture("Grass2")
    
    'Load and use our light projection atlas that is used for light projecting light sources
    SetLightProjectionAtlas "LightProjectionAtlas"
    AtlasRect_Bars = MakeUVRectForTileAtlas(0, 0, 2, 2)
    AtlasRect_OctagonPattern = MakeUVRectForTileAtlas(1, 0, 2, 2)
    AtlasRect_Scull = MakeUVRectForTileAtlas(0, 1, 2, 2)
    AtlasRect_Hallway = MakeUVRectForTileAtlas(1, 1, 2, 2)
    
    'Create a camera and take the reference number
    Camera_Main = DGE.Camera_Create: RE
    DGE.Camera_SetVerticalFOV_InDegrees Camera_Main, 60
    CameraDistance = 8
    
    'Get the version specific ID to the final draw surface
    DrawSurface_Final = DGE.DrawSurface_GetFinalOutput: RE
    
    'Set the background color that the fog will also have.
    DGE.Enviroment_SetBackgroundColor 0, 0, 0, 1
    
    'Set ambient light
    DGE.LightSource_SetAmbientLight AmbientLight, AmbientLight, AmbientLight: RE
    
    'Set the depth map resolution
    DGE.LightSource_SetDepthAtlasResolution 1024 * 4
    
    'Create directed light to make the ambient light look less flat
    DGE.LightSource_Create_Sun_Shadowless 0, -1, 0, 0.05, 0.05, 0.05
    
    'Load models and define the tile types
    DefineTileTypes
    
    'Create draw surfaces
    DrawSurface_D = DGE.DrawSurface_CreateAutoSized(1, 1, 0, 0, 1, True): RE 'Allow rendering a 3D scene to it but not using soft particles and allow rendering from and to itself.
    DrawSurface_B = DGE.DrawSurface_CreateAutoSized(0.25, 0.25, 0, 0, 0, True): RE 'Allow rendering from and to itself.
    
    'Create map
    DrawSurface_Map = DGE.DrawSurface_CreateFixed(PathfindingMapSizeX, PathfindingMapSizeZ, 0, False)
    Model_Map = GenerateMapModel(MaxViewRadius, MaxViewRadius + Max_Long(MapSizeX, MapSizeZ))
    Instance_Map = DGE.Instance_Create(Model_Map)
        DGE.Instance_SetUserDefinedData Instance_Map, 0, MapSizeX - 0.5, MapSizeZ - 0.5, 0.25, 0.25
        DGE.Instance_SetTextureOverride Instance_Map, 0, DrawSurface_Map
    
    'Create the player
    Model_Dummy = LoadModel("Model_Dummy")
    Player.Instance = DGE.Instance_Create(Model_Dummy)
    
    'Create the level
    GenerateRandomLevel
    
    'Load the post effects
    PostEffects_Init
    
    'Load resources for drawing
    DrawShader_Init
    
    'Start the module for mouse moves
    Mouse_Init
    
    lblLoading.Visible = False
    DGE.Visible = True
End Sub

Private Sub DefineTileTypes()
    'The base tiles should be declared with the strictest patterns first because the first match is used just like when using "elseif".
    Static TT As Long
    TT = TileType_Floor
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Floor"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_false, Match_false, Match_false)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Base = True
        TileTypes(TT).Outside = Match_false
    TT = TileType_Corner
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Corner"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_any, Match_true, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, True, False, True, False)
        TileTypes(TT).Base = True
        TileTypes(TT).Outside = Match_false
    TT = TileType_Edge
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Edge"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_true, Match_false, Match_false)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, True, False, False)
        TileTypes(TT).Base = True
        TileTypes(TT).Outside = Match_false
    TT = TileType_Edge2
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Edge2"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_true, Match_false, Match_false, Match_false, Match_true, Match_false, Match_false)
        TileTypes(TT).Collision = MakeNB(False, True, False, False, False, True, False, False)
        TileTypes(TT).Base = True
        TileTypes(TT).Outside = Match_false
    TT = TileType_Wall
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Wall"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, True, False)
        TileTypes(TT).Base = True
        TileTypes(TT).Outside = Match_false
    TT = TileType_Wall_Light_Bars
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Wall_Light_Bars"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, True, False)
        TileTypes(TT).Base = False
        TileTypes(TT).Outside = Match_false
    TT = TileType_Wall_Light_Hallway
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Wall_Light_Hallway"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, True, False)
        TileTypes(TT).Base = False
        TileTypes(TT).Outside = Match_false
    TT = TileType_Wall_Light_Scull
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Wall_Light_Scull"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, True, False)
        TileTypes(TT).Base = False
        TileTypes(TT).Outside = Match_false
    TT = TileType_Wall_Light_Octagon
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Wall_Light_Octagon"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, True, False)
        TileTypes(TT).Base = False
        TileTypes(TT).Outside = Match_false
    TT = TileType_BookShelf
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_BookShelf"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, True, False)
        TileTypes(TT).Outside = Match_false
    TT = TileType_Door
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Door"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, True, False, True)
        TileTypes(TT).HasDoor = True
        TileTypes(TT).Outside = Match_false
    TT = TileType_FallPit
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_FallPit"): DoEvents
        TileTypes(TT).Model_Moving = LoadModel("Model_Tile_FallPit_Moving"): DoEvents
        TileTypes(TT).Moving_StartPos = MakeVector3(0, 0, 0)
        TileTypes(TT).Moving_EndPos = MakeVector3(0, -2, 0)
        TileTypes(TT).Moving_EndHidden = True
        TileTypes(TT).Moving_StartWithLowDetailLevel = True
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_false, Match_false, Match_false)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Outside = Match_false
        TileTypes(TT).CanBeActive = True
        TileTypes(TT).Moving_Behaviour = ForwardStop
        TileTypes(TT).Moving_TimeFunction = Quadratic
        TileTypes(TT).Moving_Speed = 1
    TT = TileType_SpikeTrap
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_SpikeTrap"): DoEvents
        TileTypes(TT).Model_Moving = LoadModel("Model_Tile_SpikeTrap_Moving"): DoEvents
        TileTypes(TT).Moving_StartPos = MakeVector3(0, -0.6, 0)
        TileTypes(TT).Moving_EndPos = MakeVector3(0, 0, 0)
        TileTypes(TT).Moving_StartHidden = True
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_false, Match_false, Match_false, Match_false, Match_false, Match_false, Match_false)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Outside = Match_false
        TileTypes(TT).CanBeActive = True
        TileTypes(TT).Moving_Behaviour = ForwardWhenActivated
        TileTypes(TT).Moving_TimeFunction = Linear
        TileTypes(TT).Moving_Speed = 8
    TT = TileType_BlackRoof
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_BlackRoof"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_true, Match_any, Match_true, Match_any, Match_true, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Base = True
        TileTypes(TT).Outside = Match_true
    TT = TileType_Empty
        TileTypes(TT).Model_Static = 0
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_any, Match_false, Match_any, Match_false, Match_any, Match_false, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Outside = Match_true
        TileTypes(TT).Base = True
    TT = TileType_BlackWall
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_BlackWall"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_any, Match_false, Match_any, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Outside = Match_true
        TileTypes(TT).Base = True
    TT = TileType_BlackAlley
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_BlackAlley"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_any, Match_true, Match_any, Match_false, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Outside = Match_true
        TileTypes(TT).Base = True
    TT = TileType_BlackCorner
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_BlackCorner"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_false, Match_any, Match_false, Match_any, Match_true, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Outside = Match_true
        TileTypes(TT).Base = True
    TT = TileType_BlackEnd
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_BlackEnd"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_true, Match_any, Match_false, Match_any, Match_true, Match_any, Match_true, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Outside = Match_true
        TileTypes(TT).Base = True
    TT = TileType_Unknown
        TileTypes(TT).Model_Static = LoadModel("Model_Tile_Unknown"): DoEvents
        TileTypes(TT).Pattern = MakeNM(Match_any, Match_any, Match_any, Match_any, Match_any, Match_any, Match_any, Match_any)
        TileTypes(TT).Collision = MakeNB(False, False, False, False, False, False, False, False)
        TileTypes(TT).Outside = Match_any
        TileTypes(TT).Base = True
        TileTypes(TT).Invalid = True
End Sub

Private Function GenerateMapModel(InnerRadius As Single, OutterRadius As Single) As Long
    Static Part As Long
    Static Tri As Long
    GenerateMapModel = DGE.Model_CreateEmpty
    InsertStringToEngine "Map": Part = DGE.Model_Part_Create_InSB(GenerateMapModel, 8)
    InsertStringToEngine "M_Map": DGE.Model_Part_SetShader_ByName_InSB GenerateMapModel, Part, 0
    InsertStringToEngine "MapTexture": DGE.Model_Part_SetTexture_ByName_InSB GenerateMapModel, Part, 1
    DGE.Model_Part_SetTextureOverride GenerateMapModel, Part, 0, 0
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -OutterRadius, 0.1, -OutterRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, 0.1, -InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, InnerRadius, 0.1, -InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -OutterRadius, 0.1, -OutterRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, InnerRadius, 0.1, -InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, OutterRadius, 0.1, -OutterRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -InnerRadius, 0.1, -InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, -1, -InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 1, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, InnerRadius, 0.1, -InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -InnerRadius, -1, -InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 0, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, InnerRadius, -1, -InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 1, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, InnerRadius, 0.1, -InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -OutterRadius, 0.1, OutterRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, 0.1, InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, -InnerRadius, 0.1, -InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -OutterRadius, 0.1, OutterRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, 0.1, -InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, -OutterRadius, 0.1, -OutterRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -InnerRadius, 0.1, InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, -1, InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 1, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, -InnerRadius, 0.1, -InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -InnerRadius, -1, InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 0, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, -1, -InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 1, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, -InnerRadius, 0.1, -InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, OutterRadius, 0.1, OutterRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, InnerRadius, 0.1, InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, -InnerRadius, 0.1, InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, OutterRadius, 0.1, OutterRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, 0.1, InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, -OutterRadius, 0.1, OutterRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, InnerRadius, 0.1, InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, InnerRadius, -1, InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 1, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, -InnerRadius, 0.1, InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, InnerRadius, -1, InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 0, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, -1, InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 1, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, -InnerRadius, 0.1, InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, OutterRadius, 0.1, -OutterRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, InnerRadius, 0.1, -InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, InnerRadius, 0.1, InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, OutterRadius, 0.1, -OutterRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, InnerRadius, 0.1, InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, OutterRadius, 0.1, OutterRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, InnerRadius, 0.1, -InnerRadius
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, InnerRadius, -1, -InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 1, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, InnerRadius, 0.1, InnerRadius
    Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, InnerRadius, -1, -InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 0, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, InnerRadius, -1, InnerRadius
        DGE.Model_Part_Vertice_SetColor GenerateMapModel, Part, Tri, 1, 0, 0, 0, 1
        DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, InnerRadius, 0.1, InnerRadius
    If Debug_Map Then
        Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
            DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, -InnerRadius, -0.95, -InnerRadius
            DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, -0.95, InnerRadius
            DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, InnerRadius, -0.95, -InnerRadius
        Tri = DGE.Model_Part_InsertTriangle(GenerateMapModel, Part)
            DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 0, InnerRadius, -0.95, -InnerRadius
            DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 1, -InnerRadius, -0.95, InnerRadius
            DGE.Model_Part_Vertice_SetPos GenerateMapModel, Part, Tri, 2, InnerRadius, -0.95, InnerRadius
    End If
End Function

Private Sub SetVisibleRect(NewRect As TileRect)
    Static X As Long
    Static Z As Long
    Static OldRect As TileRect
    If TileRect_IsEqual(VisibleRect, NewRect) = False Then
        If TileRect_Overlap(VisibleRect, NewRect) Then
            'Remember the old rectangle
            OldRect = VisibleRect
            
            'Set the new value
            VisibleRect = NewRect
            
            'Hide tiles that belong to the old visible area but not the new visible area
            'This method assume that the rectangles are overlapping each other
                'Left
                For X = OldRect.MinX To NewRect.MinX - 1
                    For Z = OldRect.MinZ To OldRect.MaxZ
                        Debug.Assert TileRect_Inside(OldRect, X, Z) = True
                        Debug.Assert TileRect_Inside(NewRect, X, Z) = False
                        SetTileVisibility X, Z, False
                    Next Z
                Next X
                'Right
                For X = NewRect.MaxX + 1 To OldRect.MaxX
                    For Z = OldRect.MinZ To OldRect.MaxZ
                        Debug.Assert TileRect_Inside(OldRect, X, Z) = True
                        Debug.Assert TileRect_Inside(NewRect, X, Z) = False
                        SetTileVisibility X, Z, False
                    Next Z
                Next X
                'Top
                For X = Max_Long(OldRect.MinX, NewRect.MinX) To Min_Long(OldRect.MaxX, NewRect.MaxX)
                    For Z = OldRect.MinZ To NewRect.MinZ - 1
                        Debug.Assert TileRect_Inside(OldRect, X, Z) = True
                        Debug.Assert TileRect_Inside(NewRect, X, Z) = False
                        SetTileVisibility X, Z, False
                    Next Z
                Next X
                'Bottom
                For X = Max_Long(OldRect.MinX, NewRect.MinX) To Min_Long(OldRect.MaxX, NewRect.MaxX)
                    For Z = NewRect.MaxZ + 1 To OldRect.MaxZ
                        Debug.Assert TileRect_Inside(OldRect, X, Z) = True
                        Debug.Assert TileRect_Inside(NewRect, X, Z) = False
                        SetTileVisibility X, Z, False
                    Next Z
                Next X
            
            'Show tiles that belong to the new visible area but not the old visible area
            'This method assume that the rectangles are overlapping each other
                'Left
                For X = NewRect.MinX To OldRect.MinX - 1
                    For Z = NewRect.MinZ To NewRect.MaxZ
                        Debug.Assert TileRect_Inside(OldRect, X, Z) = False
                        Debug.Assert TileRect_Inside(NewRect, X, Z) = True
                        SetTileVisibility X, Z, True
                    Next Z
                Next X
                'Right
                For X = OldRect.MaxX + 1 To NewRect.MaxX
                    For Z = NewRect.MinZ To NewRect.MaxZ
                        Debug.Assert TileRect_Inside(OldRect, X, Z) = False
                        Debug.Assert TileRect_Inside(NewRect, X, Z) = True
                        SetTileVisibility X, Z, True
                    Next Z
                Next X
                'Top
                For X = Max_Long(OldRect.MinX, NewRect.MinX) To Min_Long(OldRect.MaxX, NewRect.MaxX)
                    For Z = NewRect.MinZ To OldRect.MinZ - 1
                        Debug.Assert TileRect_Inside(OldRect, X, Z) = False
                        Debug.Assert TileRect_Inside(NewRect, X, Z) = True
                        SetTileVisibility X, Z, True
                    Next Z
                Next X
                'Bottom
                For X = Max_Long(OldRect.MinX, NewRect.MinX) To Min_Long(OldRect.MaxX, NewRect.MaxX)
                    For Z = OldRect.MaxZ + 1 To NewRect.MaxZ
                        Debug.Assert TileRect_Inside(OldRect, X, Z) = False
                        Debug.Assert TileRect_Inside(NewRect, X, Z) = True
                        SetTileVisibility X, Z, True
                    Next Z
                Next X
        Else
            'This method always works but must loop thru tiles that we don't need to change if the old and new visible rectangle is overlapping
            
            'Hide the old rectangle
            SetVisibleRectVisibility False
            
            'Set the new value
            VisibleRect = NewRect
            
            'Show the old rectangle
            SetVisibleRectVisibility True
        End If
    End If
End Sub

'Place Instance according to Direction
Private Sub SetTileDirection(Instance As Long, Direction As Byte)
    Static XAxis As Vector3
    Static ZAxis As Vector3
    XAxis = GetXAxisFromDirection_Vector3(Direction)
    ZAxis = GetZAxisFromDirection_Vector3(Direction)
    frmMain.DGE.Instance_SetXAxis Instance, XAxis.X, XAxis.Y, XAxis.Z: RE
    frmMain.DGE.Instance_SetYAxis Instance, 0, 1, 0: RE
    frmMain.DGE.Instance_SetZAxis Instance, ZAxis.X, ZAxis.Y, ZAxis.Z: RE
End Sub

Private Sub DGE_KeyDown(KeyCode As Integer, Shift As Integer)
    'Exit the application when escape is pressed
    If KeyCode = vbKeyEscape Then
        'Exit the game and automatically terminate the engine
        End
    ElseIf KeyCode = vbKeyR Then
        'Randomize the level
        GenerateRandomLevel
    End If
End Sub

Private Sub Form_Load()
    Randomize Timer
    If StartEngine Then
        'Set the default folder so that relative paths can be used
        SetRelativeWorkingDirectory "..\CommonMediaFiles"
        
        'We start a timer to let this routine exit before we render anything
        'The graphical user interface will not be drawn until Form_Load has finished and therefor the main loop can't be placed in Form_Load
        tmrStart.Enabled = True
    End If
End Sub

'Returns the RoomID for the tile at (X,Z)
'Returns 0 when (X,Z) is outside of the tile map
Private Function GetRoomID_Safe(ByVal X As Long, ByVal Z As Long) As Byte
    If X < 0 Or X >= MapSizeX Or Z < 0 Or Z >= MapSizeZ Then
        GetRoomID_Safe = 0
    Else
        GetRoomID_Safe = Tiles(X, Z).RoomID
    End If
End Function

Private Sub SetVisibleRectVisibility(Visible As Boolean)
    Static X As Long
    Static Z As Long
    
    'Hide the visible rectangle of tiles
    For X = VisibleRect.MinX To VisibleRect.MaxX
        For Z = VisibleRect.MinZ To VisibleRect.MaxZ
            SetTileVisibility X, Z, Visible
        Next Z
    Next X
End Sub

Private Sub SetTileTypeUsingRoomID(Rect As TileRect, OnlyUnlockedTiles As Boolean)
    Static CurrentRoom As Byte
    Static NewTileTypeIndex As Byte
    Static NewDirection As Byte
    Static OtherRoom As NeighbourhoodBoolean
    Static MatchingOffset As Byte
    Static X As Long
    Static Z As Long
    Static ZAxiz As TileVector
    Static T As Long
    For X = Rect.MinX To Rect.MaxX
        For Z = Rect.MinZ To Rect.MaxZ
            If OnlyUnlockedTiles = False Or Tiles(X, Z).LockedRoomID = False Then
                CurrentRoom = GetRoomID_Safe(X, Z)
                NewDirection = 0
                
                'Compare room ID with the 8 neighbours
                OtherRoom = MakeNB(GetRoomID_Safe(X + 1, Z) <> CurrentRoom, GetRoomID_Safe(X + 1, Z - 1) <> CurrentRoom, GetRoomID_Safe(X, Z - 1) <> CurrentRoom, GetRoomID_Safe(X - 1, Z - 1) <> CurrentRoom, GetRoomID_Safe(X - 1, Z) <> CurrentRoom, GetRoomID_Safe(X - 1, Z + 1) <> CurrentRoom, GetRoomID_Safe(X, Z + 1) <> CurrentRoom, GetRoomID_Safe(X + 1, Z + 1) <> CurrentRoom)
                
                'Find the first base tile type that can be mapped
                For T = 0 To NumberOfTileTypes - 1
                    If TileTypes(T).Base And MatchTruth(TileTypes(T).Outside, (CurrentRoom = 0)) Then
                        MatchingOffset = Neighbourhood_Match(OtherRoom, TileTypes(T).Pattern)
                        If MatchingOffset < 255 Then
                            NewTileTypeIndex = T
                            NewDirection = MatchingOffset
                            Exit For
                        End If
                    End If
                Next T
                Tiles(X, Z).TileTypeIndex = NewTileTypeIndex
                Tiles(X, Z).Direction = NewDirection
            End If
        Next Z
    Next X
End Sub

Private Sub UpdateTileGraphics(Rect As TileRect)
    Static X As Long
    Static Z As Long
    For X = Max_Long(VisibleRect.MinX, Rect.MinX) To Min_Long(VisibleRect.MaxX, Rect.MaxX)
        For Z = Max_Long(VisibleRect.MinZ, Rect.MinZ) To Min_Long(VisibleRect.MaxZ, Rect.MaxZ)
            If Tiles(X, Z).TileTypeIndex <> Tiles(X, Z).VisibleTileTypeIndex Then
                SetTileVisibility X, Z, False
                SetTileVisibility X, Z, True
            End If
        Next Z
    Next X
End Sub

Private Sub Form_Resize()
    'Scale the component to cover the screen
    DGE.Width = Screen.Width
    DGE.Height = Screen.Height
    lblLoading.Left = (Screen.Width - lblLoading.Width) / 2
    lblLoading.Top = (Screen.Height - lblLoading.Height) / 2
End Sub

Private Sub tmrFPS_Timer()
    FPS = FPSCount
    FPSCount = 0
End Sub

Private Sub tmrStart_Timer()
    Static TenCycleStartTime As Single
    Static CycleCount As Long
    tmrStart.Enabled = False
    LoadThings
    tmrFPS.Enabled = True
    Do
        'Start 10 frame counting
        If CycleCount = 0 Then TenCycleStartTime = Timer
        
        'Run game logic and graphics
        DoStuff
        
        'Give time to the system
        DoEvents
        
        'Count number of frames per second for statistics
        FPSCount = FPSCount + 1
        
        'End 10 frame counting
        CycleCount = CycleCount + 1
        If CycleCount = 10 Then
            If Timer > TenCycleStartTime Then
                'Only update if the time was positive to remove overflow during midnight.
                TimePerFrame = (Timer - TenCycleStartTime) / 10
            End If
            CycleCount = 0
        End If
    Loop
End Sub

Private Sub UpdateSquareFromRoomIDToGraphics(CenterX As Long, CenterZ As Long, Radius As Long)
    SetTileTypeUsingRoomID MakeSafeTileRect(CenterX - 1, CenterX + Radius, CenterZ - Radius, CenterZ + Radius), False
    UpdateTileGraphics MakeSafeTileRect(CenterX - 1, CenterX + Radius, CenterZ - Radius, CenterZ + Radius)
End Sub

Private Sub GenerateRandomLevel()
    Static I As Long
    Static LengthX As Long
    Static LengthZ As Long
    Static StartX As Long
    Static StartZ As Long
    Static X As Long
    Static Z As Long
    Static X2 As Long
    Static Z2 As Long
    Static RoomID
    Static Changed As Boolean
    Static ZAxis As TileVector
    Static NegZAxis As TileVector
    Static Color As Vector3
    Static ImageRect As UVRect
    Static Neighbour As Byte
    Static NewTileType As Byte
    Static Slopes As Single
    Static DirY As Single
    
    'Hide the map
    SetVisibleRectVisibility False
    
    'Clear the map
    Light_Reset
    ActiveTiles.Reset
    For X = 0 To MapSizeX - 1
        For Z = 0 To MapSizeZ - 1
            Tiles(X, Z) = TileTemplate
        Next Z
    Next X
    
    'Create rooms without touching the edges of the map
    For I = 1 To MapSizeX * MapSizeZ * 0.06
        If Rnd < 0.2 Then
            RoomID = 0
        Else
            RoomID = Int(Rnd * 3) + 1
        End If
        LengthX = Int(Rnd * 8) + 2
        LengthZ = Int(Rnd * 8) + 2
        StartX = Int(Rnd * (MapSizeX - 2 - LengthX)) + 1
        StartZ = Int(Rnd * (MapSizeZ - 2 - LengthZ)) + 1
        For X = StartX To StartX + LengthX
            For Z = StartZ To StartZ + LengthZ
                Tiles(X, Z).RoomID = RoomID
            Next Z
        Next X
    Next I
    
    'Create a hallway
    Static StartCorner As TileVector
    Static EndCorner As TileVector
    StartCorner.X = MapSizeX * 0.25
    StartCorner.Z = MapSizeZ * 0.25
    EndCorner.X = (MapSizeX * 0.75) - 3
    EndCorner.Z = (MapSizeZ * 0.75) - 3
    For X = StartCorner.X To EndCorner.X + 3
        For Z = StartCorner.X To StartCorner.X + 3
            Tiles(X, Z).RoomID = RoomID_Hallway
            Tiles(X, Z).LockedRoomID = True
        Next Z
    Next X
    For X = StartCorner.X To EndCorner.X + 3
        For Z = EndCorner.X To EndCorner.X + 3
            Tiles(X, Z).RoomID = RoomID_Hallway
            Tiles(X, Z).LockedRoomID = True
        Next Z
    Next X
    For X = StartCorner.X To StartCorner.X + 3
        For Z = StartCorner.X To EndCorner.X + 3
            Tiles(X, Z).RoomID = RoomID_Hallway
            Tiles(X, Z).LockedRoomID = True
        Next Z
    Next X
    For X = EndCorner.X To EndCorner.X + 3
        For Z = StartCorner.X To EndCorner.X + 3
            Tiles(X, Z).RoomID = RoomID_Hallway
            Tiles(X, Z).LockedRoomID = True
        Next Z
    Next X
    
    'Try to map to the tile set using pattern matching
    SetTileTypeUsingRoomID MakeSafeTileRect(0, MapSizeX - 1, 0, MapSizeZ - 1), False
    
    'Change tiles that could not be mapped in random order
    For I = 1 To MapSizeX * MapSizeZ * 5
        X = Int(Rnd * (MapSizeX - 2)) + 1
        Z = Int(Rnd * (MapSizeZ - 2)) + 1
        If TileTypes(Tiles(X, Z).TileTypeIndex).Invalid And Tiles(X, Z).LockedRoomID = False Then
            'Change the unmapped tile
            If Tiles(X, Z).RoomID <> GetRoomID_Safe(X + 1, Z) And GetRoomID_Safe(X + 1, Z) > 0 Then
                Tiles(X, Z).RoomID = GetRoomID_Safe(X + 1, Z)
            ElseIf Tiles(X, Z).RoomID <> GetRoomID_Safe(X - 1, Z) And GetRoomID_Safe(X - 1, Z) > 0 Then
                Tiles(X, Z).RoomID = GetRoomID_Safe(X - 1, Z)
            ElseIf Tiles(X, Z).RoomID <> GetRoomID_Safe(X, Z + 1) And GetRoomID_Safe(X, Z + 1) > 0 Then
                Tiles(X, Z).RoomID = GetRoomID_Safe(X, Z + 1)
            ElseIf Tiles(X, Z).RoomID <> GetRoomID_Safe(X, Z - 1) And GetRoomID_Safe(X, Z - 1) > 0 Then
                Tiles(X, Z).RoomID = GetRoomID_Safe(X, Z - 1)
            ElseIf Tiles(X, Z).RoomID <> GetRoomID_Safe(X + 1, Z) Then
                Tiles(X, Z).RoomID = GetRoomID_Safe(X + 1, Z)
            ElseIf Tiles(X, Z).RoomID <> GetRoomID_Safe(X - 1, Z) Then
                Tiles(X, Z).RoomID = GetRoomID_Safe(X - 1, Z)
            ElseIf Tiles(X, Z).RoomID <> GetRoomID_Safe(X, Z + 1) Then
                Tiles(X, Z).RoomID = GetRoomID_Safe(X, Z + 1)
            ElseIf Tiles(X, Z).RoomID <> GetRoomID_Safe(X, Z - 1) Then
                Tiles(X, Z).RoomID = GetRoomID_Safe(X, Z - 1)
            ElseIf Tiles(X, Z).RoomID > 0 And Rnd < 0.4 Then
                Tiles(X, Z).RoomID = 0
            End If
    
            'Map tiles that may have changed
            SetTileTypeUsingRoomID MakeSafeTileRect(X - 1, X + 1, Z - 1, Z + 1), False
        End If
    Next I
    
    'Make sure that all tiles can be mapped or leave unmapped tiles after 100 attempts
    For I = 1 To 100
        Changed = False
        For X = 1 To MapSizeX - 2
            For Z = 1 To MapSizeZ - 2
                If TileTypes(Tiles(X, Z).TileTypeIndex).Invalid And Tiles(X, Z).LockedRoomID = False Then
                    'Change the unmapped tile
                    If Rnd < 0.5 Then
                        If Rnd < 0.5 Then
                            Neighbour = GetRoomID_Safe(X + 1, Z)
                        Else
                            Neighbour = GetRoomID_Safe(X, Z + 1)
                        End If
                    Else
                        If Rnd < 0.5 Then
                            Neighbour = GetRoomID_Safe(X - 1, Z)
                        Else
                            Neighbour = GetRoomID_Safe(X, Z - 1)
                        End If
                    End If
    
                    If Tiles(X, Z).RoomID <> Neighbour Then
                        Tiles(X, Z).RoomID = Neighbour
                    Else
                        Tiles(X, Z).RoomID = 0
                    End If
    
                    'Map tiles that may have changed
                    SetTileTypeUsingRoomID MakeSafeTileRect(X - 1, X + 1, Z - 1, Z + 1), False
    
                    'Remember that we changed something and have to repeat the method at least once again
                    Changed = True
                End If
            Next Z
        Next X
        If Changed = False Then Exit For
    Next I
    
    'Place doors
    For I = 1 To MapSizeX * MapSizeZ * 0.4
        X = Int(Rnd * (MapSizeX - 2)) + 1
        Z = Int(Rnd * (MapSizeZ - 2)) + 1
        'An algorithm in the beginning will search for doors with the same pattern as the base tiles that are not doors.
        If Tiles(X, Z).TileTypeIndex = TileType_Wall Then
            If DoorExist(MakeSafeTileRect(X - 2, X + 2, Z - 2, Z + 2), Tiles(X, Z).RoomID) = False Then
                ZAxis = GetZAxisFromDirection_TileVector(Tiles(X, Z).Direction)
                X2 = X + ZAxis.X
                Z2 = Z + ZAxis.Z
                If Tiles(X2, Z2).TileTypeIndex = TileType_Wall Then
                    Tiles(X, Z).TileTypeIndex = TileType_Door
                    Tiles(X2, Z2).TileTypeIndex = TileType_Door
                End If
            End If
        End If
    Next I
    
    'Fill the current list with locked tiles
    CurrentTiles.Reset
    For X = 1 To MapSizeX - 2
        For Z = 1 To MapSizeZ - 2
            If Tiles(X, Z).LockedRoomID Then
                CurrentTiles.InsertTile X, Z
            End If
        Next Z
    Next X
    'Traverse until everything reachable has been reached
    Do Until CurrentTiles.GetNumberOfTiles <= 0
        X = CurrentTiles.GetOldestTileX
        Z = CurrentTiles.GetOldestTileZ
        Debug.Assert Tiles(X, Z).LockedRoomID = True
        If X + 1 < MapSizeX Then
            If (Tiles(X, Z).RoomID = Tiles(X + 1, Z).RoomID Or (TileTypes(Tiles(X, Z).TileTypeIndex).HasDoor And TileTypes(Tiles(X + 1, Z).TileTypeIndex).HasDoor)) And Tiles(X + 1, Z).LockedRoomID = False Then
                Tiles(X + 1, Z).LockedRoomID = True
                CurrentTiles.InsertTile X + 1, Z
            End If
        End If
        If Z + 1 < MapSizeZ Then
            If (Tiles(X, Z).RoomID = Tiles(X, Z + 1).RoomID Or (TileTypes(Tiles(X, Z).TileTypeIndex).HasDoor And TileTypes(Tiles(X, Z + 1).TileTypeIndex).HasDoor)) And Tiles(X, Z + 1).LockedRoomID = False Then
                Tiles(X, Z + 1).LockedRoomID = True
                CurrentTiles.InsertTile X, Z + 1
            End If
        End If
        If X - 1 >= 0 Then
            If (Tiles(X, Z).RoomID = Tiles(X - 1, Z).RoomID Or (TileTypes(Tiles(X, Z).TileTypeIndex).HasDoor And TileTypes(Tiles(X - 1, Z).TileTypeIndex).HasDoor)) And Tiles(X - 1, Z).LockedRoomID = False Then
                Tiles(X - 1, Z).LockedRoomID = True
                CurrentTiles.InsertTile X - 1, Z
            End If
        End If
        If Z - 1 >= 0 Then
            If (Tiles(X, Z).RoomID = Tiles(X, Z - 1).RoomID Or (TileTypes(Tiles(X, Z).TileTypeIndex).HasDoor And TileTypes(Tiles(X, Z - 1).TileTypeIndex).HasDoor)) And Tiles(X, Z - 1).LockedRoomID = False Then
                Tiles(X, Z - 1).LockedRoomID = True
                CurrentTiles.InsertTile X, Z - 1
            End If
        End If
        CurrentTiles.RemoveOldestTile
    Loop
    'Remove rooms that are unreachable from the locked tiles
    For X = 1 To MapSizeX - 2
        For Z = 1 To MapSizeZ - 2
            If Tiles(X, Z).LockedRoomID = False Then
                Tiles(X, Z).RoomID = 0
            End If
        Next Z
    Next X
    'Update the tile graphics without removing the doors
    SetTileTypeUsingRoomID MakeSafeTileRect(0, MapSizeX - 1, 0, MapSizeZ - 1), True
    
    'Place light sources
    For X = 1 To MapSizeX - 2
        For Z = 1 To MapSizeZ - 2
            If Rnd < 0.4 Then
                If LightExist(MakeSafeTileRect(X - 5, X + 5, Z - 5, Z + 5), Tiles(X, Z).RoomID) = False Then
                    Select Case Tiles(X, Z).RoomID
                    Case RoomID_Horror
                        Color = MakeVector3(6, 1, 1)
                        ImageRect = AtlasRect_Scull
                        NewTileType = TileType_Wall_Light_Scull
                        Slopes = 1.5
                        DirY = -0.5
                    Case RoomID_Library
                        Color = MakeVector3(3, 3, 1)
                        ImageRect = AtlasRect_OctagonPattern
                        NewTileType = TileType_Wall_Light_Octagon
                        Slopes = 2
                        DirY = 0
                    Case RoomID_Kitchen
                        Color = MakeVector3(1, 3, 3)
                        ImageRect = AtlasRect_Bars
                        NewTileType = TileType_Wall_Light_Bars
                        Slopes = 2.5
                        DirY = 0
                    Case RoomID_Hallway
                        Color = MakeVector3(2, 2, 2)
                        ImageRect = AtlasRect_Hallway
                        NewTileType = TileType_Wall_Light_Hallway
                        Slopes = 2.5
                        DirY = 0
                    End Select
                    If ReplaceTileType(X, Z, NewTileType) Then
                        ZAxis = GetZAxisFromDirection_TileVector(Tiles(X, Z).Direction)
                        NegZAxis = MakeTileVector(-ZAxis.X, -ZAxis.Z)
                        If Graphics_DynamicLight Then
                            Light_Insert_SpotLight MakeVector3(X + (ZAxis.X * 0.49), 0.5, Z + (ZAxis.Z * 0.49)), NegZAxis, Color, ImageRect, 5, Slopes, DirY
                        End If
                        Tiles(X, Z).HasLight = True
                    ElseIf WallsExist(MakeSafeTileRect(X - 2, X + 2, Z - 2, Z + 2)) = False Then
                        If Graphics_DynamicLight Then
                            Light_Insert_PointLight MakeVector3((X), 0.9, (Z)), MulVector3(Color, 0.5), 4
                        End If
                        Tiles(X, Z).HasLight = True
                    End If
                End If
            End If
        Next Z
    Next X
    
    'Replace tiles with the same matching properties
    For I = 1 To MapSizeX * MapSizeZ * 0.1
        X = Int(Rnd * (MapSizeX - 2)) + 1
        Z = Int(Rnd * (MapSizeZ - 2)) + 1
        If Tiles(X, Z).RoomID = RoomID_Library Then
            ReplaceTileType X, Z, TileType_BookShelf
        ElseIf Tiles(X, Z).RoomID = RoomID_Horror Then
            Select Case Int(Rnd * 2)
            Case 0
                ReplaceTileType X, Z, TileType_FallPit
            Case 1
                ReplaceTileType X, Z, TileType_SpikeTrap
            End Select
        End If
    Next I
    
    'Show the map
    SetVisibleRectVisibility True
    
    'Draw the player's map
    For X = 1 To PathfindingMapSizeX - 2
        For Z = 1 To PathfindingMapSizeX - 2
            Static IsOutside As Boolean
            Static HasDoor As Boolean
            HasDoor = False
            If X Mod 2 = 0 Then
                If Z Mod 2 = 0 Then
                    IsOutside = (GetRoomID_Safe(X / 2, Z / 2) = 0)
                Else
                    If GetRoomID_Safe(X / 2, (Z + 1) / 2) = 0 Or _
                       GetRoomID_Safe(X / 2, (Z - 1) / 2) = 0 Or _
                       GetRoomID_Safe(X / 2, (Z + 1) / 2) <> GetRoomID_Safe(X / 2, (Z - 1) / 2) Then
                        HasDoor = (TileTypes(Tiles(X / 2, (Z + 1) / 2).TileTypeIndex).HasDoor And TileTypes(Tiles(X / 2, (Z - 1) / 2).TileTypeIndex).HasDoor)
                        IsOutside = Not (HasDoor)
                    Else
                        IsOutside = False
                    End If
                End If
            Else
                If Z Mod 2 = 0 Then
                    If GetRoomID_Safe((X + 1) / 2, Z / 2) = 0 Or _
                       GetRoomID_Safe((X - 1) / 2, Z / 2) = 0 Or _
                       GetRoomID_Safe((X + 1) / 2, Z / 2) <> GetRoomID_Safe((X - 1) / 2, Z / 2) Then
                        HasDoor = (TileTypes(Tiles((X + 1) / 2, Z / 2).TileTypeIndex).HasDoor And TileTypes(Tiles((X - 1) / 2, Z / 2).TileTypeIndex).HasDoor)
                        IsOutside = Not (HasDoor)
                    Else
                        IsOutside = False
                    End If
                Else
                    IsOutside = (GetRoomID_Safe((X + 1) / 2, (Z + 1) / 2) = 0 Or _
                                 GetRoomID_Safe((X - 1) / 2, (Z - 1) / 2) = 0 Or _
                                 GetRoomID_Safe((X + 1) / 2, (Z + 1) / 2) <> GetRoomID_Safe((X - 1) / 2, (Z - 1) / 2) Or _
                                 GetRoomID_Safe((X - 1) / 2, (Z + 1) / 2) = 0 Or _
                                 GetRoomID_Safe((X + 1) / 2, (Z - 1) / 2) = 0 Or _
                                 GetRoomID_Safe((X - 1) / 2, (Z + 1) / 2) <> GetRoomID_Safe((X + 1) / 2, (Z - 1) / 2))
                End If
            End If
            If IsOutside Then
                Color = MakeVector3(0, 0, 0)
            Else
                If HasDoor Then
                    Color = MakeVector3(1.5, 1.5, 1.5)
                Else
                    Select Case GetRoomID_Safe(X / 2, Z / 2)
                    Case RoomID_Kitchen
                        If X Mod 2 Xor Z Mod 2 Then
                            Color = MakeVector3(0, 0.7, 0.7)
                        Else
                            Color = MakeVector3(0, 0.5, 0.5)
                        End If
                    Case RoomID_Horror
                        Color = MakeVector3(0.7, 0, 0)
                    Case RoomID_Library
                        Color = MakeVector3(0.7, 0.7, 0)
                    Case Else
                        Color = MakeVector3(0, 0.7, 0)
                    End Select
                End If
            End If
            DGE.DrawSurface_SetPixelColor DrawSurface_Map, X, Z, Color.X, Color.Y, Color.Z, 1
        Next Z
    Next X
    'Draw on the edges for debugging
    'For X = 0 To PathfindingMapSizeX - 1
    '    DGE.DrawSurface_SetPixelColor DrawSurface_Map, X, 0, 1, 1, 1, 1
    '    DGE.DrawSurface_SetPixelColor DrawSurface_Map, X, PathfindingMapSizeZ - 1, 1, 1, 1, 1
    'Next X
    'For Z = 0 To PathfindingMapSizeZ - 1
    '    DGE.DrawSurface_SetPixelColor DrawSurface_Map, 0, Z, 1, 1, 1, 1
    '    DGE.DrawSurface_SetPixelColor DrawSurface_Map, PathfindingMapSizeX - 1, Z, 1, 1, 1, 1
    'Next Z
    
    'Place the player
    Changed = False
    Do Until Changed = True
        For I = 1 To MapSizeX * MapSizeZ
            X = Int(Rnd * (MapSizeX - 2)) + 1
            Z = Int(Rnd * (MapSizeZ - 2)) + 1
            If Tiles(X, Z).RoomID > RoomID_Horror Then 'ID 0 is outside and ID 1 is filled with traps
                Player.Pos = MakeVector3((Int(X)), 0, (Int(Z)))
                Player.Vel = MakeVector3(0, 0, 0)
                Player.CollisionRadius = 0.2
                Player.Longitude = Rnd * PI
                Changed = True
            End If
        Next I
    Loop
End Sub

Private Function WallsExist(Region As TileRect) As Boolean
    Static X As Long
    Static Z As Long
    Static FirstRoomID As Long
    FirstRoomID = GetRoomID_Safe(Region.MinX, Region.MinZ)
    For X = Region.MinX To Region.MaxX
        For Z = Region.MinZ To Region.MaxZ
            If GetRoomID_Safe(X, Z) <> FirstRoomID Then
                WallsExist = True
                Exit Function
            End If
        Next Z
    Next X
    WallsExist = False
End Function

Private Function LightExist(Region As TileRect, RoomID As Byte) As Boolean
    Static X As Long
    Static Z As Long
    For X = Region.MinX To Region.MaxX
        For Z = Region.MinZ To Region.MaxZ
            If Tiles(X, Z).HasLight And Tiles(X, Z).RoomID = RoomID Then
                LightExist = True
                Exit Function
            End If
        Next Z
    Next X
    LightExist = False
End Function

Private Function DoorExist(Region As TileRect, RoomID As Byte) As Boolean
    Static X As Long
    Static Z As Long
    For X = Region.MinX To Region.MaxX
        For Z = Region.MinZ To Region.MaxZ
            If TileTypes(Tiles(X, Z).TileTypeIndex).HasDoor And Tiles(X, Z).RoomID = RoomID Then
                DoorExist = True
                Exit Function
            End If
        Next Z
    Next X
    DoorExist = False
End Function

Private Function ReplaceTileType(X As Long, Z As Long, NewTileType As Byte) As Boolean
    Static CurrentTileType As Byte
    CurrentTileType = Tiles(X, Z).TileTypeIndex
    ReplaceTileType = False
    If TileTypes(CurrentTileType).Base = True And TileTypes(NewTileType).Base = False Then
        If TileTypes(CurrentTileType).HasDoor = TileTypes(NewTileType).HasDoor Then
            If TileTypes(CurrentTileType).Outside = TileTypes(NewTileType).Outside Then
                If IsNMEqual(TileTypes(CurrentTileType).Pattern, TileTypes(NewTileType).Pattern) Then
                    Tiles(X, Z).TileTypeIndex = NewTileType
                    ReplaceTileType = True
                End If
            End If
        End If
    End If
End Function

Private Sub TriggerTiles(Runner As Actor)
    Static X As Long
    Static Z As Long
    Static TileType As Byte
    X = Int(Runner.Pos.X + 0.5)
    Z = Int(Runner.Pos.Z + 0.5)
    If X >= 0 And X < MapSizeX And Z >= 0 And Z < MapSizeZ Then
        TileType = Tiles(X, Z).TileTypeIndex
        If TileTypes(TileType).CanBeActive Then
            ActiveTiles.IncludeTile X, Z
            Tiles(X, Z).MovingDirection = 1
        End If
    End If
End Sub

Private Sub ScheduleTile(X As Long, Z As Long)
    Static TileType As Byte
    TileType = Tiles(X, Z).TileTypeIndex
    Tiles(X, Z).AnimationTime = Tiles(X, Z).AnimationTime + (Tiles(X, Z).MovingDirection * TileTypes(TileType).Moving_Speed * TimePerFrame)
    Select Case TileTypes(TileType).Moving_Behaviour
    Case ForwardStop
        If Tiles(X, Z).AnimationTime >= 1 Then
            Tiles(X, Z).MovingDirection = 0
            ActiveTiles.ExcludeTile X, Z
        End If
    Case ForwardLoop
        Tiles(X, Z).AnimationTime = Tiles(X, Z).AnimationTime - Int(Tiles(X, Z).AnimationTime)
    Case ForwardWhenActivated
        If Tiles(X, Z).AnimationTime <= 0 And Tiles(X, Z).MovingDirection < 0 Then
            Tiles(X, Z).MovingDirection = 0
            ActiveTiles.ExcludeTile X, Z
        Else
            Tiles(X, Z).MovingDirection = -1
        End If
    End Select
    Tiles(X, Z).AnimationTime = Saturate(Tiles(X, Z).AnimationTime)
    UpdateTileAnimation X, Z
End Sub

Private Sub FollowActor(Target As Actor)
    'Move the camera and show tiles around the target
    Static CameraTarget As Vector3
    Static CameraPos As Vector3
    Static VisibleRadius As Long
    
    'Follow the target actor with the camera
    CameraTarget = AddVector3(Target.Pos, MakeVector3(0, 0.5, 0))
    CameraPos = MakeVector3(CameraTarget.X - (Target.Forward.X * Cos(0.78) * CameraDistance), CameraTarget.Y + (Sin(0.78) * CameraDistance), CameraTarget.Z - (Target.Forward.Z * Cos(0.78) * CameraDistance))
    DGE.Camera_Place Camera_Main, CameraPos.X, CameraPos.Y, CameraPos.Z, CameraTarget.X, CameraTarget.Y, CameraTarget.Z, 0, 1, 0: RE
    
    'Show real tiles
    VisibleRadius = Clamp_Long(4, Int(CameraDistance * 3.4) + 3, MaxViewRadius)
    SetVisibleRect MakeSafeTileRect(Int(CameraTarget.X + 0.5) - VisibleRadius, Int(CameraTarget.X + 0.5) + VisibleRadius, Int(CameraTarget.Z + 0.5) - VisibleRadius, Int(CameraTarget.Z + 0.5) + VisibleRadius)
    
    'Place simplified map
    DGE.Instance_SetPosition Instance_Map, CameraTarget.X, 1, CameraTarget.Z
    
    'Update light
    DGE.LightSource_ClearShadows
    Light_Update CameraTarget, CameraDistance, VisibleRect
End Sub

Private Sub Render(Camera As Long)
    'Render the scene with shader channel 0 to surface D
        DGE.Camera_RenderScene Camera, DrawSurface_D, 0: RE
    'Draw text
        PrintLine_Centered DrawSurface_D, "FPS = " & FPS, 0, -0.9, 0, 2, 0, 1
    'Apply a bloom effect and show the result
        'PostEffects_DownSample from D to B
        PostEffects_DownSample DrawSurface_D, DrawSurface_B
        'Apply blur to B
        PostEffects_ApplyDiffuseBlur DrawSurface_B, 0.4 * BloomSize
        'Lower the gamma for B
        PostEffects_RaiseToPower DrawSurface_B, 1.3
        'Show a mix of D and B
        PostEffects_Mix2Surfaces DrawSurface_D, 0.35, DrawSurface_B, 0.9, DrawSurface_Final
End Sub

Private Sub UpdateTileAnimation(ByVal X As Long, ByVal Z As Long)
    Static TileTypeIndex As Long
    Static NearStart As Boolean
    Static NearEnd As Boolean
    Static FinalAnimationTime As Single
    Static LocalPos As Vector3
    Static WorldPos As Vector3
    Static LocalToWorldMatrix As Matrix3
    TileTypeIndex = Tiles(X, Z).TileTypeIndex
    If Tiles(X, Z).Instance_Moving > 0 Then
        'Get the tile's X and Z axis from the direction
        LocalToWorldMatrix.XAxis = GetXAxisFromDirection_Vector3(Tiles(X, Z).Direction)
        LocalToWorldMatrix.YAxis = MakeVector3(0, 1, 0)
        LocalToWorldMatrix.ZAxis = GetZAxisFromDirection_Vector3(Tiles(X, Z).Direction)
        
        'Use the time function to modify the speed at different times in the animation
        Select Case TileTypes(TileTypeIndex).Moving_TimeFunction
        Case Linear
            'For slow but strong moves
            FinalAnimationTime = Tiles(X, Z).AnimationTime
        Case Quadratic
            'For falling things
            FinalAnimationTime = Tiles(X, Z).AnimationTime ^ 2
        End Select
        
        'Interpolate the position and place the model
        LocalPos = LerpVector3(TileTypes(TileTypeIndex).Moving_StartPos, TileTypes(TileTypeIndex).Moving_EndPos, FinalAnimationTime)
        WorldPos = MakeVector3((X) + (LocalToWorldMatrix.XAxis.X * LocalPos.X) + (LocalToWorldMatrix.ZAxis.X * LocalPos.Z), LocalPos.Y, (Z) + (LocalToWorldMatrix.XAxis.Z * LocalPos.X) + (LocalToWorldMatrix.ZAxis.Z * LocalPos.Z))
        DGE.Instance_SetPosition Tiles(X, Z).Instance_Moving, WorldPos.X, WorldPos.Y, WorldPos.Z
        
        'Test if we are at start or end with a treshold in case of rounding errors
        NearStart = Tiles(X, Z).AnimationTime < 0.00001
        NearEnd = Tiles(X, Z).AnimationTime > 0.99999
        
        'Hide the moving part when it can't be seen to save rendering time
        If (TileTypes(TileTypeIndex).Moving_StartHidden And NearStart) Or (TileTypes(TileTypeIndex).Moving_EndHidden And NearEnd) Then
            'Invisible
            DGE.Instance_SetVisibility Tiles(X, Z).Instance_Moving, 0, False
            'Not casting shadows
            DGE.Instance_SetVisibility Tiles(X, Z).Instance_Moving, 1, False
        Else
            'Visible
            DGE.Instance_SetVisibility Tiles(X, Z).Instance_Moving, 0, True
            'Casting shadows
            DGE.Instance_SetVisibility Tiles(X, Z).Instance_Moving, 1, True
        End If
        
        'Set detail level for the static part
        If TileTypes(TileTypeIndex).Moving_StartWithLowDetailLevel Then
            If NearStart Then
                DGE.Instance_SetDetailLevel Tiles(X, Z).Instance_Static, 0
            Else
                DGE.Instance_SetDetailLevel Tiles(X, Z).Instance_Static, 2
            End If
        End If
    End If
End Sub

Private Sub SetTileVisibility(ByVal X As Long, ByVal Z As Long, Visible As Boolean)
    Static TileTypeIndex As Long
    Static Direction As Byte
    Static TextureOverride As Integer
    If Visible Then
        TileTypeIndex = Tiles(X, Z).TileTypeIndex
        Direction = Tiles(X, Z).Direction
        If Tiles(X, Z).Instance_Static = 0 And TileTypes(TileTypeIndex).Model_Static > 0 Then
            Tiles(X, Z).Instance_Static = DGE.Instance_Create(TileTypes(TileTypeIndex).Model_Static): RE
            Tiles(X, Z).VisibleTileTypeIndex = TileTypeIndex
            DGE.Instance_SetPosition Tiles(X, Z).Instance_Static, X, 0, Z
            For TextureOverride = 0 To NumberOfInstanceTextureChannels - 1
                DGE.Instance_SetTextureOverride Tiles(X, Z).Instance_Static, TextureOverride, InstanceTexture(TextureOverride, Tiles(X, Z).RoomID)
            Next TextureOverride
            SetTileDirection Tiles(X, Z).Instance_Static, Direction
        End If
        If Tiles(X, Z).Instance_Moving = 0 And TileTypes(TileTypeIndex).Model_Moving > 0 Then
            Tiles(X, Z).Instance_Moving = DGE.Instance_Create(TileTypes(TileTypeIndex).Model_Moving): RE
            SetTileDirection Tiles(X, Z).Instance_Moving, Direction
            For TextureOverride = 0 To NumberOfInstanceTextureChannels - 1
                DGE.Instance_SetTextureOverride Tiles(X, Z).Instance_Moving, TextureOverride, InstanceTexture(TextureOverride, Tiles(X, Z).RoomID)
            Next TextureOverride
            UpdateTileAnimation X, Z
        End If
    Else
        If Tiles(X, Z).Instance_Static > 0 Then
            DGE.Instance_Delete Tiles(X, Z).Instance_Static
            Tiles(X, Z).Instance_Static = 0
        End If
        If Tiles(X, Z).Instance_Moving > 0 Then
            DGE.Instance_Delete Tiles(X, Z).Instance_Moving
            Tiles(X, Z).Instance_Moving = 0
        End If
        Tiles(X, Z).VisibleTileTypeIndex = -1
    End If
End Sub

Private Sub MoveActor(Runner As Actor, ForwardSpeed As Single, RightSpeed As Single, TurnAngle As Single, TimeStep As Single)
    Static NewPos As Vector3
    Static WalkDir As Vector3
    Static SoftForce As Vector3
    
    Const MaximumVelocity As Single = 3
    
    'Turn
    Player.Longitude = Player.Longitude + TurnAngle
    'Calculate a new axis system
    Player.Forward = MakeVector3(-Sin(Player.Longitude), 0, Cos(Player.Longitude))
    Player.Right = MakeVector3(Cos(Player.Longitude), 0, Sin(Player.Longitude))
    'Use the axis system in the engine
    DGE.Instance_SetXAxis Player.Instance, Player.Right.X, Player.Right.Y, Player.Right.Z
    DGE.Instance_SetZAxis Player.Instance, Player.Forward.X, Player.Forward.Y, Player.Forward.Z
    
    'Combine forward and sideway accelerations to one force
    WalkDir = AddVector3(MulVector3(Player.Forward, ForwardSpeed), MulVector3(Player.Right, RightSpeed))
    'Prevent moving faster from walking diagonally
    LimitVector3 WalkDir, 1
    'Accelerate
    Player.Vel = AddVector3(Player.Vel, MulVector3(WalkDir, 15 * TimeStep))
    
    'Collide with the world
    SoftForce = ForceFromStaticCollision(AddVector3(Player.Pos, MulVector3(Player.Vel, 0.5 * TimeStep)), Player.CollisionRadius)
    Player.Vel = AddVector3(Player.Vel, MulVector3(SoftForce, 500 * TimeStep))
    Player.Pos = AddVector3(Player.Pos, MulVector3(SoftForce, 50 * TimeStep))
    
    If AbsVector3(WalkDir) > 0.1 Then
        'Reduce velocity using walking resistance
        Player.Vel = MulVector3(Player.Vel, 0.1 ^ TimeStep)
    Else
        'Try to stop
        DecreaseVector3 Player.Vel, TimeStep * 20
    End If
    
    'Limit velocity
    If AbsVector3(Player.Vel) > MaximumVelocity Then
        Player.Vel = MulVector3(NormalVector3(Player.Vel), MaximumVelocity)
    End If
    
    NewPos = AddVector3(Player.Pos, MulVector3(Player.Vel, TimeStep))
    
    'Protect against moves that break the game's rules
    If ValidMove(Player.Pos, NewPos) Then
        Player.Pos = NewPos
        DGE.Instance_SetPosition Player.Instance, Player.Pos.X, Player.Pos.Y, Player.Pos.Z
    Else
        Player.Vel = MakeVector3(0, 0, 0)
    End If
    
    'Remove the Y axis until we need it
    Player.Vel.Y = 0
    Player.Pos.Y = 0
End Sub

'Basic protection against moving thru walls in case that the finer physics is failing
Private Function ValidMove(FromPos As Vector3, ToPos As Vector3)
    Static FromX As Long
    Static FromZ As Long
    Static ToX As Long
    Static ToZ As Long
    FromX = Int(FromPos.X + 0.5)
    FromZ = Int(FromPos.Z + 0.5)
    ToX = Int(ToPos.X + 0.5)
    ToZ = Int(ToPos.Z + 0.5)
    If FromX < ToX - 1 Or FromX > ToX + 1 Or FromZ < ToZ - 1 Or FromZ > ToZ + 1 Then
        'The move is skipping too many things
        ValidMove = False
    ElseIf Tiles(ToX, ToZ).RoomID = 0 Then
        'The move ends outside of the rooms
        ValidMove = False
    ElseIf Tiles(FromX, FromZ).RoomID = Tiles(ToX, ToZ).RoomID Or (TileTypes(Tiles(FromX, FromZ).TileTypeIndex).HasDoor And TileTypes(Tiles(ToX, ToZ).TileTypeIndex).HasDoor And (FromX = ToX Or FromZ = ToZ)) Then
        'The tiles have no wall between or have a door
        ValidMove = True
    Else
        ValidMove = False
    End If
End Function

Private Function ForceFromStaticCollision(MidpointPos As Vector3, BodyRadius As Single) As Vector3
    Static I As Long
    Static J As Long
    Static XReal As Single
    Static ZReal As Single
    Static XDiv As Long
    Static ZDiv As Long
    Static XMod As Single
    Static ZMod As Single
    Static TileType As Byte
    Static Direction As Byte
    Static WorldSpaceCollision As NeighbourhoodBoolean
    Static Force As Single
    Static PointX As Single
    Static PointZ As Single
    XReal = MidpointPos.X + 0.5
    ZReal = MidpointPos.Z + 0.5
    XDiv = Int(XReal)
    ZDiv = Int(ZReal)
    XMod = (XReal - XDiv) - 0.5
    ZMod = (ZReal - ZDiv) - 0.5
    TileType = Tiles(XDiv, ZDiv).TileTypeIndex
    Direction = Tiles(XDiv, ZDiv).Direction
    
    ForceFromStaticCollision = MakeVector3(0, 0, 0)
    
    'Convert collision data from object space to world space
    For I = 0 To 7
        J = (I + (Direction * 2)) Mod 8
        WorldSpaceCollision.N(J) = TileTypes(TileType).Collision.N(I)
    Next I
    
    'Collide with each wall and edge
    If WorldSpaceCollision.N(0) Then '+X wall
        Force = (XMod + BodyRadius) - (0.5 - WallRadius)
        If Force > 0 Then
            ForceFromStaticCollision = AddVector3(ForceFromStaticCollision, MulVector3(MakeVector3(-1, 0, 0), Force))
        End If
    End If
    If WorldSpaceCollision.N(1) Then '+X -Z edge
        PointX = 0.5
        PointZ = -0.5
        Force = (BodyRadius + WallRadius) - Sqr((XMod - PointX) ^ 2 + (ZMod - PointZ) ^ 2)
        If Force > 0 Then
            ForceFromStaticCollision = AddVector3(ForceFromStaticCollision, MulVector3(NormalVector3(MakeVector3(XMod - PointX, 0, ZMod - PointZ)), Force))
        End If
    End If
    If WorldSpaceCollision.N(2) Then '-Z wall
        Force = (-0.5 + WallRadius) - (ZMod - BodyRadius)
        If Force > 0 Then
            ForceFromStaticCollision = AddVector3(ForceFromStaticCollision, MulVector3(MakeVector3(0, 0, 1), Force))
        End If
    End If
    If WorldSpaceCollision.N(3) Then '-X -Z edge
        PointX = -0.5
        PointZ = -0.5
        Force = (BodyRadius + WallRadius) - Sqr((XMod - PointX) ^ 2 + (ZMod - PointZ) ^ 2)
        If Force > 0 Then
            ForceFromStaticCollision = AddVector3(ForceFromStaticCollision, MulVector3(NormalVector3(MakeVector3(XMod - PointX, 0, ZMod - PointZ)), Force))
        End If
    End If
    If WorldSpaceCollision.N(4) Then '-X wall
        Force = (-0.5 + WallRadius) - (XMod - BodyRadius)
        If Force > 0 Then
            ForceFromStaticCollision = AddVector3(ForceFromStaticCollision, MulVector3(MakeVector3(1, 0, 0), Force))
        End If
    End If
    If WorldSpaceCollision.N(5) Then '-X +Z edge
        PointX = -0.5
        PointZ = 0.5
        Force = (BodyRadius + WallRadius) - Sqr((XMod - PointX) ^ 2 + (ZMod - PointZ) ^ 2)
        If Force > 0 Then
            ForceFromStaticCollision = AddVector3(ForceFromStaticCollision, MulVector3(NormalVector3(MakeVector3(XMod - PointX, 0, ZMod - PointZ)), Force))
        End If
    End If
    If WorldSpaceCollision.N(6) Then '+Z wall
        Force = (ZMod + BodyRadius) - (0.5 - WallRadius)
        If Force > 0 Then
            ForceFromStaticCollision = AddVector3(ForceFromStaticCollision, MulVector3(MakeVector3(0, 0, -1), Force))
        End If
    End If
    If WorldSpaceCollision.N(7) Then '+X +Z edge
        PointX = 0.5
        PointZ = 0.5
        Force = (BodyRadius + WallRadius) - Sqr((XMod - PointX) ^ 2 + (ZMod - PointZ) ^ 2)
        If Force > 0 Then
            ForceFromStaticCollision = AddVector3(ForceFromStaticCollision, MulVector3(NormalVector3(MakeVector3(XMod - PointX, 0, ZMod - PointZ)), Force))
        End If
    End If
End Function

Private Sub DoStuff()
    Static I As Long
    Static X As Long
    Static Z As Long
    Static SubSteps As Long
    
    'Derive mouse velocity
    'A longer delay will get a bigger offset to compensate for the framerate
    'The mouse pointer have an empty icon instead of being hidden so that the mouse will be visible even when the game crashed.
    MouseOffset = Mouse_GetOffsetSinceLastCall
    
    'Use mouse velocity
    Player.Longitude = Player.Longitude - (MouseOffset.X * 0.005)
    CameraDistance = Clamp(2, CameraDistance - (MouseOffset.Y * 0.05), 200)
    DGE.Enviroment_SetFarClipPlane (CameraDistance * 3) + 5
    
    'Move the player
    If KeyDown_Truth(vbKeyE) Then
        'Test running with finer steps to confirm that the physics is the same on a faster computer
        SubSteps = 100
    Else
        SubSteps = 1
    End If
    For I = 1 To SubSteps
        MoveActor Player, KeyDown_ZeroToOne(vbKeyW) - KeyDown_ZeroToOne(vbKeyS) + KeyDown_ZeroToOne(vbKeyUp) - KeyDown_ZeroToOne(vbKeyDown), KeyDown_ZeroToOne(vbKeyD) - KeyDown_ZeroToOne(vbKeyA) + KeyDown_ZeroToOne(vbKeyRight) - KeyDown_ZeroToOne(vbKeyLeft), MouseOffset.X * (-0.005 / SubSteps), TimePerFrame / SubSteps
    Next I
    TriggerTiles Player
    
    'Schedule tiles
    For I = ActiveTiles.GetNumberOfUsedTiles - 1 To 0 Step -1
        X = ActiveTiles.GetXUsingIndex(I)
        Z = ActiveTiles.GetZUsingIndex(I)
        ScheduleTile X, Z
    Next I
    
    'Follow the player with the main camera
    FollowActor Player
    
    'Render the scene from the main camera
    Render Camera_Main
End Sub
