VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "TileQueue"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

'A class that store a subset of the tiles in the map
'The order of the list is in "First In First Out" order

Option Explicit

'TileCollection store the tile coordinates in FIFO order as a round buffer and TileExist prevent duplication
Const MaxNumberOfTiles As Long = MapSizeX * MapSizeZ
Dim TileExist(0 To MapSizeX - 1, 0 To MapSizeZ - 1) As Boolean
Dim TileCollection(0 To MaxNumberOfTiles - 1) As TileVector

Dim Start As Long 'The start in modulo MaxNumberOfTiles
Dim Length As Long 'The number of tiles from 0 to MaxNumberOfTiles

Private Sub Class_Initialize()
    Reset
End Sub

Public Sub Reset()
    Static I As Long
    Static J As Long
    Static X As Long
    Static Z As Long
    For I = Start To Start + Length - 1
        J = I Mod MaxNumberOfTiles
        TileExist(TileCollection(J).X, TileCollection(J).Z) = False
    Next I
    Start = 0
    Length = 0
End Sub

Public Sub InsertTile(X As Long, Z As Long)
    Static NewIndex As Long
    If TileExist(X, Z) = False Then
        Debug.Assert Length < MaxNumberOfTiles
        Length = Length + 1
        NewIndex = (Start + Length - 1) Mod MaxNumberOfTiles
        TileExist(X, Z) = True
        TileCollection(NewIndex) = MakeTileVector(X, Z)
    End If
End Sub

Public Function GetOldestTileX() As Long
    Debug.Assert Length > 0
    GetOldestTileX = TileCollection(Start).X
End Function

Public Function GetOldestTileZ() As Long
    Debug.Assert Length > 0
    GetOldestTileZ = TileCollection(Start).Z
End Function

Public Sub RemoveOldestTile()
    Static OldIndex As Long
    Debug.Assert Length > 0
    OldIndex = Start
    Start = Start + 1 Mod MaxNumberOfTiles
    Length = Length - 1
    TileExist(TileCollection(OldIndex).X, TileCollection(OldIndex).Z) = False
End Sub

Public Function GetNumberOfTiles() As Long
    GetNumberOfTiles = Length
End Function
