Attribute VB_Name = "DrawShaders"

Option Explicit

'Draw shaders
Public DrawShader_1Tex As Long
Public DrawShader_Map As Long
Public DrawShader_Circle_Fade_Linear

'Font textures
Dim FontAtlas_LucidaConsole_20 As Long

Public Sub DrawShader_Init()
    DrawShader_1Tex = LoadDrawShader("D_FullQuad_1Tex")
    DrawShader_Map = LoadDrawShader("D_Map")
    DrawShader_Circle_Fade_Linear = LoadDrawShader("D_Circle_Fade_Linear")
    FontAtlas_LucidaConsole_20 = LoadTexture("FontAtlas_LucidaConsole_20")
End Sub

'Preconditions:
'   Message may not contain linebreaks. Call this method for each line with different offsets to CenterY if you want multiple lines.
'   OutputDrawSurface is a draw surface.
'   FontAtlasTexture is a texture with 16 x 16 white characters ordered by character code in latin reading order on a transparent background.
'SideEffects:
'   Printing Message to OutputDrawSurface using FontAtlasTexture as it's font atlas.
Public Sub PrintLine_Centered(OutputDrawSurface As Long, Message As String, CenterX As Single, CenterY As Single, Red As Single, Green As Single, Blue As Single, Opacity As Single)
    Dim I As Long
    Dim OutW As Long
    Dim OutH As Long
    Dim TileW As Long
    Dim TileH As Long
    Dim StringLength as Long
    Dim CharCode As Integer
    Dim X As Single
    Dim Y As Single
    OutW = frmMain.DGE.DrawSurface_GetWidth(OutputDrawSurface): RE
    OutH = frmMain.DGE.DrawSurface_GetHeight(OutputDrawSurface): RE
    TileW = frmMain.DGE.Texture_GetWidth(FontAtlas_LucidaConsole_20) / 16: RE
    TileH = frmMain.DGE.Texture_GetHeight(FontAtlas_LucidaConsole_20) / 16: RE
    StringLength = Len(Message)
    For I = 1 To StringLength
        frmMain.DGE.Draw_GiveInputSurface 0, FontAtlas_LucidaConsole_20: RE
        CharCode = Asc(Mid(Message, I, 1))
        X = Int(CharCode Mod 16)
        Y = Int(CharCode / 16)
        frmMain.DGE.Draw_GiveInputSourceRectangleUV1 X * 0.0625, (X + 1) * 0.0625, Y * 0.0625, (Y + 1) * 0.0625: RE
        frmMain.DGE.Draw_GiveInputColor Red, Green, Blue, Opacity: RE
        frmMain.DGE.Draw_RenderQuad OutputDrawSurface, DrawShader_1Tex, CenterX + ((I - (StringLength / 2)) * (TileW / OutW)), CenterY, TileW / OutW, 0, 0, TileH / OutH, 1: RE
    Next I
End Sub
