Attribute VB_Name = "Friction"

Option Explicit

Public Type AdvancedFriction
    Base As Single 'The exponential base for stribeck friction between 0 and 1
    Stribeck As Single 'The amount of friction for close to no speed
    Treshold As Single 'A treshold where the stribeck friction ends completely
    Viscous As Single 'The amount of friction added with more speed
    MaxViscous As Single 'The maximum amount of force from viscous friction
End Type

Public Function MakeAdvancedFriction(Base As Single, Stribeck As Single, Treshold As Single, Viscous As Single, MaxViscous As Single) As AdvancedFriction
    MakeAdvancedFriction.Base = Base
    MakeAdvancedFriction.Stribeck = Stribeck
    MakeAdvancedFriction.Treshold = Treshold
    MakeAdvancedFriction.Viscous = Viscous
    MakeAdvancedFriction.MaxViscous = MaxViscous
End Function

Public Function CombineFriction(A As AdvancedFriction, B As AdvancedFriction) As AdvancedFriction
    CombineFriction.Base = A.Base * B.Base
    CombineFriction.Stribeck = A.Stribeck * B.Stribeck
    CombineFriction.Treshold = A.Treshold * B.Treshold
    CombineFriction.Viscous = A.Viscous * B.Viscous
    CombineFriction.MaxViscous = A.MaxViscous * B.MaxViscous
End Function

Public Function FrictionFromSpeed(Speed As Single, F As AdvancedFriction, Mass As Single, TimeStep As Single) As Single
    If Speed < F.Treshold Then
        FrictionFromSpeed = Min_Float(((F.Base ^ Speed) * F.Stribeck) + (Speed * F.Viscous), Speed * Mass * TimeStep)
    Else
        FrictionFromSpeed = Min_Float(Min_Float(Speed * F.Viscous, F.MaxViscous), Speed * Mass * TimeStep)
    End If
End Function
