Attribute VB_Name = "GlobalConstants"

Option Explicit

'Physical timestep
Public Const TimeStep As Single = 1 / 60 'A smaller timestep give smaller discrete errors but larger rounding errors and more steps per render

'Sun
Public Const SunSpeed As Single = 0.02

'Physical properties
Public Const DefaultRestitution As Single = 0.6
Public Const WorstFrictionPerMass As Single = 600 'Too little make wheels slide when standing still and too much start to shake

'Rigid body user data index
Public Const RBUDI_Collection = 0
    'Rigid body collection
    Public Const RBC_None = 0
    Public Const RBC_Vehicle = 1
    Public Const RBC_Item = 2
Public Const RBUDI_Index = 1
Public Const RBUDI_Coordinate_X = 2
Public Const RBUDI_Coordinate_Z = 3

'Amount of damage to items that still have something to stand on
Public Const Damage_None As Integer = 0
Public Const Damage_Full As Integer = 1

'These are measured from the texture atlas "RoadTileAtlas.png"
Public Const LargeRoadUCoordRatio As Single = 100 / 256
Public Const SmallRoadUCoordRatio As Single = 80 / 256

'Teams
Public Const Team_None As Long = 0
Public Const Team_Player As Long = 1
Public Const Team_Computer As Long = 2

'Skills
Public Const BotSkill_MaximumViewDistance As Single = Terrain_GroundModelRadius * 0.7 'How far away they can see in length units
Public Const BotSkill_Accuracy As Single = 0.1 '0 is maximum accuracy and higher is worse

'Roadsign atlas
Public Const RoadSignAtlas_Columns As Long = 4
Public Const RoadSignAtlas_Rows As Long = 4
