Attribute VB_Name = "PostEffects"
Option Explicit

Public PostEffect_4xMultisample As Long
Public PostEffect_Blend2 As Long
Public PostEffect_Blend2_Mask As Long
Public PostEffect_LinearBlur As Long
Public PostEffect_RaiseToArg As Long
Public PostEffect_LensReflection As Long
Public PostEffect_FastCopy As Long
Public PostEffect_Lerp As Long
Public PostEffect_GenerateBlendMap As Long
Public PostEffect_ErodeHeightMap As Long
Public PostEffect_Clamp As Long
Public PostEffect_RoadPresence As Long
Public PE_DistanceTransform_Reset As Long
Public PE_DistanceTransform_Iterate As Long

Public Sub PostEffects_Init()
    PostEffect_4xMultisample = LoadPostEffectShader("PE_4xMultisample")
    PostEffect_Blend2 = LoadPostEffectShader("PE_Blend2")
    PostEffect_Blend2_Mask = LoadPostEffectShader("PE_Blend2_Mask")
    PostEffect_LinearBlur = LoadPostEffectShader("PE_LinearBlur")
    PostEffect_RaiseToArg = LoadPostEffectShader("PE_RaiseToArg")
    PostEffect_LensReflection = LoadPostEffectShader("PE_LensReflection")
    PostEffect_FastCopy = LoadPostEffectShader("PE_FastCopy")
    PostEffect_Lerp = LoadPostEffectShader("PE_Lerp")
    PostEffect_GenerateBlendMap = LoadPostEffectShader("PE_GenerateBlendMap")
    PostEffect_ErodeHeightMap = LoadPostEffectShader("PE_ErodeHeightMap")
    PostEffect_Clamp = LoadPostEffectShader("PE_Clamp")
    PostEffect_RoadPresence = LoadPostEffectShader("PE_RoadPresence")
    PE_DistanceTransform_Reset = LoadPostEffectShader("PE_DistanceTransform_Reset")
    PE_DistanceTransform_Iterate = LoadPostEffectShader("PE_DistanceTransform_Iterate")
End Sub

Public Sub PostEffects_ApplySimplePostEffect(InDrawSurfaceOrTexture As Long, PostEffect As Long, OutDrawSurface As Long)
    frmMain.DGE.PostEffect_GiveInputSurface 0, InDrawSurfaceOrTexture, 0: RE
    frmMain.DGE.PostEffect_RenderShader OutDrawSurface, PostEffect: RE
End Sub

Public Sub PostEffects_Apply1ArgPostEffect(InDrawSurfaceOrTexture As Long, PostEffect As Long, OutDrawSurface As Long, Arg1 As Vector4)
    frmMain.DGE.PostEffect_GiveInputSurface 0, InDrawSurfaceOrTexture, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, Arg1.X, Arg1.Y, Arg1.Z, Arg1.W: RE
    frmMain.DGE.PostEffect_RenderShader OutDrawSurface, PostEffect: RE
End Sub

Public Sub PostEffects_Apply2ArgPostEffect(InDrawSurfaceOrTexture As Long, PostEffect As Long, OutDrawSurface As Long, Arg1 As Vector4, Arg2 As Vector4)
    frmMain.DGE.PostEffect_GiveInputSurface 0, InDrawSurfaceOrTexture, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, Arg1.X, Arg1.Y, Arg1.Z, Arg1.W: RE
    frmMain.DGE.PostEffect_GiveInputVector 1, Arg2.X, Arg2.Y, Arg2.Z, Arg2.W: RE
    frmMain.DGE.PostEffect_RenderShader OutDrawSurface, PostEffect: RE
End Sub

Public Sub PostEffects_Apply3ArgPostEffect(InDrawSurfaceOrTexture As Long, PostEffect As Long, OutDrawSurface As Long, Arg1 As Vector4, Arg2 As Vector4, Arg3 As Vector4)
    frmMain.DGE.PostEffect_GiveInputSurface 0, InDrawSurfaceOrTexture, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, Arg1.X, Arg1.Y, Arg1.Z, Arg1.W: RE
    frmMain.DGE.PostEffect_GiveInputVector 1, Arg2.X, Arg2.Y, Arg2.Z, Arg2.W: RE
    frmMain.DGE.PostEffect_GiveInputVector 2, Arg3.X, Arg3.Y, Arg3.Z, Arg3.W: RE
    frmMain.DGE.PostEffect_RenderShader OutDrawSurface, PostEffect: RE
End Sub

Public Sub PostEffects_Apply4ArgPostEffect(InDrawSurfaceOrTexture As Long, PostEffect As Long, OutDrawSurface As Long, Arg1 As Vector4, Arg2 As Vector4, Arg3 As Vector4, Arg4 As Vector4)
    frmMain.DGE.PostEffect_GiveInputSurface 0, InDrawSurfaceOrTexture, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, Arg1.X, Arg1.Y, Arg1.Z, Arg1.W: RE
    frmMain.DGE.PostEffect_GiveInputVector 1, Arg2.X, Arg2.Y, Arg2.Z, Arg2.W: RE
    frmMain.DGE.PostEffect_GiveInputVector 2, Arg3.X, Arg3.Y, Arg3.Z, Arg3.W: RE
    frmMain.DGE.PostEffect_GiveInputVector 3, Arg4.X, Arg4.Y, Arg4.Z, Arg4.W: RE
    frmMain.DGE.PostEffect_RenderShader OutDrawSurface, PostEffect: RE
End Sub

Public Sub PostEffects_Mix2Surfaces(A_Surface As Long, A_Brightness As Single, B_Surface As Long, B_Brightness As Single, OutDrawSurface As Long)
    frmMain.DGE.PostEffect_GiveInputSurface 0, A_Surface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, A_Brightness, A_Brightness, A_Brightness, A_Brightness: RE
    frmMain.DGE.PostEffect_GiveInputSurface 1, B_Surface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 1, B_Brightness, B_Brightness, B_Brightness, B_Brightness: RE
    frmMain.DGE.PostEffect_RenderShader OutDrawSurface, PostEffect_Blend2: RE
End Sub

Public Sub PostEffects_Mix2Surfaces_SeparatedChannels(A_Surface As Long, A_Multiplier As Vector4, B_Surface As Long, B_Multiplier As Vector4, OutDrawSurface As Long)
    frmMain.DGE.PostEffect_GiveInputSurface 0, A_Surface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, A_Multiplier.X, A_Multiplier.Y, A_Multiplier.Z, A_Multiplier.W: RE
    frmMain.DGE.PostEffect_GiveInputSurface 1, B_Surface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 1, B_Multiplier.X, B_Multiplier.Y, B_Multiplier.Z, B_Multiplier.W: RE
    frmMain.DGE.PostEffect_RenderShader OutDrawSurface, PostEffect_Blend2: RE
End Sub

Public Sub PostEffects_DownSample(InDrawSurfaceOrTexture As Long, OutDrawSurface As Long)
    frmMain.DGE.PostEffect_GiveInputSurface 0, InDrawSurfaceOrTexture, 0: RE
    frmMain.DGE.PostEffect_RenderShader OutDrawSurface, PostEffect_4xMultisample: RE
End Sub

Public Sub PostEffects_RaiseToPower(InOutDrawSurface As Long, Power As Single)
    'Test if we can do this
    If frmMain.DGE.DrawSurface_HasExtraColorBuffer(InOutDrawSurface) = False Then
        RE
        MsgBox "PostEffects_RaiseToPower: InOutDrawSurface does not have an extra color buffer.", vbCritical, "Error!"
        Exit Sub
    End If
    RE
    
    frmMain.DGE.PostEffect_GiveInputSurface 0, InOutDrawSurface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, Power, Power, Power, Power: RE
    frmMain.DGE.PostEffect_RenderShader InOutDrawSurface, PostEffect_RaiseToArg: RE
End Sub

Public Sub PostEffects_ApplyDiffuseBlur(InOutDrawSurface As Long, Radius As Single)
    'Test if we can do this
    If frmMain.DGE.DrawSurface_HasExtraColorBuffer(InOutDrawSurface) = False Then
        RE
        MsgBox "PostEffects_ApplyDiffuseBlur: InOutDrawSurface does not have an extra color buffer.", vbCritical, "Error!"
        Exit Sub
    End If
    RE
    
    'Apply horizontal blur
    frmMain.DGE.PostEffect_GiveInputSurface 0, InOutDrawSurface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, -Radius, Radius, 1, 0: RE
    frmMain.DGE.PostEffect_RenderShader InOutDrawSurface, PostEffect_LinearBlur: RE
    'Apply vertical blur
    frmMain.DGE.PostEffect_GiveInputSurface 0, InOutDrawSurface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, -Radius, Radius, 0, 1: RE
    frmMain.DGE.PostEffect_RenderShader InOutDrawSurface, PostEffect_LinearBlur: RE
    'Apply diagonal blur
    frmMain.DGE.PostEffect_GiveInputSurface 0, InOutDrawSurface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, -Radius * 0.707106781186548, Radius * 0.707106781186548, 1, 1: RE
    frmMain.DGE.PostEffect_RenderShader InOutDrawSurface, PostEffect_LinearBlur: RE
    'Apply diagonal blur
    frmMain.DGE.PostEffect_GiveInputSurface 0, InOutDrawSurface, 0: RE
    frmMain.DGE.PostEffect_GiveInputVector 0, -Radius * 0.707106781186548, Radius * 0.707106781186548, 1, -1: RE
    frmMain.DGE.PostEffect_RenderShader InOutDrawSurface, PostEffect_LinearBlur: RE
End Sub
