VERSION 5.00
Object = "{FE69BD77-3946-4641-8613-6FC7144F2E05}#10.0#0"; "DFPGE10.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   ClientHeight    =   7755
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   10590
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   MouseIcon       =   "Main.frx":08CA
   MousePointer    =   99  'Custom
   ScaleHeight     =   7755
   ScaleWidth      =   10590
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin VB.Timer tmrFPS 
      Interval        =   1000
      Left            =   10020
      Top             =   720
   End
   Begin VB.Frame frmTools 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Height          =   435
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   1635
      Begin VB.Label lblFPS 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "0"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FF00&
         Height          =   300
         Left            =   120
         TabIndex        =   3
         Top             =   60
         Width           =   165
      End
   End
   Begin VB.Timer tmrStart 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   10020
      Top             =   120
   End
   Begin DFPGELib.DFPGE DGE 
      Height          =   7155
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   9915
      Visible         =   0   'False
      _Version        =   655360
      _ExtentX        =   17489
      _ExtentY        =   12621
      _StockProps     =   0
   End
   Begin VB.Label lblLoading 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Loading"
      BeginProperty Font 
         Name            =   "Impact"
         Size            =   21.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   540
      Left            =   120
      TabIndex        =   1
      Top             =   7260
      Width           =   1410
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'Bugs:
'   The sky is not seen in the reflection.
'       The sun will be visible in the water when it works.
'       Can it be just the sun that is not placed right?
'       Is the sky upside down?

'To do:
'

Option Explicit

'Reference to a camera that we created
Dim Camera_Main As Long
Dim Camera_Main_Pos As Vector3
Dim CameraLongitude As Single
Dim CameraLattitude As Single

'Draw surfaces
Dim DrawSurface_Final As Long 'The draw durface that we must render to before we see anything.
Dim DrawSurface_D As Long 'Default draw surface
Dim DrawSurface_B As Long 'Bloom draw surface

'Water
Const WaterLevel As Single = 0.64
Const WaterRefractiveIndex As Single = 1.33
Dim Camera_WaterReflection As Long
Dim DrawSurface_WaterReflection As Long 'Water reflection image
Dim Model_WaterSurface As Long
Dim Instance_WaterSurface As Long

'Time
Dim TimePerFrame As Single
Dim FPSCount As Long
Const TimeStep As Single = 1 / 300

'Physics
Const Gravity As Single = 10

'Post effect settings
Const BloomSize As Single = 3.2

'Sun
Dim LightSource_Sun As Long
Dim SunDirection As Vector3

'Sky
Const SkySpeed As Single = 0.02
Dim Model_Sky As Long
Dim Instance_Sky As Long

'Actor
Dim Model_Human As Long
Dim Player As Actor

Private Sub StartMatch()
    'Create the player
    Set Player = New Actor
    Player.GiveModel Model_Human
    Player.SizeMultiplier = 0.5 'This can be changed to make the actor bigger or smaller
    Player.Position_X = Int(Rnd * MapWidth)
    Player.Position_Y = Player.DefaultHeightAboveGround * Player.SizeMultiplier + 10
    Player.Position_Z = Int(Rnd * MapHeight)
    Player.DirectionAngle = CameraLongitude
    Player.Move 0, Gravity
    
End Sub

Private Sub EndMatch()
    Set Player = Nothing
End Sub

Private Function StartEngine() As Boolean
    StartEngine = DGE.Engine_Initiate: RE
End Function

'Loads a model and it's resources from FileName.
Private Function LoadModel(FileName As String) As Long
    InsertStringToEngine FileName
    LoadModel = DGE.Model_LoadFromFile_InSB: RE
    If LoadModel = -1 Then End
End Function

Private Sub DGE_KeyDown(KeyCode As Integer, Shift As Integer)
    'Exit the application when escape is pressed
    If KeyCode = vbKeyEscape Then
        EndMatch
        End
    End If
End Sub

Private Sub Form_Load()
    Randomize Timer
    If StartEngine Then
        'Set the default folder so that relative paths can be used
        SetRelativeWorkingDirectory "..\CommonMediaFiles"
        
        'We start a timer to let this routine exit before we render anything
        'The graphical user interface will not be drawn until Form_Load has finished and therefor the main loop can't be placed in Form_Load.
        tmrStart.Enabled = True
    End If
End Sub

Private Sub LoadThings()
    'Load and use our default material shader that will be used when something don't have a shader in the current shader channel
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultMaterialShader": DGE.Shader_UseAsDefaultMaterialShader DGE.Shader_LoadAsMaterial_InSB: RE

    'Load and use our default texture that is used when a texture is missing
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultTexture": DGE.Texture_UseAsDefaultTexture DGE.Texture_Load_InSB: RE
    
    'Wait for Engine_UpdateSwapChain instead of showing the result when drawing to the final draw surface
    'This allow drawing on the final draw surface by manually telling when we are done with our drawing
    DGE.Engine_SetAutomaticSwapChain False
    
    'Create a camera and take the reference number
    Camera_Main = DGE.Camera_Create: RE
    Camera_WaterReflection = DGE.Camera_Create: RE
    
    'Get the version specific ID to the final draw surface
    DrawSurface_Final = DGE.DrawSurface_GetFinalOutput: RE
    
    'Set the amount of ambient light
    DGE.LightSource_SetAmbientLight 0.8, 0.8, 0.8: RE
    
    'Set background color
    DGE.Enviroment_SetBackgroundColor 0.7, 0.8, 0.9, 1: RE
    
    'Load the sky model
    Model_Sky = LoadModel("Model_Sky"): DoEvents
    Instance_Sky = DGE.Instance_Create(Model_Sky): RE
    DGE.Enviroment_UseAsSkyInstance Instance_Sky: RE 'Draw first without writing to the depth buffer
    
    DoEvents
    
    'Set the depth atlas resolution
    DGE.LightSource_SetDepthAtlasResolution 1024 * 8: RE
    
    'Set near and far clip planes
    DGE.Enviroment_SetNearClipPlane 0.1: RE
    DGE.Enviroment_SetFarClipPlane ViewRadius: RE
    DGE.Enviroment_SetMaxFogIntensity 1: RE
    
    'Create sun light
    'If you haven't chosen a size using LightSource_SetDepthAtlasResolution, the default size will be allocated automatically.
    LightSource_Sun = DGE.LightSource_Create_Sun_Shadowcasting_SingleLayer(0, 0, 0, 0.4, -1, 0.6, 0, 1, 0, -1000, 1000, 2, 2, 2, ViewRadius, ViewRadius, 0, 0, 1, 0.001): RE
    
    DoEvents
    
    'Create a map
    World_Init
    
    'Load post effects and create draw surfaces to use them with
    PostEffects_Init
    DrawSurface_D = DGE.DrawSurface_CreateAutoSized(1, 1, 0, 0, 2, True): RE 'Allow rendering a 3D scene to it
    DrawSurface_B = DGE.DrawSurface_CreateAutoSized(0.25, 0.25, 0, 0, 0, True): RE 'Allow rendering from and to itself
    
    DoEvents
    
    'Load water
    DrawSurface_WaterReflection = DGE.DrawSurface_CreateAutoSized(0.5, 0.5, 0, 0, 2, True): RE 'This will store the water's reflection map
    Model_WaterSurface = LoadModel("Model_WaterSurface_Mirror")
    Instance_WaterSurface = frmMain.DGE.Instance_Create(Model_WaterSurface): RE
    frmMain.DGE.Instance_SetXAxis Instance_WaterSurface, ViewRadius + 2, 0, 0: RE
    frmMain.DGE.Instance_SetZAxis Instance_WaterSurface, 0, 0, ViewRadius + 2: RE
    frmMain.DGE.Instance_SetTextureOverride Instance_WaterSurface, 0, DrawSurface_WaterReflection: RE
    frmMain.DGE.Instance_SetVisibility Instance_WaterSurface, 1, False: RE 'Don't cast shadows
    
    'Place the camera in the center of the map
    Camera_Main_Pos = MakeVector3(MapWidth / 2, 20, MapHeight / 2)
    
    DoEvents
    
    'Give the map to the grid to generate geometry from the map
    DGE.Instance_SetTextureOverride Instance_Maze, 0, Drawsurface_Map: RE 'Give the draw surface to override channel 0 that is mapped to texture channel 1
    DGE.Instance_SetUserDefinedData Instance_Maze, 0, 0.1, 0.5, 0.1, 0: RE 'Set the border color to green at height 0
    
    'Start the mouse module
    Mouse_Init
    
    DoEvents
    
    'Load the human model
    Model_Human = LoadModel("Model_Bone_Human")
    
    'Start a new match
    StartMatch
    
    lblLoading.Visible = False
    DGE.Visible = True
End Sub

Private Sub Form_Resize()
    'Scale the component to cover the screen
    DGE.Width = Screen.Width
    DGE.Height = Screen.Height
    lblLoading.Left = (Screen.Width - lblLoading.Width) / 2
    lblLoading.Top = (Screen.Height - lblLoading.Height) / 2
End Sub

Private Sub tmrFPS_Timer()
    lblFPS = "FPS = " & FPSCount
    If FPSCount > 0 Then
        TimePerFrame = 1 / FPSCount 'This method is good at handling extremely high PFS but bad at changing PFS
    End If
    FPSCount = 0
End Sub

Private Sub tmrStart_Timer()
    tmrStart.Enabled = False
    LoadThings
    Do
        DoStuff
        DoEvents
        
        'Measure FPS
        FPSCount = FPSCount + 1
    Loop
End Sub

'Using the constant TimeStep
Private Sub FixedPhysics()
    Player.Move TimeStep, Gravity
End Sub

Private Sub UpdateSunAndSky(Camera As Long)
    Dim CameraPos As Vector3
    Dim CameraTarget As Vector3
    Dim SunIntensity As Single
    Dim FogColor As Vector3
    Dim SkyColor As Vector3
    Dim HighCloudColor As Vector3
    Dim MiddleCloudColor As Vector3
    Dim LowCloudColor As Vector3
    Dim AmbientLight As Vector3
    
    'Get camera location
    DGE.Camera_GetPosition_OutV3 Camera: RE: CameraPos = GetVector3FromMatrixBuffer
    
    'Update sun
    DGE.LightSource_SetDirection LightSource_Sun, SunDirection.X, SunDirection.Y, SunDirection.Z, 0, 1, 0: RE
    If SunDirection.Y < -0.01 Then
        SunIntensity = Saturate((-SunDirection.Y / AbsVector2(MakeVector2(SunDirection.X, SunDirection.Z))) - 0.1) * 0.7
        DGE.LightSource_SetShadowTransparency LightSource_Sun, 0 'Cast shadows
    Else
        SunIntensity = 0
        DGE.LightSource_SetShadowTransparency LightSource_Sun, 1 'Do not cast shadows
    End If
    DGE.LightSource_SetColor LightSource_Sun, SunIntensity, SunIntensity, SunIntensity
    
    'Set peoperties based on sun intensity
    SkyColor = LerpVector3(MakeVector3(0.02, 0, 0), MakeVector3(0, 0.2, 0.4), SunIntensity)
    FogColor = LerpVector3(MakeVector3(0.2, 0.18, 0.1), MakeVector3(0.96, 0.98, 1), SunIntensity)
    AmbientLight = MulVector3(FogColor, 0.5)
    HighCloudColor = LerpVector3(MakeVector3(0.3, 0.3, 0.3), MakeVector3(1.2, 1.2, 1.2), SunIntensity)
    MiddleCloudColor = LerpVector3(MakeVector3(0.2, 0.2, 0.2), MakeVector3(1, 1, 1), SunIntensity)
    LowCloudColor = LerpVector3(MakeVector3(0.1, 0.1, 0.1), MakeVector3(0.8, 0.8, 0.8), SunIntensity)
    
    'Update sky
    DGE.Enviroment_SetBackgroundColor FogColor.X, FogColor.Y, FogColor.Z, 1: RE
    DGE.LightSource_SetAmbientLight AmbientLight.X, AmbientLight.Y, AmbientLight.Z: RE
    DGE.Instance_SetColor Instance_Sky, SkyColor.X, SkyColor.Y, SkyColor.Z, 1 'The new background color that replace the fog's color
    DGE.Instance_SetUserDefinedData Instance_Sky, 0, SunDirection.X, SunDirection.Y, SunDirection.Z, 1 '(X,Y,Z,W) = (DirectionX,DirectionY,DirectionZ,Intensity)
    DGE.Instance_SetUserDefinedData Instance_Sky, 1, HighCloudColor.X, HighCloudColor.Y, HighCloudColor.Z, 0.7 'High cloud color multiplier in RGBA format
    DGE.Instance_SetUserDefinedData Instance_Sky, 2, MiddleCloudColor.X, MiddleCloudColor.Y, MiddleCloudColor.Z, 0.7 'Middle cloud color multiplier in RGBA format
    DGE.Instance_SetUserDefinedData Instance_Sky, 3, LowCloudColor.X, LowCloudColor.Y, LowCloudColor.Z, 0.7 'Low cloud color multiplier in RGBA format
    
    'Project shadows around the camera target
    DGE.Camera_GetTarget_OutV3 Camera: RE: CameraTarget = GetVector3FromMatrixBuffer
    DGE.LightSource_SetPos LightSource_Sun, CameraTarget.X, CameraPos.Y, CameraTarget.Z
    
    'Place the skybox
    DGE.Instance_SetPosition Instance_Sky, CameraPos.X, CameraPos.Y, CameraPos.Z
End Sub

Public Sub Terrain_AnimateWater(AnimationTime As Single)
    Dim WaveOffsetU1 As Single
    Dim WaveOffsetV1 As Single
    Dim WaveOffsetU2 As Single
    Dim WaveOffsetV2 As Single
    Dim WaveScale As Single
    Dim WaveIntensity As Single
    WaveScale = 5
    WaveIntensity = 0.8
    WaveOffsetU1 = AnimationTime
    WaveOffsetV1 = 0
    WaveOffsetU2 = -AnimationTime
    WaveOffsetV2 = WaveScale / 2
    frmMain.DGE.Instance_SetUserDefinedData Instance_WaterSurface, 0, WaveOffsetU1, WaveOffsetV1, WaveOffsetU2, WaveOffsetV2: RE
    frmMain.DGE.Instance_SetUserDefinedData Instance_WaterSurface, 1, WaveScale, WaveIntensity, 0, 0: RE
End Sub

Private Sub DoStuff()
    Dim CameraSystem As Matrix3
    Dim CameraSystem_Reflected As Matrix3
    Dim MouseOffset As Vector2
    
    'Get mouse input
    MouseOffset = Mouse_GetOffsetSinceLastCall
    
    'Control the camera
    CameraLongitude = FixRadianCenter(CameraLongitude + (MouseOffset.X * 0.002)) 'FixRadian center makes sure that the longitude is within the precondition for the Actor's target
    CameraLattitude = Clamp(-1.57, CameraLattitude + (MouseOffset.Y * -0.002), 1.2)
    
    'Get old camera axis system
    CameraSystem = MakeAxisSystem_Polar(CameraLongitude, CameraLattitude)
    CameraSystem_Reflected = MakeAxisSystem_Polar(CameraLongitude, -CameraLattitude)
    
    'Handle the player
    Player.WalkForward = KeyDown_ZeroToOne(vbKeyW) - KeyDown_ZeroToOne(vbKeyS)
    Player.WalkRight = KeyDown_ZeroToOne(vbKeyD) - KeyDown_ZeroToOne(vbKeyA)
    Player.Acceleration_Target = 1
    Player.Crouching_Target = KeyDown_ZeroToOne(vbKeyControl)
    Player.DirectionAngle_Target = CameraLongitude
    Player.TryToLookAtDirection CameraSystem.ZAxis.X, CameraSystem.ZAxis.Y, CameraSystem.ZAxis.Z
    Player.Jump = KeyDown_Truth(vbKeySpace)
    Player.Fire = KeyDown_Truth(vbKeyLButton)
    
    'Move physics using fixed steps
    Static PhysicsRemainder As Single
    PhysicsRemainder = Min_Float(PhysicsRemainder + TimePerFrame, 0.2)
    Do Until PhysicsRemainder < TimeStep
        'Game physics using TimeStep
        FixedPhysics
        
        PhysicsRemainder = PhysicsRemainder - TimeStep
    Loop
    
    'Let the camera follow behind the player
    Camera_Main_Pos = AddVector3(MakeVector3(Player.Position_X, Player.Position_Y + 1, Player.Position_Z), MulVector3(CameraSystem.ZAxis, -2))
    
    'Make sure that the camera is above the water level
    Camera_Main_Pos.Y = Max_Float(WaterLevel + 0.2, Camera_Main_Pos.Y)
    
    'Place and direct the camera
    DGE.Camera_Place Camera_Main, Camera_Main_Pos.X, Camera_Main_Pos.Y, Camera_Main_Pos.Z, Camera_Main_Pos.X + CameraSystem.ZAxis.X, Camera_Main_Pos.Y + CameraSystem.ZAxis.Y, Camera_Main_Pos.Z + CameraSystem.ZAxis.Z, CameraSystem.YAxis.X, CameraSystem.YAxis.Y, CameraSystem.YAxis.Z: RE
    Dim Camera_Reflection_Pos As Vector3
    Camera_Reflection_Pos = MakeVector3(Camera_Main_Pos.X, -Camera_Main_Pos.Y + (WaterLevel * 2), Camera_Main_Pos.Z)
    DGE.Camera_Place Camera_WaterReflection, Camera_Reflection_Pos.X, Camera_Reflection_Pos.Y, Camera_Reflection_Pos.Z, Camera_Reflection_Pos.X + CameraSystem_Reflected.ZAxis.X, Camera_Reflection_Pos.Y + CameraSystem_Reflected.ZAxis.Y, Camera_Reflection_Pos.Z + CameraSystem_Reflected.ZAxis.Z, CameraSystem_Reflected.YAxis.X, CameraSystem_Reflected.YAxis.Y, CameraSystem_Reflected.YAxis.Z: RE
    
    'Move the maze
    DGE.Instance_SetPosition Instance_Maze, Int(Camera_Main_Pos.X), 0, Int(Camera_Main_Pos.Z): RE
    
    'Move the water surface
    DGE.Instance_SetPosition Instance_WaterSurface, Camera_Main_Pos.X, WaterLevel, Camera_Main_Pos.Z: RE
    Terrain_AnimateWater Timer
    
    'Clear shadows
    DGE.LightSource_ClearShadows
    
    'Place the light
    SunDirection = NormalVector3(MakeVector3(0.7, -1, 0.4))
    
    'Set global time
    DGE.Shader_SetGlobalTime Timer: RE
    
    UpdateSunAndSky Camera_WaterReflection
    
    'Hide the water surface when rendering it's textures
    DGE.Instance_SetVisibility Instance_WaterSurface, 0, False: RE
    
    'Render the water reflection image
    If Camera_Main_Pos.Y > WaterLevel Then
        'Cut away pixels under the surface
        'Subtracting a small value will reduce holes from bumps and rounding errors but create another artifact if the value is too high.
        DGE.Camera_GiveCuttingPlane Camera_WaterReflection, 0, 1, 0, WaterLevel - 0.1, 1: RE
    Else
        'Cut away pixels above the surface
        'Subtracting a small value will reduce holes from bumps and rounding errors but create another artifact if the value is too high.
        DGE.Camera_GiveCuttingPlane Camera_WaterReflection, 0, -1, 0, -WaterLevel - 0.1, 1: RE
    End If
    
    UpdateSunAndSky Camera_Main
    DGE.Camera_RenderScene Camera_WaterReflection, DrawSurface_WaterReflection, 0: RE
    
    'Show the water surface when rendering the scene
    DGE.Instance_SetVisibility Instance_WaterSurface, 0, True: RE
    
    'Optimize by not rendering things behind the water surface.
    '0.1 is a treshold to handle that the near clip plane will show both sides when the camera it on the surface.
    If Camera_Main_Pos.Y > WaterLevel + 0.1 Then
        'Cut away pixels under the surface
        DGE.Camera_GiveCuttingPlane Camera_Main, 0, 1, 0, WaterLevel - 0.01, 1: RE
    Else
        DGE.Camera_RemoveCuttingPlane Camera_Main
    End If
    
    'Render the scene to D
    DGE.Camera_RenderScene Camera_Main, DrawSurface_D, 0: RE
    'PostEffects_DownSample from D to B
    PostEffects_DownSample DrawSurface_D, DrawSurface_B
    'Apply blur to B
    PostEffects_ApplyDiffuseBlur DrawSurface_B, 0.4 * BloomSize
    'Lower the gamma for B
    PostEffects_RaiseToPower DrawSurface_B, 1.7
    'Make lens reflection
    PostEffects_Apply4ArgPostEffect DrawSurface_B, PostEffect_LensReflection, DrawSurface_B, MakeVector4(0.02, 0.02, 0.02, -1), MakeVector4(0.02, 0.01, 0.01, -0.4), MakeVector4(0.01, 0.02, 0.01, 0.4), MakeVector4(0.01, 0.01, 0.02, -7)
    'Show a mix of D and B
    PostEffects_Mix2Surfaces DrawSurface_D, 0.45, DrawSurface_B, 0.55, DrawSurface_Final
    'DGE.Camera_RenderScene Camera_Main, DrawSurface_Final, 0: RE
    
    'Update the swap chain manually
    DGE.Engine_UpdateSwapChain
    
End Sub
