VERSION 5.00
Object = "{FE69BD77-3946-4641-8613-6FC7144F2E05}#12.0#0"; "DFPGE12.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   ClientHeight    =   7755
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   10590
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   MouseIcon       =   "Main.frx":08CA
   MousePointer    =   99  'Custom
   ScaleHeight     =   7755
   ScaleWidth      =   10590
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin VB.Timer tmrStart 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   10020
      Top             =   120
   End
   Begin DFPGELib.DFPGE DGE 
      Height          =   3435
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   3735
      Visible         =   0   'False
      _Version        =   786432
      _ExtentX        =   6588
      _ExtentY        =   6059
      _StockProps     =   0
   End
   Begin VB.Label lblLoading 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Loading"
      BeginProperty Font 
         Name            =   "Impact"
         Size            =   21.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   540
      Left            =   120
      TabIndex        =   1
      Top             =   7260
      Width           =   1410
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Const BloomSize As Single = 2.3

'Reference to a camera that we created
Dim Camera_Main As Long

'References to draw durfaces for the bloom effect
Dim DrawSurface_D As Long 'Default draw surface
Dim DrawSurface_B As Long 'Blur draw surface with a lower resolution
Dim DrawSurface_Final As Long 'Final draw surface for showing the final image

'Types combining visual and physical references makes it easy to reuse code
Private Type TypeOfItem
    Model As Long 'Visual model
    CollisionShape As Long 'Physical shape
    UniformScale As Single 'Size multipler from model space
End Type
Private Type Item
    Instance As Long 'Visual instance of the model
    RigidBody As Long 'Physical body using the shape
End Type

'Items
Const MaxNumberOfItems As Integer = 1024
Dim NumberOfItems As Integer
Dim DynamicItems(0 To MaxNumberOfItems - 1) As Item

'Item reference numbers
Dim Item_Ball As Long

'Player control
Dim CameraAngle As Single

'The sun
Dim LightSource_Sun As Long

'Time per render counting
Dim TimePerRender As Single

Private Function StartEngine() As Boolean
    StartEngine = DGE.Engine_Initiate: RE
End Function

'Loads a model and it's resources from FileName.
Private Function LoadModel(FileName As String) As Long
    InsertStringToEngine FileName
    LoadModel = DGE.Model_LoadFromFile_InSB: RE
    If LoadModel = -1 Then End
End Function

Private Sub Form_Load()
    Randomize Timer
    If StartEngine Then
        'Set the default folder so that relative paths can be used
        SetRelativeWorkingDirectory "..\CommonMediaFiles"
        
        'We start a timer to let this routine exit before we render anything
        'The graphical user interface will not be drawn until Form_Load has finished and therefor the main loop can't be placed in Form_Load.
        tmrStart.Enabled = True
    End If
End Sub

Private Sub LoadThings()
    'Load and use our default material shader that will be used when something don't have a shader in the current shader channel
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultMaterialShader": DGE.Shader_UseAsDefaultMaterialShader DGE.Shader_LoadAsMaterial_InSB: RE

    'Load and use our default texture that is used when a texture is missing
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultTexture": DGE.Texture_UseAsDefaultTexture DGE.Texture_Load_InSB: RE
    
    'Create a camera and take the reference number
    Camera_Main = DGE.Camera_Create: RE
    
    'Set the field of view
    DGE.Camera_SetVerticalFOV_InDegrees Camera_Main, 60
    
    'Get the version specific ID to the final draw surface
    DrawSurface_Final = DGE.DrawSurface_GetFinalOutput: RE
    
    'Set the background color
    DGE.Enviroment_SetBackgroundColor 0.7, 0.8, 0.9, 1: RE
    
    'Set the amount of ambient light
    DGE.LightSource_SetAmbientLight 0.1, 0.15, 0.2: RE
    
    'Set the depth atlas resolution for dynamic shadows
    DGE.LightSource_SetDepthAtlasResolution 1024 * 8: RE
    
    'Create the sun
    'If you haven't chosen a size using LightSource_SetDepthAtlasResolution, the default size will be allocated automatically.
    LightSource_Sun = DGE.LightSource_Create_Sun_Shadowcasting_SingleLayer(0, 1, 0, 0, -1, 0, 1, 0, 0, -1000, 1000, 0.9, 0.8, 0.6, 50, 50, 0, 0, 1, 0.1): RE
    
    'Create draw surfaces
    DrawSurface_D = DGE.DrawSurface_CreateAutoSized(1, 1, 0, 0, 1, True): RE 'Allow rendering a 3D scene to it but not using soft particles and allow rendering from and to itself.
    DrawSurface_B = DGE.DrawSurface_CreateAutoSized(0.25, 0.25, 0, 0, 0, True): RE 'Allow rendering from and to itself.
    
    'Make the ball
    Dim TypeOfItem_Sphere As TypeOfItem
    TypeOfItem_Sphere = CreateItemType_Compound("Model_Shape_Sphere", 0.6)
    Item_Ball = CreateItem_Dynamic(TypeOfItem_Sphere, 5, 8, 0.5, 0.1, 0.3, MakeVector3(0, 1, 0), MakeVector3(1, 0, 0), MakeVector3(0, 1, 0), MakeVector3(1, 1, 1), 4)
    
    SpawnByName "Crate", 2, 8
    SpawnByName "Barrel", 2, 8
    SpawnByName "Chair", 0.3, 7
    SpawnByName "Ladder", 2, 6
    SpawnByName "Ladder_Short", 2, 5
    SpawnByName "Shelf", 2, 5
    
    'Set the visible range for rigid bodies when debug drawing
    DGE.Physics_SetDebugDrawRadius 1000: RE
    
    'Load and use the level model
    Dim TypeOfItem_Level As TypeOfItem
    TypeOfItem_Level = CreateItemType_Compound("Level_Bridge", 1)
    CreateItem_Static TypeOfItem_Level, 0.5, 0.5, MakeVector3(0, 0, 0), MakeVector3(1, 0, 0), MakeVector3(0, 1, 0), MakeVector3(1, 1, 1)
    
    'Set global properties
    DGE.Enviroment_SetNearClipPlane 0.1: RE
    DGE.Enviroment_SetFarClipPlane 100: RE
    DGE.Enviroment_SetMaxFogIntensity 1: RE
    
    'Initiate modules
    Mouse_Init
    PostEffects_Init
    
    lblLoading.Visible = False
    DGE.Visible = True
End Sub

Private Sub SpawnByName(Name As String, UniformScale As Single, Count As Long)
    Dim ItemType As TypeOfItem
    ItemType = CreateItemType_Compound("Model_" & Name, UniformScale)
    Static I As Long
    For I = 1 To Count
        CreateItem_Dynamic ItemType, 3, 1, 0.5, 0.1, 0.3, MakeVector3((Rnd * 8) - 4, (Rnd * 50) + 2, (Rnd * 8) - 4), MakeVector3(1, 0, 0), MakeVector3(0, 1, 0), MakeVector3(1, 1, 1), 1
    Next I
End Sub

Private Function CreateItem_Dynamic(TheType As TypeOfItem, Mass As Single, Friction As Single, Restitution As Single, LinearDamping As Single, AngularDamping As Single, Position As Vector3, XAxis As Vector3, YAxis As Vector3, Color As Vector3, ActivationState As Long) As Long
    If NumberOfItems < MaxNumberOfItems Then
        'Create a visual instance
        DynamicItems(NumberOfItems).Instance = DGE.Instance_Create(TheType.Model): RE
            'Set the color
            DGE.Instance_SetColor DynamicItems(NumberOfItems).Instance, Color.X, Color.Y, Color.Z, 1
        
        'Create a rigid body
        DynamicItems(NumberOfItems).RigidBody = DGE.RigidBody_Create_Dynamic(TheType.CollisionShape, Mass, Position.X, Position.Y, Position.Z, XAxis.X, XAxis.Y, XAxis.Z, YAxis.X, YAxis.Y, YAxis.Z): RE
            'Set physical properties
            DGE.RigidBody_SetFriction DynamicItems(NumberOfItems).RigidBody, Friction: RE
            DGE.RigidBody_SetLinearDamping DynamicItems(NumberOfItems).RigidBody, LinearDamping: RE
            DGE.RigidBody_SetAngularDamping DynamicItems(NumberOfItems).RigidBody, AngularDamping: RE
            DGE.RigidBody_SetActivationState DynamicItems(NumberOfItems).RigidBody, ActivationState: RE
            DGE.RigidBody_SetRestitution DynamicItems(NumberOfItems).RigidBody, Restitution: RE
            DGE.Instance_FollowRigidBody DynamicItems(NumberOfItems).Instance, DynamicItems(NumberOfItems).RigidBody, True: RE
        
        'Return the new item's index
        CreateItem_Dynamic = NumberOfItems
        
        'Increase the number of items in the counter
        NumberOfItems = NumberOfItems + 1
    Else
        'In case that too many dynamic items are spawned.
        MsgBox "The maximum number of items in the game has been reached."
        CreateItem_Dynamic = -1
    End If
End Function

Private Sub CreateItem_Static(TheType As TypeOfItem, Friction As Single, Restitution As Single, Position As Vector3, XAxis As Vector3, YAxis As Vector3, Color As Vector3)
    Static NewItem As Item
    'Create a visual instance
    NewItem.Instance = DGE.Instance_Create(TheType.Model): RE
        'Set the color
        DGE.Instance_SetColor NewItem.Instance, Color.X, Color.Y, Color.Z, 1
    
    'Create a rigid body
    NewItem.RigidBody = DGE.RigidBody_Create_Static(TheType.CollisionShape, Position.X, Position.Y, Position.Z, XAxis.X, XAxis.Y, XAxis.Z, YAxis.X, YAxis.Y, YAxis.Z): RE
    
    'Set the body's properties
    DGE.RigidBody_SetFriction NewItem.RigidBody, Friction: RE
    DGE.RigidBody_SetRestitution NewItem.RigidBody, Restitution: RE
    
    'Place the visual instance at the rigid body
    SynchronizeWithRigidBody NewItem, True
End Sub

Private Sub SynchronizeWithRigidBody(TheItem As Item, UseLocalScaling As Boolean)
    DGE.Instance_PlaceAtRigidBody TheItem.Instance, TheItem.RigidBody, UseLocalScaling: RE
End Sub

Private Sub SynchronizeWithRigidBody_Interpolated(TheItem As Item, TimeOffset As Single, UseLocalScaling As Boolean)
    DGE.Instance_PlaceAtRigidBody_Interpolated TheItem.Instance, TheItem.RigidBody, TimeOffset, UseLocalScaling: RE
End Sub

'Load the graphical model and create a compound collision shape from the shapes stored in the model
Private Function CreateItemType_Compound(ModelName As String, UniformScale As Single) As TypeOfItem
    CreateItemType_Compound.Model = LoadModel(ModelName)
    CreateItemType_Compound.CollisionShape = GetCollisionShapeFromModel(CreateItemType_Compound.Model, UniformScale)
    CreateItemType_Compound.UniformScale = UniformScale
End Function

Private Sub Form_Resize()
    'Scale the component to cover the screen
    DGE.Width = Screen.Width
    DGE.Height = Screen.Height
    lblLoading.Left = (Screen.Width - lblLoading.Width) / 2
    lblLoading.Top = (Screen.Height - lblLoading.Height) / 2
End Sub

Private Sub tmrStart_Timer()
    Static TenFrameCounter As Integer
    Static LastTenFrameTime As Single
    tmrStart.Enabled = False
    LoadThings
    LastTenFrameTime = Timer
    Do
        If KeyDown_Truth(vbKeyEscape) Then End 'Checking if escape is pressed works even if the application is flooded by error messages.
        DoStuff
        DoEvents
        TenFrameCounter = TenFrameCounter + 1
        If TenFrameCounter > 9 Then
            TenFrameCounter = 0
            If Timer - LastTenFrameTime > 0 Then
                TimePerRender = (Timer - LastTenFrameTime) / 10
            End If
            LastTenFrameTime = Timer
        End If
    Loop
End Sub

Private Sub Render(Camera As Long)
    'Render the scene with shader channel 0 to surface D
        DGE.Camera_RenderScene Camera, DrawSurface_D, 0: RE
    'Apply a bloom effect and show the result
        'PostEffects_DownSample from D to B
        PostEffects_DownSample DrawSurface_D, DrawSurface_B
        'Apply blur to B
        PostEffects_ApplyDiffuseBlur DrawSurface_B, 0.4 * BloomSize
        'Lower the gamma for B
        PostEffects_RaiseToPower DrawSurface_B, 1.6
        'Show a mix of D and B
        PostEffects_Mix2Surfaces DrawSurface_D, 0.6, DrawSurface_B, 0.7, DrawSurface_Final
End Sub

Private Sub DoStuff()
    Static I As Long
    
    'Get the mouse move
    Static MouseOffset As Vector2
    MouseOffset = Mouse_GetOffsetSinceLastCall
    
    'Rotate the camera
    CameraAngle = CameraAngle + ((MouseOffset.X + (KeyDown_ZeroToOne(vbKeyRight) - KeyDown_ZeroToOne(vbKeyLeft))) * (2 * TimePerRender))
    
    'Generate an axis system
    Static ForwardAxis As Vector3
    Static RightAxis As Vector3
    ForwardAxis = MakeVector3(Sin(CameraAngle), 0, Cos(CameraAngle))
    RightAxis = MakeVector3(ForwardAxis.Z, 0, -ForwardAxis.X)
    
    'Move physics using fixed steps
    Static PhysicsRemainder As Single
    Const TimeStep As Single = 1 / 120
    PhysicsRemainder = Min_Float(PhysicsRemainder + TimePerRender, 0.2)
    Do Until PhysicsRemainder < TimeStep
        'Rotate the ball
        Static Torque As Vector2
        Static Jump As Single
        Torque.Y = Clamp(-1, KeyDown_ZeroToOne(vbKeyUp) + KeyDown_ZeroToOne(vbKeyW) - KeyDown_ZeroToOne(vbKeyDown) - KeyDown_ZeroToOne(vbKeyS), 1)
        Torque.X = Clamp(-1, KeyDown_ZeroToOne(vbKeyA) - KeyDown_ZeroToOne(vbKeyD), 1)
        Jump = KeyDown_ZeroToOne(vbKeySpace)
        If AbsVector2(Torque) > 1 Then
            Torque = NormalVector2(Torque)
        End If
        Torque = MulVector2(Torque, 20)
        
        'Move forward/backward by rotating around the right axis
        DGE.RigidBody_Dynamic_ApplyForce_Angular DynamicItems(Item_Ball).RigidBody, RightAxis.X * Torque.Y, RightAxis.Y * Torque.Y, RightAxis.Z * Torque.Y: RE
        
        'Move left/right by rotating around the forward axis
        DGE.RigidBody_Dynamic_ApplyForce_Angular DynamicItems(Item_Ball).RigidBody, ForwardAxis.X * Torque.X, ForwardAxis.Y * Torque.X, ForwardAxis.Z * Torque.X: RE
        
        If Jump > 0 Then
            DGE.RigidBody_GetLinearVelocity_OutV3 DynamicItems(Item_Ball).RigidBody
            DGE.RigidBody_SetLinearVelocity DynamicItems(Item_Ball).RigidBody, DGE.GetX1, Max_Float(DGE.GetY1, 6), DGE.GetZ1
        End If
        
        DGE.Physics_Step TimeStep: RE
        PhysicsRemainder = PhysicsRemainder - TimeStep
    Loop
    
    'Use the connections in the engine to automatically let instances follow their rigid bodies
    DGE.Physics_LetInstancesFollowRigidBodies_Interpolated PhysicsRemainder: RE
    
    'Follow the ball with the camera
    Static BallPosition As Vector3
    DGE.Instance_GetPosition_OutV3 DynamicItems(Item_Ball).Instance: BallPosition = GetVector3FromMatrixBuffer: RE
    DGE.Camera_Place Camera_Main, BallPosition.X - (ForwardAxis.X * 4), BallPosition.Y + 1, BallPosition.Z - (ForwardAxis.Z * 4), BallPosition.X, BallPosition.Y, BallPosition.Z, 0, 1, 0: RE
    
    'Rotate spotlight
    Static LightAngle As Single
    LightAngle = Timer * -0.5
    DGE.LightSource_SetPos LightSource_Sun, BallPosition.X, BallPosition.Y, BallPosition.Z: RE
    DGE.LightSource_SetDirection LightSource_Sun, 0.4, -1, 0.4, 0, 1, 0: RE
    
    'Clear shadows
    DGE.LightSource_ClearShadows
    
    'Activate debug drawing
    DGE.Camera_SetDebugViewVisibility Camera_Main, 0, KeyDown_Truth(vbKeyF1) 'World axis system
    DGE.Camera_SetDebugViewVisibility Camera_Main, 1, KeyDown_Truth(vbKeyF2) 'Rigid bodies
    DGE.Camera_SetDebugViewVisibility Camera_Main, 2, KeyDown_Truth(vbKeyF3) 'Constraints
    DGE.Camera_SetDebugViewVisibility Camera_Main, 3, KeyDown_Truth(vbKeyF4) 'Collisions
    DGE.Camera_SetDebugViewVisibility Camera_Main, 4, KeyDown_Truth(vbKeyF5) 'Instances
    
    'Render the scene to the final draw surface that is displayed directly on the component
    'We render channel 0 for visible light
    Render Camera_Main
End Sub
