Attribute VB_Name = "EngineShell"

'This module is a simplifying syntax shell for David Piuva's graphics engine.
'By only using simple datatypes in the ActiveX interface, more languages are supported.

'Whenever a new method in the engine have complicated ways to get called, make
'  your own method in you own shell module for easy upgrading.
'Remember to replace frmMain.DGE with whatever your window and engine instance is called.

Option Explicit

'Error counter
Public Errors As Long

'Print error messages from the graphics engine
'This should be placed after every call to the engine that can give error messages so that the application will break in debug mode when an error has occured.
Public Sub RE() 'Read error
    Do While frmMain.DGE.Message_GetCount > 0
        frmMain.DGE.Message_GetContent_OutSB
        PrintText "Error message: " & GetStringFromEngine
        Errors = Errors + 1
    Loop
End Sub

Public Function EE() As Boolean 'Expect error
    Dim Message As String
    If frmMain.DGE.Message_GetCount > 0 Then
        'Ignore all error messages
        Do While frmMain.DGE.Message_GetCount > 0
            frmMain.DGE.Message_GetContent_OutSB
            Message = GetStringFromEngine
        Loop
        EE = True
    Else
        'Complain if we did not get an error message
        PrintText "Error message were expected but no message was found."
        Errors = Errors + 1
        EE = False
    End If
End Function

Public Sub PrintText(T As String)
    frmMain.txtOutput = frmMain.txtOutput & T & vbNewLine
End Sub

Public Sub InsertStringToEngine(T As String)
    Static I As Long
    frmMain.DGE.SetLengthOfStringBuffer Len(T)
    For I = 1 To Len(T)
        frmMain.DGE.WriteToStringBuffer I, Asc(Mid(T, I, 1))
    Next I
End Sub

Public Function GetStringFromEngine() As String
    Static I As Long
    GetStringFromEngine = ""
    For I = 1 To frmMain.DGE.GetLengthOfStringBuffer
        GetStringFromEngine = GetStringFromEngine & Chr(frmMain.DGE.ReadFromStringBuffer(I))
    Next I
End Function

Public Function GetVector2FromMatrixBuffer() As Vector2
    GetVector2FromMatrixBuffer = MakeVector2(frmMain.DGE.GetX1, frmMain.DGE.GetY1)
End Function

Public Function GetVector3FromMatrixBuffer() As Vector3
    GetVector3FromMatrixBuffer = MakeVector3(frmMain.DGE.GetX1, frmMain.DGE.GetY1, frmMain.DGE.GetZ1)
End Function

Public Function GetSecondVector3FromMatrixBuffer() As Vector3
    GetSecondVector3FromMatrixBuffer = MakeVector3(frmMain.DGE.GetX2, frmMain.DGE.GetY2, frmMain.DGE.GetZ2)
End Function

Public Function GetVector4FromMatrixBuffer() As Vector4
    GetVector4FromMatrixBuffer = MakeVector4(frmMain.DGE.GetX1, frmMain.DGE.GetY1, frmMain.DGE.GetZ1, frmMain.DGE.GetW1)
End Function

Public Function GetMatrix3FromMatrixBuffer() As Matrix3
    GetMatrix3FromMatrixBuffer = MakeMatrix3(MakeVector3(frmMain.DGE.GetX1, frmMain.DGE.GetY1, frmMain.DGE.GetZ1), MakeVector3(frmMain.DGE.GetX2, frmMain.DGE.GetY2, frmMain.DGE.GetZ2), MakeVector3(frmMain.DGE.GetX3, frmMain.DGE.GetY3, frmMain.DGE.GetZ3))
End Function

Public Function GetMatrix4FromMatrixBuffer() As Matrix4
    GetMatrix4FromMatrixBuffer = MakeMatrix4(MakeVector4(frmMain.DGE.GetX1, frmMain.DGE.GetY1, frmMain.DGE.GetZ1, frmMain.DGE.GetW1), MakeVector4(frmMain.DGE.GetX2, frmMain.DGE.GetY2, frmMain.DGE.GetZ2, frmMain.DGE.GetW2), MakeVector4(frmMain.DGE.GetX3, frmMain.DGE.GetY3, frmMain.DGE.GetZ3, frmMain.DGE.GetW3), MakeVector4(frmMain.DGE.GetX4, frmMain.DGE.GetY4, frmMain.DGE.GetZ4, frmMain.DGE.GetW4))
End Function

Public Sub InsertMatrix4ToMatrixBuffer(M As Matrix4)
    frmMain.DGE.SetX1 M.XAxis.X
    frmMain.DGE.SetY1 M.XAxis.Y
    frmMain.DGE.SetZ1 M.XAxis.Z
    frmMain.DGE.SetW1 M.XAxis.W
    frmMain.DGE.SetX2 M.YAxis.X
    frmMain.DGE.SetY2 M.YAxis.Y
    frmMain.DGE.SetZ2 M.YAxis.Z
    frmMain.DGE.SetW2 M.YAxis.W
    frmMain.DGE.SetX3 M.ZAxis.X
    frmMain.DGE.SetY3 M.ZAxis.Y
    frmMain.DGE.SetZ3 M.ZAxis.Z
    frmMain.DGE.SetW3 M.ZAxis.W
    frmMain.DGE.SetX4 M.WAxis.X
    frmMain.DGE.SetY4 M.WAxis.Y
    frmMain.DGE.SetZ4 M.WAxis.Z
    frmMain.DGE.SetW4 M.WAxis.W
End Sub

Public Function GetDrawSurfaceWidth(DrawSurface As Long) As Long
    GetDrawSurfaceWidth = frmMain.DGE.DrawSurface_GetWidth(DrawSurface): RE
End Function

Public Function GetDrawSurfaceHeight(DrawSurface As Long) As Long
    GetDrawSurfaceHeight = frmMain.DGE.DrawSurface_GetHeight(DrawSurface): RE
End Function

Public Function GetCPUSurfaceWidth(CPUSurface As Long) As Long
    GetCPUSurfaceWidth = frmMain.DGE.CPUSurface_GetWidth(CPUSurface): RE
End Function

Public Function GetCPUSurfaceHeight(CPUSurface As Long) As Long
    GetCPUSurfaceHeight = frmMain.DGE.CPUSurface_GetHeight(CPUSurface): RE
End Function

Public Sub CopyFromDrawSurfaceToCPUSurface(DrawSurface As Long, CPUSurface As Long)
    frmMain.DGE.CPUSurface_CopyRectFromDrawSurface DrawSurface, CPUSurface, 0, 0, 0, 0, GetDrawSurfaceWidth(DrawSurface), GetDrawSurfaceHeight(DrawSurface): RE
End Sub
