VERSION 5.00
Object = "{FE69BD77-3946-4641-8613-6FC7144F2E05}#10.0#0"; "DFPGE10.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00008000&
   Caption         =   "Regression tests for David Piuva's graphics engine"
   ClientHeight    =   7755
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   10590
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7755
   ScaleWidth      =   10590
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdRun 
      BackColor       =   &H0000C000&
      Caption         =   "Run regression tests"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   555
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   120
      Width           =   10335
   End
   Begin VB.TextBox txtOutput 
      Appearance      =   0  'Flat
      BackColor       =   &H00000000&
      ForeColor       =   &H0080FF80&
      Height          =   6855
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   1
      Top             =   780
      Width           =   10335
   End
   Begin DFPGELib.DFPGE DGE 
      Height          =   795
      Left            =   240
      TabIndex        =   0
      Top             =   900
      Width           =   915
      Visible         =   0   'False
      _Version        =   655360
      _ExtentX        =   1614
      _ExtentY        =   1402
      _StockProps     =   0
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'I let this regression test be an SDK sample because it is good to know how to perform regression tests on an engine.

Option Explicit

'Reference to a camera that we created
Dim Camera_Main As Long

'Reference to the draw durface that we must render to before we see anything.
Dim DrawSurface_Final As Long

Private Function StartEngine() As Boolean
    StartEngine = DGE.Engine_Initiate: RE
End Function

Private Sub cmdRun_Click()
    RunTestCases
End Sub

Private Sub Form_Load()
    If Not StartEngine Then
        MsgBox "Could not start the engine.", vbCritical, "Error!"
    End If
End Sub

Private Sub Form_Resize()
    cmdRun.Width = Me.Width - cmdRun.Left - 200
    txtOutput.Width = Me.Width - txtOutput.Left - 200
    txtOutput.Height = Me.Height - txtOutput.Top - 500
End Sub

Private Sub PrintResult(TestName As String, Passed As Boolean)
    If Passed Then
        PrintText "Passed test: " & TestName
    Else
        PrintText "Failed test: " & TestName
        Errors = Errors + 1
    End If
End Sub

Private Sub AssertEqual(TestName As String, A As Variant, B As Variant)
    Dim Passed As Boolean
    Passed = (A = B)
    PrintResult TestName, Passed
    If Not Passed Then
        PrintText "    """ & A & """ is not """ & B & """"
    End If
End Sub

Private Sub AssertAlmostEqualSingle(TestName As String, A As Single, B As Single, Tolerance As Single)
    Dim Passed As Boolean
    Passed = (Abs(A - B) < Tolerance)
    PrintResult TestName, Passed
    If Not Passed Then PrintText "    " & A & " is not close to " & B
End Sub

Private Sub AssertAlmostEqualVector2(TestName As String, A As Vector2, B As Vector2, Tolerance As Single)
    Dim Passed As Boolean
    Passed = (Abs(A.X - B.X) < Tolerance And Abs(A.Y - B.Y) < Tolerance)
    PrintResult TestName, Passed
    If Not Passed Then PrintText "    ( " & A.X & "   " & A.Y & " )" & " is not close to ( " & B.X & "   " & B.Y & " )"
End Sub

Private Sub AssertAlmostEqualVector3(TestName As String, A As Vector3, B As Vector3, Tolerance As Single)
    Dim Passed As Boolean
    Passed = (Abs(A.X - B.X) < Tolerance And Abs(A.Y - B.Y) < Tolerance And Abs(A.Z - B.Z) < Tolerance)
    PrintResult TestName, Passed
    If Not Passed Then PrintText "    ( " & A.X & "   " & A.Y & "   " & A.Z & " )" & " is not close to ( " & B.X & "   " & B.Y & "   " & B.Z & " )"
End Sub

Private Sub AssertAlmostEqualVector4(TestName As String, A As Vector4, B As Vector4, Tolerance As Single)
    Dim Passed As Boolean
    Passed = (Abs(A.X - B.X) < Tolerance And Abs(A.Y - B.Y) < Tolerance And Abs(A.Z - B.Z) < Tolerance And Abs(A.W - B.W) < Tolerance)
    PrintResult TestName, Passed
    If Not Passed Then PrintText "    ( " & A.X & "   " & A.Y & "   " & A.Z & "   " & A.W & " )" & " is not close to ( " & B.X & "   " & B.Y & "   " & B.Z & "   " & B.W & " )"
End Sub

Private Sub AssertAlmostEqualMatrix4(TestName As String, A As Matrix4, B As Matrix4, Tolerance As Single)
    PrintResult TestName, (Abs(A.XAxis.X - B.XAxis.X) < Tolerance And Abs(A.XAxis.Y - B.XAxis.Y) < Tolerance And Abs(A.XAxis.Z - B.XAxis.Z) < Tolerance And Abs(A.XAxis.W - B.XAxis.W) < Tolerance And Abs(A.YAxis.X - B.YAxis.X) < Tolerance And Abs(A.YAxis.Y - B.YAxis.Y) < Tolerance And Abs(A.YAxis.Z - B.YAxis.Z) < Tolerance And Abs(A.YAxis.W - B.YAxis.W) < Tolerance And Abs(A.ZAxis.X - B.ZAxis.X) < Tolerance And Abs(A.ZAxis.Y - B.ZAxis.Y) < Tolerance And Abs(A.ZAxis.Z - B.ZAxis.Z) < Tolerance And Abs(A.ZAxis.W - B.ZAxis.W) < Tolerance And Abs(A.WAxis.X - B.WAxis.X) < Tolerance And Abs(A.WAxis.Y - B.WAxis.Y) < Tolerance And Abs(A.WAxis.Z - B.WAxis.Z) < Tolerance And Abs(A.WAxis.W - B.WAxis.W) < Tolerance)
End Sub

Private Sub TestStringBuffer(TestName As String, InputString As String)
    Dim OutputString As String
    InsertStringToEngine InputString
    OutputString = GetStringFromEngine
    AssertEqual TestName, InputString, OutputString
End Sub

Private Sub TestMatrixBuffer(TestName As String, InputMatrix As Matrix4)
    Dim OutputMatrix As Matrix4
    InsertMatrix4ToMatrixBuffer InputMatrix
    OutputMatrix = GetMatrix4FromMatrixBuffer
    AssertAlmostEqualMatrix4 TestName, InputMatrix, OutputMatrix, 0.0001
    'GetMatrix4FromMatrixBuffer
End Sub

'This kind of testing can't replace the human observer but most of the errors are in the trivial but many getters and setters.
'No random is allowed in regression tests because I want to know instantly if a change created a bug or solved a bug.
Private Sub RunTestCases()
    Dim I As Long
    Dim X As Long
    Dim Y As Long
    Dim RefA As Long
    Dim RefB As Long
    Dim RefC As Long
    Dim RefD As Long
    Dim Model As Long
    Dim ModelCopy As Long
    Dim Instance As Long
    Dim Part As Long
    Dim Tri As Long
    Dim Vert As Long
    Dim InputValue As Single
    Dim OutputValue As Single
    Dim InputVector2 As Vector2
    Dim OutputVector2 As Vector2
    Dim InputVector3 As Vector3
    Dim OutputVector3 As Vector3
    Dim InputVector4 As Vector4
    Dim OutputVector4 As Vector4
    Errors = 0
    txtOutput = ""
    DoEvents
        'Test the string buffer
        TestStringBuffer "String buffer empty", ""
        TestStringBuffer "String buffer ABC", "ABC"
        TestStringBuffer "String buffer LineBreak", "One" & vbNewLine & "Two" & vbNewLine & "Three"
    DoEvents
        'Test the matrix buffer
        TestMatrixBuffer "Matrix buffer zero", MakeMatrix4(MakeVector4(0, 0, 0, 0), MakeVector4(0, 0, 0, 0), MakeVector4(0, 0, 0, 0), MakeVector4(0, 0, 0, 0))
        TestMatrixBuffer "Matrix buffer positive", MakeMatrix4(MakeVector4(543.23, 76.234, 36.76, 276.346), MakeVector4(745.2356, 927.437, 35.872, 763.354), MakeVector4(35.763, 2483.65, 653.123, 76.236), MakeVector4(276.35, 724.456, 127.35, 653.834))
        TestMatrixBuffer "Matrix buffer negative", MakeMatrix4(MakeVector4(-543.23, -76.234, -36.76, -276.346), MakeVector4(-745.235, -927.437, -35.872, -763.354), MakeVector4(-35.763, -2483.65, -653.123, -76.236), MakeVector4(-276.35, -724.456, -127.35, -653.834))
        TestMatrixBuffer "Matrix buffer count", MakeMatrix4(MakeVector4(1, 2, 3, 4), MakeVector4(5, 6, 7, 8), MakeVector4(9, 10, 11, 12), MakeVector4(13, 14, 15, 16))
    DoEvents
        'Test setted and getter for background/fog color
        InputVector4 = MakeVector4(0.634, -0.724, 0.145, 52.4)
        DGE.Enviroment_SetBackgroundColor InputVector4.X, InputVector4.Y, InputVector4.Z, InputVector4.W: RE
        DGE.Enviroment_GetBackgroundColor_OutV4: OutputVector4 = GetVector4FromMatrixBuffer: RE
        AssertAlmostEqualVector4 "Background color", InputVector4, OutputVector4, 0.0001
    DoEvents
        'Test setter and getter for near clip plane
        InputValue = 0.532
        DGE.Enviroment_SetNearClipPlane InputValue: RE
        OutputValue = DGE.Enviroment_GetNearClipPlane: RE
        AssertAlmostEqualSingle "Near clip plane", InputValue, OutputValue, 0.0001
    DoEvents
        'Test setter and getter for far clip plane
        InputValue = 367.43
        DGE.Enviroment_SetFarClipPlane InputValue: RE
        OutputValue = DGE.Enviroment_GetFarClipPlane: RE
        AssertAlmostEqualSingle "Far clip plane", InputValue, OutputValue, 0.0001
    DoEvents
        'Test setter and getter for low to medium detail level limit
        InputValue = 118.35
        DGE.Enviroment_SetLowMediumDetailLimit InputValue: RE
        OutputValue = DGE.Enviroment_GetLowMediumDetailLimit: RE
        AssertAlmostEqualSingle "Low to medium detail level limit", InputValue, OutputValue, 0.0001
    DoEvents
        'Test setter and getter for medium to high detail level limit
        InputValue = 195.83
        DGE.Enviroment_SetMediumHighDetailLimit InputValue: RE
        OutputValue = DGE.Enviroment_GetMediumHighDetailLimit: RE
        AssertAlmostEqualSingle "Medium to high detail level limit", InputValue, OutputValue, 0.0001
    DoEvents
        'Test setter and getter for maximum fog intensity
        InputValue = 0.634
        DGE.Enviroment_SetMaxFogIntensity InputValue: RE
        OutputValue = DGE.Enviroment_GetMaxFogIntensity: RE
        AssertAlmostEqualSingle "Maximum fog intensity", InputValue, OutputValue, 0.0001
    DoEvents
        'Create Draw and CPU surfaces
        RefA = DGE.DrawSurface_CreateFixed(1, 10, 0, True): RE
        RefB = DGE.DrawSurface_CreateFixed(10, 1, 0, False): RE
        RefC = DGE.CPUSurface_CreateFixed(1, 10, 1, 2, 3, 4): RE
        RefD = DGE.CPUSurface_CreateFixed(10, 1, 5, 6, 7, 8): RE
        
        'Fill the draw surfaces with pixels
        For X = 0 To GetDrawSurfaceWidth(RefA) - 1
            For Y = 0 To GetDrawSurfaceHeight(RefA) - 1
                DGE.DrawSurface_SetPixelColor RefA, X, Y, X / 10, Y / 10, X + Y, Y - 2: RE
            Next Y
        Next X
        For X = 0 To GetDrawSurfaceWidth(RefB) - 1
            For Y = 0 To GetDrawSurfaceHeight(RefB) - 1
                DGE.DrawSurface_SetPixelColor RefB, X, Y, X / 5, Y / 5, X - Y, X / 4: RE
            Next Y
        Next X
        
        'Check the results
        For X = 0 To GetDrawSurfaceWidth(RefA) - 1
            For Y = 0 To GetDrawSurfaceHeight(RefA) - 1
                DGE.DrawSurface_GetPixelColor_OutV4 RefA, X, Y: OutputVector4 = GetVector4FromMatrixBuffer: RE
                AssertAlmostEqualVector4 "Vertical draw surface (" & X & "," & Y & ")", OutputVector4, MakeVector4(X / 10, Y / 10, X + Y, Y - 2), 0.0001
            Next Y
        Next X
        For X = 0 To GetDrawSurfaceWidth(RefB) - 1
            For Y = 0 To GetDrawSurfaceHeight(RefB) - 1
                DGE.DrawSurface_GetPixelColor_OutV4 RefB, X, Y: OutputVector4 = GetVector4FromMatrixBuffer: RE
                AssertAlmostEqualVector4 "Horizontal draw surface (" & X & "," & Y & ")", OutputVector4, MakeVector4(X / 5, Y / 5, X - Y, X / 4), 0.0001
            Next Y
        Next X
        
        'Copy to the CPU at once
        CopyFromDrawSurfaceToCPUSurface RefA, RefC
        
        'Copy to the CPU in 3 parts
        DGE.CPUSurface_CopyRectFromDrawSurface RefB, RefD, 0, 0, 0, 0, 3, GetDrawSurfaceHeight(RefB)
        DGE.CPUSurface_CopyRectFromDrawSurface RefB, RefD, 3, 0, 3, 0, 5, GetDrawSurfaceHeight(RefB)
        DGE.CPUSurface_CopyRectFromDrawSurface RefB, RefD, 8, 0, 8, 0, 2, GetDrawSurfaceHeight(RefB)
        'CopyFromDrawSurfaceToCPUSurface RefB, RefD 'This would do the same thing but the test cases need variation to catch odd cases
        
        'Check the results
        For X = 0 To GetCPUSurfaceWidth(RefC) - 1
            For Y = 0 To GetCPUSurfaceHeight(RefC) - 1
                DGE.CPUSurface_GetPixelColor_Clamped_OutV4 RefC, X, Y: OutputVector4 = GetVector4FromMatrixBuffer: RE
                AssertAlmostEqualVector4 "Vertical CPU surface copy (" & X & "," & Y & ")", OutputVector4, MakeVector4(X / 10, Y / 10, X + Y, Y - 2), 0.0001
            Next Y
        Next X
        For X = 0 To GetCPUSurfaceWidth(RefD) - 1
            For Y = 0 To GetCPUSurfaceHeight(RefD) - 1
                DGE.CPUSurface_GetPixelColor_Clamped_OutV4 RefD, X, Y: OutputVector4 = GetVector4FromMatrixBuffer: RE
                AssertAlmostEqualVector4 "Horizontal CPU surface copy (" & X & "," & Y & ")", OutputVector4, MakeVector4(X / 5, Y / 5, X - Y, X / 4), 0.0001
            Next Y
        Next X
        
        'Clean up to save memory
        DGE.DrawSurface_Delete RefA: RE
        DGE.DrawSurface_Delete RefB: RE
        DGE.CPUSurface_Delete RefC: RE
        DGE.CPUSurface_Delete RefD: RE
    DoEvents
        'Create a model and an instance using it
        Model = DGE.Model_CreateEmpty: RE
        Instance = DGE.Instance_Create(Model): RE
        
        'Create a part
        InsertStringToEngine "The part"
        Part = DGE.Model_Part_Create_InSB(Model, -4): RE 'Test bad number of pre allocated triangles
        DGE.Model_Part_SetMinDetailLevel Model, Part, -1: EE 'Test bounds
        DGE.Model_Part_SetMaxDetailLevel Model, Part, 3: EE 'Test bounds
        DGE.Model_Part_SetMinDetailLevel Model, Part, 1: RE
        DGE.Model_Part_SetMaxDetailLevel Model, Part, 1: RE
        DGE.Model_Part_SetTextureOverride Model, Part, -1, 7: EE 'Test texture channel out of bound
        DGE.Model_Part_SetTextureOverride Model, Part, 0, 3: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 1, 7: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 2, 5: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 3, 15: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 4, 0: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 5, -2: EE 'Test override channel out of bound
        DGE.Model_Part_SetTextureOverride Model, Part, 5, 3: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 6, 1: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 7, -1: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 8, 4: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 9, 8: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 10, 6: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 11, -1: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 12, 0: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 13, 16: EE 'Test override channel out of bound
        DGE.Model_Part_SetTextureOverride Model, Part, 13, 5: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 14, 3: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 15, 9: RE
        DGE.Model_Part_SetTextureOverride Model, Part, 16, 5: EE 'Test texture channel out of bound
        
        'Check that the part is named right
        DGE.Model_Part_GetName_OutSB Model, DGE.Model_GetNumberOfParts(Model) - 1: RE
        AssertEqual "Part name", GetStringFromEngine, "The part"
        
        'Insert triangles
        For I = 0 To 4
            Tri = DGE.Model_Part_InsertTriangle(Model, Part): RE
            For Vert = 0 To 2
                DGE.Model_Part_Vertice_SetPos Model, Part, Tri, Vert, Part + 1, Tri + 2, Vert + 3: RE
            Next Vert
        Next I
        
        'Test safety in part duplication by trying to do something impossible
        DGE.Model_CopyAllParts Model, Model: EE
        
        'Copy the model
        ModelCopy = DGE.Model_CreateCopy(Model): RE
        
        'Check that the part is named right
        DGE.Model_Part_GetName_OutSB ModelCopy, DGE.Model_GetNumberOfParts(ModelCopy) - 1: RE
        AssertEqual "Part copy name", GetStringFromEngine, "The part"
        
        'Assert positions
        For Tri = 0 To DGE.Model_Part_GetTriangleCount(ModelCopy, Part) - 1: RE
            For Vert = 0 To 2
                DGE.Model_Part_Vertice_GetPos_OutV3 Model, Part, Tri, Vert: RE
                AssertAlmostEqualVector3 "Vertice position (" & Tri & "," & Vert & ")", GetVector3FromMatrixBuffer, MakeVector3(Part + 1, Tri + 2, Vert + 3), 0.0001
            Next Vert
        Next Tri
        
        'Assert texture override
        AssertAlmostEqualSingle "Texture override 0", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 0)), (3), 0.01: RE
        AssertAlmostEqualSingle "Texture override 1", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 1)), (7), 0.01: RE
        AssertAlmostEqualSingle "Texture override 2", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 2)), (5), 0.01: RE
        AssertAlmostEqualSingle "Texture override 3", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 3)), (15), 0.01: RE
        AssertAlmostEqualSingle "Texture override 4", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 4)), (0), 0.01: RE
        AssertAlmostEqualSingle "Texture override 5", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 5)), (3), 0.01: RE
        AssertAlmostEqualSingle "Texture override 6", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 6)), (1), 0.01: RE
        AssertAlmostEqualSingle "Texture override 7", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 7)), (-1), 0.01: RE
        AssertAlmostEqualSingle "Texture override 8", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 8)), (4), 0.01: RE
        AssertAlmostEqualSingle "Texture override 9", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 9)), (8), 0.01: RE
        AssertAlmostEqualSingle "Texture override 10", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 10)), (6), 0.01: RE
        AssertAlmostEqualSingle "Texture override 11", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 11)), (-1), 0.01: RE
        AssertAlmostEqualSingle "Texture override 12", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 12)), (0), 0.01: RE
        AssertAlmostEqualSingle "Texture override 13", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 13)), (5), 0.01: RE
        AssertAlmostEqualSingle "Texture override 14", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 14)), (3), 0.01: RE
        AssertAlmostEqualSingle "Texture override 15", (DGE.Model_Part_GetTextureOverride(ModelCopy, Part, 15)), (9), 0.01: RE
        
        'Test error messages from deleting the instance twice
        DGE.Instance_Delete Instance: RE
        PrintResult "Delete an instance", DGE.Message_GetCount = 0
        DGE.Instance_Delete Instance 'Trying to delete an already deleted instance should safely catch the error
        PrintResult "Delete the instance again", EE
        If DGE.Message_GetCount > 0 Then
            PrintText "Printing remaining error messages:": RE
        End If
        
        'Test error messages from deleting a model twice
        DGE.Model_Delete Model: RE
        PrintResult "Delete a model", DGE.Message_GetCount = 0
        DGE.Model_Delete Model 'Trying to delete an already deleted instance should safely catch the error
        PrintResult "Delete the model again", EE
        If DGE.Message_GetCount > 0 Then
            PrintText "Printing remaining error messages:": RE
        End If
    DoEvents
        'Test bad references given to Sound_Buffer_Play
        DGE.Sound_Buffer_Play 1, 0, True, False
        PrintResult "Incorrect reference type", EE
        DGE.Sound_Buffer_Play 0, 0, True, False
        PrintResult "Unexpected null reference", EE
        DGE.Sound_Buffer_Play -1, 0, True, False
        PrintResult "Negative reference", EE
        DGE.Sound_Buffer_Play -75345, 0, True, False
        PrintResult "Extreme negative reference", EE
        DGE.Sound_Buffer_Play 82653, 0, True, False
        PrintResult "Extreme out of bound reference", EE
    DoEvents
        PrintText "Completed all regression tests with " & Errors & " errors."
End Sub
