Attribute VB_Name = "EngineShell"

'This module is a simplifying syntax shell for David Piuva's graphics engine.
'By only using simple datatypes in the ActiveX interface, more languages are supported.

'Whenever a new method in the engine have complicated ways to get called, make
'  your own method in you own shell module for easy upgrading.
'Remember to replace frmMain.DGE with whatever your window and engine instance is called.

Option Explicit

'Break and show error messages from the graphics engine
'This should be placed after every call to the engine that can give error messages so that the application will break in debug mode when an error has occured.
'It will continue to break on each point until the error message is deleted by reading it.
'   String buffer methods don't give error messages because they are used to show the message.
'   Matrix buffer methods don't have any preconditions.
Public Sub RE()
    Static Messages As String
    If frmMain.DGE.Message_GetCount > 0 Then
        frmMain.DGE.Message_GetContent_OutSB
        Messages = GetStringFromEngine
        Do While frmMain.DGE.Message_GetCount > 0
            frmMain.DGE.Message_GetContent_OutSB
            Messages = Messages & vbNewLine & vbNewLine & GetStringFromEngine
        Loop
        MsgBox Messages, vbCritical, "Messages from the graphics engine!"
        Debug.Assert False 'Stop debug execution to see where the error occured using the call stack.
    End If
End Sub

Private Function ContainQuestionMark(T As String) As Boolean
    Static I As Integer
    For I = 1 To Len(T)
        If Mid(T, I, 1) = "?" Then
            ContainQuestionMark = True
            Exit Function
        End If
    Next I
    ContainQuestionMark = False
End Function

Public Sub SetRelativeWorkingDirectory(RelativePath As String)
    'The first method has the advantage of handling unicode application paths and the other has the advantage of working when Visual Basic 6 is simulating without an executable.
    'Both properties are not needed at the same time because Visual Basic 6 can't run code from non ansi paths.
    If ContainQuestionMark(App.Path) Then
        'A unicode character was found in the application path.
        'Assume that the game is running on the end user's computer.
        InsertStringToEngine RelativePath: frmMain.DGE.Engine_SetCurrentDirectoryRelativeToApplicationPath_InSB: RE
    Else
        'The application path show no sign of being converted from unicode and the application is either simulated in Visual Basic 6 or run from a folder without unicode characters.
        'We can use the application path given by Visual Basic 6 that works even when we don't run a real executable application.
        InsertStringToEngine App.Path & "\" & RelativePath: frmMain.DGE.Engine_SetCurrentDirectory_InSB: RE
    End If
End Sub

Public Sub InsertStringToEngine(T As String)
    Static I As Long
    frmMain.DGE.SetLengthOfStringBuffer Len(T)
    For I = 1 To Len(T)
        frmMain.DGE.WriteToStringBuffer I, Asc(Mid(T, I, 1))
    Next I
End Sub

Public Function GetStringFromEngine() As String
    Static I As Long
    GetStringFromEngine = ""
    For I = 1 To frmMain.DGE.GetLengthOfStringBuffer
        GetStringFromEngine = GetStringFromEngine & Chr(frmMain.DGE.ReadFromStringBuffer(I))
    Next I
End Function
