VERSION 5.00
Object = "{FE69BD77-3946-4641-8613-6FC7144F2E05}#6.0#0"; "DFPGE6.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   ClientHeight    =   7755
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   10590
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7755
   ScaleWidth      =   10590
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin VB.Timer tmrStart 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   10020
      Top             =   120
   End
   Begin DFPGELib.DFPGE DGE 
      Height          =   7155
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   9915
      Visible         =   0   'False
      _Version        =   393216
      _ExtentX        =   17489
      _ExtentY        =   12621
      _StockProps     =   0
   End
   Begin VB.Label lblLoading 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Loading"
      BeginProperty Font 
         Name            =   "Impact"
         Size            =   21.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   540
      Left            =   120
      TabIndex        =   1
      Top             =   7260
      Width           =   1410
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

'Reference to a camera that we created
Dim Camera_Main As Long

'Reference to the draw durface that we must render to before we see anything.
Dim DrawSurface_Final As Long

'References to light sources
Dim LightSource_Flashlight(0 To 1) As Long

Private Function StartEngine() As Boolean
    StartEngine = DGE.Engine_Initiate: RE
End Function

'Loads a model and it's resources from FileName.
Private Function LoadModel(FileName As String) As Long
    InsertStringToEngine FileName
    LoadModel = DGE.Model_LoadFromFile_InSB: RE
    If LoadModel = -1 Then End
End Function

Private Sub DGE_KeyDown(KeyCode As Integer, Shift As Integer)
    'Exit the application when escape is pressed
    If KeyCode = vbKeyEscape Then End
End Sub

Private Sub Form_Load()
    If StartEngine Then
        'Set the default folder so that relative paths can be used
        SetRelativeWorkingDirectory "..\CommonMediaFiles"
        
        'We start a timer to let this routine exit before we render anything
        'The graphical user interface will not be drawn until Form_Load has finished and therefor the main loop can't be placed in Form_Load.
        tmrStart.Enabled = True
    End If
End Sub

Private Sub LoadThings()
    Static I As Long
    'Load and use our default material shader that will be used when something don't have a shader in the current shader channel
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultMaterialShader": DGE.Shader_UseAsDefaultMaterialShader DGE.Shader_LoadAsMaterial_InSB: RE

    'Load and use our default texture that is used when a texture is missing
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultTexture": DGE.Texture_UseAsDefaultTexture DGE.Texture_Load_InSB: RE
    
    'Create a camera and take the reference number
    Camera_Main = DGE.Camera_Create: RE
    'Perspective
    DGE.Camera_SetVerticalFOV_InDegrees Camera_Main, 60
    'Orthogonal
    'DGE.Camera_SetOrthogonal Camera_Main, True
    'DGE.Camera_SetHalfWidth Camera_Main, 2 * (Screen.Width / Screen.Height)
    'DGE.Camera_SetHalfHeight Camera_Main, 2
    
    'Get the version specific ID to the final draw surface
    DrawSurface_Final = DGE.DrawSurface_GetFinalOutput: RE
    
    'Set the amount of ambient light
    DGE.LightSource_SetAmbientLight 0.05, 0.05, 0.05: RE
    
    'Set the depth atlas resolution
    DGE.LightSource_SetDepthAtlasResolution 2048: RE
    
    'Create spot lights
    'If you haven't chosen a size using LightSource_SetDepthAtlasResolution, the default size will be allocated automatically.
    For I = 0 To 1
        LightSource_Flashlight(I) = DGE.LightSource_Create_Spotlight_RoundAndSoft_Shadowcasting(0, 1, 0, 0, -1, 0, 1, 0, 0, 15, 3, 3, 3, 0.6, 0.6, 0.1, 0, 1): RE
    Next I
    
    'Load and use the room model without keeping the reference number
    DGE.Instance_Create LoadModel("Model_Room"): RE
    
    lblLoading.Visible = False
    DGE.Visible = True
End Sub

Private Sub Form_Resize()
    'Scale the component to cover the screen
    DGE.Width = Screen.Width
    DGE.Height = Screen.Height
    lblLoading.Left = (Screen.Width - lblLoading.Width) / 2
    lblLoading.Top = (Screen.Height - lblLoading.Height) / 2
End Sub

Private Sub tmrStart_Timer()
    tmrStart.Enabled = False
    LoadThings
    Do
        DoStuff
        DoEvents
    Loop
End Sub

Private Sub DoStuff()
    Static I As Long
    Static CameraAngle As Single
    Static TargetHeight As Single
    Static LightAngle(1) As Single
    
    'Place and direct the camera
    CameraAngle = Timer * 0.5
    TargetHeight = Sin(Timer * 0.2) * 2
    DGE.Camera_Place Camera_Main, Sin(CameraAngle) * 5, 0, Cos(CameraAngle) * 5, 0, TargetHeight, 0, 0, 1, 0: RE
    
    'Rotate spotlights
    LightAngle(0) = CameraAngle - 0.2
    LightAngle(1) = CameraAngle + 0.2
    For I = 0 To 1
        DGE.LightSource_SetPos LightSource_Flashlight(I), Sin(LightAngle(I)) * 6, 0, Cos(LightAngle(I)) * 6: RE
        DGE.LightSource_SetDirection LightSource_Flashlight(I), -Sin(LightAngle(I)) * 5, TargetHeight, -Cos(LightAngle(I)) * 5, 0, 1, 0: RE
    Next I
    
    'Clear shadows
    DGE.LightSource_ClearShadows
    
    'Render the scene to the final draw surface that is displayed directly on the component
    'We render channel 0 for visible light
    DGE.Camera_RenderScene Camera_Main, DrawSurface_Final, 0: RE
End Sub
