VERSION 5.00
Object = "{FE69BD77-3946-4641-8613-6FC7144F2E05}#6.0#0"; "DFPGE6.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   ClientHeight    =   8025
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   10695
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   8025
   ScaleWidth      =   10695
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin VB.Timer tmrStart 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   10020
      Top             =   120
   End
   Begin DFPGELib.DFPGE DGE 
      Height          =   7155
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   9915
      Visible         =   0   'False
      _Version        =   393216
      _ExtentX        =   17489
      _ExtentY        =   12621
      _StockProps     =   0
   End
   Begin VB.Label lblLoading 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Loading"
      BeginProperty Font 
         Name            =   "Impact"
         Size            =   21.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   540
      Left            =   120
      TabIndex        =   1
      Top             =   7260
      Width           =   1410
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

'You may change these constants
Const ForestSize As Single = 30
Const NumberOfGrassInstances As Single = ForestSize * ForestSize * 2
Const NumberOfTreeInstances As Single = ForestSize * ForestSize * 0.5
Const ShadowResolution As Single = 1024 * 2
Const BloomSize As Single = 3.5

'Data for the camera
Dim Camera_Main As Long
Dim Longitude As Single
Dim Lattitude As Single
Dim CameraDistance As Single
Dim LastX As Single
Dim LastY As Single

'References to draw durfaces
Dim DrawSurface_D As Long 'Default draw surface
Dim DrawSurface_B As Long 'Blur draw surface with a lower resolution
Dim DrawSurface_Final As Long 'Final draw surface for showing the final image

'Model references
Dim Model_Grass As Long
Dim Model_Tree As Long

Private Function StartEngine() As Boolean
    StartEngine = DGE.Engine_Initiate: RE
End Function

Private Sub DGE_KeyDown(KeyCode As Integer, Shift As Integer)
    'Exit the application when escape is pressed
    If KeyCode = vbKeyEscape Then End
End Sub

Private Sub DGE_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    'Remember where the mouse move started
    LastX = X
    LastY = Y
End Sub

Private Sub DGE_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    'Move the camera
    If Button = 1 Then
        Longitude = Longitude - ((X - LastX) * 0.001)
        Lattitude = Clamp(0, Lattitude + ((Y - LastY) * 0.001), 1.5)
    ElseIf Button = 2 Then
        CameraDistance = Clamp(0.1, CameraDistance - ((Y - LastY) * 0.002), 20)
    ElseIf Button = 3 Then
        Longitude = Longitude - ((X - LastX) * 0.001)
        CameraDistance = Clamp(0.1, CameraDistance - ((Y - LastY) * 0.002), 20)
    End If
    LastX = X
    LastY = Y
End Sub

Private Sub Form_Load()
    If StartEngine Then
        'Set the default folder so that relative paths can be used
        SetRelativeWorkingDirectory "..\CommonMediaFiles"
        
        'We start a timer to let this routine exit before we render anything
        'The graphical user interface will not be drawn until Form_Load has finished and therefor the main loop can't be placed in Form_Load
        tmrStart.Enabled = True
    End If
End Sub

Private Sub LoadThings()
    Static I As Long
    Static NewInstance As Long
    
    'Load and use our default material shader that will be used when something don't have a shader in the current shader channel
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultMaterialShader": DGE.Shader_UseAsDefaultMaterialShader DGE.Shader_LoadAsMaterial_InSB: RE

    'Load and use our default texture that is used when a texture is missing
    'We give the returned reference directly as an argument to the next method
    InsertStringToEngine "DefaultTexture": DGE.Texture_UseAsDefaultTexture DGE.Texture_Load_InSB: RE
    
    'Create a camera and take the reference number
    Camera_Main = DGE.Camera_Create: RE
    DGE.Camera_SetVerticalFOV_InDegrees Camera_Main, 60
    Longitude = 0.4
    Lattitude = 0
    CameraDistance = 8
    
    'Get the version specific ID to the final draw surface
    DrawSurface_Final = DGE.DrawSurface_GetFinalOutput: RE
    
    'Set the background color that the fog will also have.
    DGE.Enviroment_SetBackgroundColor 0.6, 0.7, 0.8, 1
    
    'Set the amount of ambient light
    DGE.LightSource_SetAmbientLight 0, 0, 0: RE
    
    'Set the depth atlas resolution
    DGE.LightSource_SetDepthAtlasResolution ShadowResolution: RE
    
    'Create sun light
    'If you haven't chosen a size using LightSource_SetDepthAtlasResolution, the default size will be allocated automatically
    DGE.LightSource_Create_Sun_Shadowcasting_SingleLayer 0, 0, 0, 0, -1, -1, 0, 1, 0, -1000, 1000, 3, 3, 3, ForestSize * 1.3, ForestSize, 0, 0, 1, 0.01: RE
    
    'Load and use the ground model
    DGE.Instance_Create LoadModel("Model_FlatGround"): RE
    
    'Load and place items
    Static Angle As Single
    Static Size As Single
    Static Intensity As Single
    
    'Load the grass model
    Model_Grass = LoadModel("Model_AnimatedGrass")
    For I = 1 To NumberOfGrassInstances
        'Create the instance
        NewInstance = DGE.Instance_Create(Model_Grass): RE
        
        'Don't cast shadows
        DGE.Instance_SetVisibility NewInstance, 1, False
        
        'Set the position
        DGE.Instance_SetPosition NewInstance, (Rnd * ForestSize * 2) - ForestSize, 0, (Rnd * ForestSize * 2) - ForestSize
        
        'Give a random direction
        Angle = Rnd * 6.28318530717959
        DGE.Instance_SetXAxis NewInstance, Cos(Angle), 0, Sin(Angle)
        DGE.Instance_SetZAxis NewInstance, -Sin(Angle), 0, Cos(Angle)
        
        'Scale to a random height and make the grass less straight
        DGE.Instance_SetYAxis NewInstance, (Rnd * 0.6) - 0.3, (Rnd * 0.6) + 0.7, (Rnd * 0.6) - 0.3
        
        'Make random brightness
        Intensity = (Rnd * 0.8) + 0.6
        DGE.Instance_SetColor NewInstance, Intensity, Intensity, Intensity, 1
    Next I
    
    'Load the tree model
    Model_Tree = LoadModel("Model_AnimatedTree")
    For I = 1 To NumberOfTreeInstances
        'Create the instance
        NewInstance = DGE.Instance_Create(Model_Tree): RE
        
        'Set the position
        DGE.Instance_SetPosition NewInstance, (Rnd * ForestSize * 2) - ForestSize, 0, (Rnd * ForestSize * 2) - ForestSize
        
        'Give a random direction and scale
        Angle = Rnd * 6.28318530717959
        Size = (Rnd * 1.2) + 0.3
        DGE.Instance_SetXAxis NewInstance, Cos(Angle) * Size, 0, Sin(Angle) * Size
        DGE.Instance_SetYAxis NewInstance, 0, Size, 0
        DGE.Instance_SetZAxis NewInstance, -Sin(Angle) * Size, 0, Cos(Angle) * Size
    Next I
    
    'Create some draw surfaces for the bloom effect
    DrawSurface_D = DGE.DrawSurface_CreateAutoSized(1, 1, 0, 0, 1, True): RE 'Allow rendering a 3D scene to it but not using soft particles and allow rendering from and to itself.
    DrawSurface_B = DGE.DrawSurface_CreateAutoSized(0.25, 0.25, 0, 0, 0, True): RE 'Allow rendering from and to itself.
    
    'Load the post effects
    PostEffects_Init
    
    lblLoading.Visible = False
    DGE.Visible = True
End Sub

Private Sub Form_Resize()
    'Scale the component to cover the screen
    DGE.Width = Screen.Width
    DGE.Height = Screen.Height
    lblLoading.Left = (Screen.Width - lblLoading.Width) / 2
    lblLoading.Top = (Screen.Height - lblLoading.Height) / 2
End Sub

Private Sub tmrStart_Timer()
    tmrStart.Enabled = False
    LoadThings
    Do
        DoStuff
        DoEvents
    Loop
End Sub

Private Sub DoStuff()
    'Set the global time for shader animation
    'This is the only line of code needed to use vertex animated vegetation because the rest is done in the HLSL shaders
    DGE.Shader_SetGlobalTime Timer
    
    'Place camera
    'Longitude = Timer
    DGE.Camera_Place Camera_Main, -Sin(Longitude) * Cos(Lattitude) * CameraDistance, 2 + (Sin(Lattitude) * CameraDistance), Cos(Longitude) * Cos(Lattitude) * CameraDistance, 0, 2, 0, 0, 1, 0: RE
    
    'Clear shadows
    DGE.LightSource_ClearShadows
    
    'Render with post effects
        'Render the scene with shader channel 0 to surface D
            DGE.Camera_RenderScene Camera_Main, DrawSurface_D, 0: RE
        'Apply depth based blur
            'Get the depth
            PostEffects_GetBlurRadiusFromDepthAsGrayscale DrawSurface_D, DrawSurface_B, CameraDistance, 2.5
            'Apply blur to B
            PostEffects_ApplyDiffuseBlur DrawSurface_B, 1
            'Apply depth based blur to D using B
            PostEffects_ApplyAdaptiveDiffuseBlur DrawSurface_D, DrawSurface_B, 0.4
        'Apply a bloom effect and show the result
            'PostEffects_DownSample from D to B
            PostEffects_DownSample DrawSurface_D, DrawSurface_B
            'Apply blur to B
            PostEffects_ApplyDiffuseBlur DrawSurface_B, 0.4 * BloomSize
            'Lower the gamma for B
            PostEffects_RaiseToPower DrawSurface_B, 1.3
            'Show a mix of D and B
            PostEffects_Mix2Surfaces DrawSurface_D, 0.35, DrawSurface_B, 0.9, DrawSurface_Final
    
End Sub
