Attribute VB_Name = "DragState"

Option Explicit

Public Enum DragStateEnum
    None
    Offset
    Rectangle
    InfinitePlane_2D
    Box_Base
    Box_SetHeight
End Enum
Private CurrentDragState As DragStateEnum
Public DragBase As FractionBox
Public DragBox As FractionBox
Public SelectionTranslation As FractionPoint 'Move
' TODO: Fraction transforms
Public SelectionSystem As Matrix3 'Rotate and scale
Public PreviewPlane As FractionPlane

Public Sub DragState_Init()
    SelectionTranslation = MakeFractionPoint_Zero
    SelectionSystem = MakeUnitMatrix3
End Sub

Public Function DragState_Get() As DragStateEnum
    DragState_Get = CurrentDragState
End Function

Public Sub DragState_Initiate(NewDragState As DragStateEnum)
    If CurrentDragState = DragStateEnum.None Then
        DragState_Set NewDragState
    End If
End Sub

Public Sub DragState_Set(NewDragState As DragStateEnum)
    CurrentDragState = NewDragState
    Select Case NewDragState
    Case DragStateEnum.Box_SetHeight
        LockMouse
    Case Else
        UnlockMouse
    End Select
    SelectionTranslation = MakeFractionPoint_Zero
    SelectionSystem = MakeUnitMatrix3
End Sub
