Attribute VB_Name = "GUI"

Option Explicit

Public Type Rect
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Public Function MakeRect(Left As Long, Top As Long, Right As Long, Bottom As Long) As Rect
    MakeRect.Left = Left
    MakeRect.Top = Top
    MakeRect.Right = Right
    MakeRect.Bottom = Bottom
End Function

Public Function GetRectFromWindow(Window As Object) As Rect
    GetRectFromWindow = MakeRect(0, 0, Window.ScaleWidth, Window.ScaleHeight)
End Function

Public Function ApplyBorder(Location As Rect, Border As Long) As Rect
    ApplyBorder.Left = Location.Left + Border
    ApplyBorder.Top = Location.Top + Border
    ApplyBorder.Right = Location.Right - Border
    ApplyBorder.Bottom = Location.Bottom - Border
End Function

Public Function SetLeft(Location As Rect, NewLeft As Long) As Rect
    SetLeft = Location
    SetLeft.Left = NewLeft
End Function

Public Function SetRight(Location As Rect, NewRight As Long) As Rect
    SetRight = Location
    SetRight.Right = NewRight
End Function

Public Sub Place(Component As Object, Location As Rect)
    Component.Move Location.Left, Location.Top, Max_Double(Screen.TwipsPerPixelX, Location.Right - Location.Left), Max_Double(Screen.TwipsPerPixelY, Location.Bottom - Location.Top)
End Sub

Public Function ShiftHasShift(Shift As Integer) As Boolean
    ShiftHasShift = Shift And 1
End Function

Public Function ShiftHasCtrl(Shift As Integer) As Boolean
    ShiftHasCtrl = Shift And 2
End Function

Public Function ShiftHasAlt(Shift As Integer) As Boolean
    ShiftHasAlt = Shift And 4
End Function
