Attribute VB_Name = "Geometry_Methods"

Option Explicit

' TODO: Temporarily create other sets generated from the brush set to generate graphics and physics.
'   * Graphics should have a brush set where every surface touching an edge should be split into fragments so that the hidden can be deleted and the visible can be merged.
'   * Physics should allow cells to overlap and can remove cells that are completely surrounded by other cells.

Public BrushSet As Geometry_Set

Private Model_Geometry As Long
Private Model_Grid As Long
Private Instance_Geometry As Long
Private Instance_Grid As Long

Public Sub Geometry_Init()
    Set BrushSet = New Geometry_Set
    BrushSet.Init True
    Model_Geometry = frmMain.DGE.Model_CreateEmpty
    Model_Grid = frmMain.DGE.Model_CreateEmpty
    Instance_Geometry = frmMain.DGE.Instance_Create(Model_Geometry): RE
    Instance_Grid = frmMain.DGE.Instance_Create(Model_Grid): RE
    SetVisibilityForAllChannels Instance_Grid, 0
End Sub

'Call manually before rendering grid using camera
Public Sub Geometry_NeedGrid()
    BrushSet.NeedGraphics Model_Grid, True
End Sub

'Call manually before rendering geometry using camera
Public Sub Geometry_NeedGeometry()
    BrushSet.NeedGraphics Model_Geometry, False
End Sub

Public Sub Geometry_BuildFinal()
    BrushSet.NeedGraphics Model_Grid, True
    BrushSet.NeedGraphics Model_Geometry, False
End Sub

Public Function Geometry_GetGeometryModel() As Long
    BrushSet.NeedGraphics Model_Geometry, False ' TODO: Make a special setting to force extra optimizations
    BrushSet.NeedPhysics Model_Geometry
    Geometry_GetGeometryModel = Model_Geometry
End Function

Public Function Geometry_GetGridInstance() As Long
    BrushSet.NeedGraphics Model_Grid, True
    Geometry_GetGridInstance = Instance_Grid
End Function

Public Sub RegressionTest_Geometry()
    'Cutting
    Dim P As FractionPlane
    Dim A As Cell
    Dim B As Cell
    Const Material_Wood As Long = 26
    A = MakeCell_Box(MakeFractionBox_Uniform(2), MakeCellSettings(Material_Wood, True, False), False)
    Debug.Assert Abs(A.Bound.Max.X - (2)) < Geometry_WeldTolerance
    Debug.Assert Abs(A.Bound.Min.X - (-2)) < Geometry_WeldTolerance
    Debug.Assert Abs(A.Bound.Max.Y - (2)) < Geometry_WeldTolerance
    Debug.Assert Abs(A.Bound.Min.Y - (-2)) < Geometry_WeldTolerance
    Debug.Assert Abs(A.Bound.Max.Z - (2)) < Geometry_WeldTolerance
    Debug.Assert Abs(A.Bound.Min.Z - (-2)) < Geometry_WeldTolerance
    Debug.Assert A.Settings.MaterialIndex = Material_Wood
    Debug.Assert A.Settings.Selected = True
    Debug.Assert A.Settings.IsBroken = False
    P = MakeFractionPlane_Elements(0, 1, 0, 1, 0, 1, 1, 0, 0) 'A plane with its surface point to the right will have an infinite volume to the left
    B = GetFragmentOfCell(A, P)
    Debug.Assert Abs(B.Bound.Max.X - (2)) < Geometry_WeldTolerance
    Debug.Assert Abs(B.Bound.Min.X - (0)) < Geometry_WeldTolerance 'Cutting from the left facing right will only leave matter to the right side
    Debug.Assert Abs(B.Bound.Max.Y - (2)) < Geometry_WeldTolerance
    Debug.Assert Abs(B.Bound.Min.Y - (-2)) < Geometry_WeldTolerance
    Debug.Assert Abs(B.Bound.Max.Z - (2)) < Geometry_WeldTolerance
    Debug.Assert Abs(B.Bound.Min.Z - (-2)) < Geometry_WeldTolerance
    Debug.Assert B.Settings.MaterialIndex = Material_Wood
    Debug.Assert B.Settings.Selected = True
    Debug.Assert B.Settings.IsBroken = False
End Sub
