Attribute VB_Name = "Graphics"

Option Explicit

'Draw shaders
Public DrawShader_Circle As Long
Public DrawShader_Circle_EllipseCut As Long
Public DrawShader_Color As Long
Public DrawShader_ThinLine As Long
Public DrawShader_1Tex As Long
Public DrawShader_Clamped_1Tex As Long
Public DrawShader_Clamped_NN_1Tex As Long
Public DrawShader_Stripes As Long
Public DrawShader_ThinLine_Dotted As Long
Public DrawShader_FullQuad_Border_1Tex As Long
Public DrawShader_FullQuad_Add_Border_2Tex As Long

'Material shaders
Public MaterialShader_WireFrameNonSelection As Long
Public MaterialShader_WireFrameSelection As Long
Public MaterialShader_WireFrame3D As Long
Public MaterialShader_Position As Long

'Textures
Public Texture_2DGrid_8 As Long
Public Texture_2DGrid_16 As Long
Public Texture_2DGrid_32 As Long
Public Texture_2DGrid_64 As Long
Public Texture_2DGrid_128 As Long
Public FontAtlas_LucidaConsole_10 As Long
    Public FontTileWidth As Long
    Public FontTileHeight As Long
Public Texture_Tab As Long
    Public TabTexWidth As Long
Public Texture_ButtonUp As Long
Public Texture_ButtonDown As Long
    Public ButtonTexWidth As Long
    Public ButtonTexHeight As Long
    
Public Sub Graphics_Init()
    'Load draw shaders
    DrawShader_Circle = LoadDrawShader("Editor_D_Circle_Filled")
    DrawShader_Circle_EllipseCut = LoadDrawShader("Editor_D_Circle_EllipseCut")
    DrawShader_Color = LoadDrawShader("Editor_D_FullQuad_Color")
    DrawShader_ThinLine = LoadDrawShader("Editor_D_ThinLine")
    DrawShader_1Tex = LoadDrawShader("Editor_D_FullQuad_1Tex")
    DrawShader_Clamped_1Tex = LoadDrawShader("Editor_D_FullQuad_Clamped_1Tex")
    DrawShader_Clamped_NN_1Tex = LoadDrawShader("Editor_D_FullQuad_Clamped_NN_1Tex")
    DrawShader_Stripes = LoadDrawShader("Editor_D_Stripes")
    DrawShader_ThinLine_Dotted = LoadDrawShader("Editor_D_ThinLine_Dotted")
    DrawShader_FullQuad_Border_1Tex = LoadDrawShader("Editor_D_FullQuad_Border_1Tex")
    DrawShader_FullQuad_Add_Border_2Tex = LoadDrawShader("Editor_D_FullQuad_Add_Border_2Tex")
    
    'Load material shaders
    frmMain.DGE.Shader_UseAsDefaultMaterialShader LoadMaterialShader("Editor_DefaultMaterialShader")
    MaterialShader_WireFrameNonSelection = LoadMaterialShader("Editor_M_WireNonSelection")
    MaterialShader_WireFrameSelection = LoadMaterialShader("Editor_M_WireSelection")
    MaterialShader_WireFrame3D = LoadMaterialShader("Editor_M_Wire3D")
    MaterialShader_Position = LoadMaterialShader("Editor_M_Position")
    
    'Load textures
    frmMain.DGE.Texture_UseAsDefaultTexture LoadTexture("Editor_DefaultTexture"): RE
    Texture_2DGrid_8 = LoadTexture("Editor_2DGrid_8")
    Texture_2DGrid_16 = LoadTexture("Editor_2DGrid_16")
    Texture_2DGrid_32 = LoadTexture("Editor_2DGrid_32")
    Texture_2DGrid_64 = LoadTexture("Editor_2DGrid_64")
    Texture_2DGrid_128 = LoadTexture("Editor_2DGrid_128")
    FontAtlas_LucidaConsole_10 = LoadTexture("Editor_FontAtlas_LucidaConsole_10")
        FontTileWidth = frmMain.DGE.Texture_GetWidth(FontAtlas_LucidaConsole_10) / 16: RE
        FontTileHeight = frmMain.DGE.Texture_GetHeight(FontAtlas_LucidaConsole_10) / 16: RE
    Texture_Tab = LoadTexture("Editor_Tab")
        TabTexWidth = frmMain.DGE.Texture_GetWidth(Texture_Tab): RE
    Texture_ButtonDown = LoadTexture("Editor_ButtonDown")
    Texture_ButtonUp = LoadTexture("Editor_ButtonUp")
        ButtonTexWidth = frmMain.DGE.Texture_GetWidth(Texture_ButtonUp): RE
        ButtonTexHeight = frmMain.DGE.Texture_GetHeight(Texture_ButtonUp): RE
End Sub
