
// Additive blending of 2 textures.
// The color is only used where UV1 is outside of 0 to 1 on tex_0.
// The color's alpha multiplies the second texture.

float4 PS( VS_to_PS input) : SV_Target {
	// Add tex_0 sampled using UV1 with tex_1 sampled using UV2
	float4 FinalColor = tex_0.Sample( samLinear, UV1 );
	
	if (UV1.x < 0 || UV1.x > 1 || UV1.y < 0 || UV1.y > 1) {
		// Use the color outside of the border
		FinalColor = lerp(FinalColor,Color,0.8f);
	}
	
	return float4(FinalColor + (tex_1.Sample( samLinear, UV2 ) * Color.a).rgb,1.0f);
}
