
// The color is only used where UV1 is outside of 0 to 1.

float4 PS( VS_to_PS input) : SV_Target {
	// tex_0 sampled using UV1
	float4 FinalColor = tex_0.Sample( samLinear, UV1 );
	
	if (UV1.x < 0 || UV1.x > 1 || UV1.y < 0 || UV1.y > 1) {
		// Use the color outside of the border
		FinalColor = lerp(FinalColor,Color,0.8f);
	}
	return float4(FinalColor.rgb,1.0f);
}
