
// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
	float4 Tex : TEXCOORD0;
	float4 Color : COLOR;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	// Convert vertice positions from object space to world space
	output.Pos = mul( input.Pos, ObjectToWorld );
	// Convert vertice positions from world space to camera space
	output.Pos = mul( output.Pos, WorldToCamera );
	// Convert vertice positions from camera space to 2D projection
	output.Pos = mul( output.Pos, CameraToImage );
	
	// Give the texture coordinates to the pixel shader
	output.Tex = input.Tex * Arg[0].x; //Scale texture coordinated according to the grid size
	
	// Give the color to the pixel shader
	output.Color = input.Color * InstanceColor;
	
	return output;
}

//tex_0 is the diffuse texture

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	// Final color = Diffuse * VertexColor * InstanceColor
	float4 finalColor = tex_0.Sample( samConstant, input.Tex.xy ) * input.Color;
	
	// Don't draw pixels with diffuse alpha * vertex alpha less than 0.5
	clip(finalColor.w - 0.5f);
	
	return finalColor;
}
