
// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
	float4 Color : COLOR;
	float3 Normal_WorldSpace : NORMAL;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	// Convert vertice positions from object space to 2D projection
	output.Pos = mul(mul(lerp(input.Pos, mul(input.Pos, ObjectToWorld), input.Selected), WorldToCamera), CameraToImage);
	
	// Transform normals to world space
	output.Normal_WorldSpace = mul(input.Normal,(float3x3)ObjectToWorld);
	
	output.Color.rgb = lerp(float3(1.0f, 1.0f, 1.0f), float3(0.0f, 0.0f, 1.0f), input.Selected);
	output.Color.a = input.Color.b;
	
	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	return float4(input.Color.rgb * saturate(input.Color.a), InstanceColor.a);
}
