Attribute VB_Name = "LineMath"

Option Explicit

Public Type Line2
    StartPoint As Vector2
    EndPoint As Vector2
End Type

Public Type Line3
    StartPoint As Vector3
    EndPoint As Vector3
End Type

'Invariant: |Direction| = 1
Public Type Beam3
    StartPoint As Vector3
    Direction As Vector3
End Type

Public Function MakeLine2(StartPoint As Vector2, EndPoint As Vector2) As Line2
    MakeLine2.StartPoint = StartPoint
    MakeLine2.EndPoint = EndPoint
End Function

Public Function MakeLine3(StartPoint As Vector3, EndPoint As Vector3) As Line3
    MakeLine3.StartPoint = StartPoint
    MakeLine3.EndPoint = EndPoint
End Function

Public Function MakeBeam3(StartPoint As Vector3, Direction As Vector3) As Beam3
    MakeBeam3.StartPoint = StartPoint
    MakeBeam3.Direction = NormalVector3(Direction)
End Function

Public Function MidpointLine2(L As Line2) As Vector2
    MidpointLine2 = MiddleVector2(L.StartPoint, L.EndPoint)
End Function

Public Function MidpointLine3(L As Line3) As Vector3
    MidpointLine3 = MiddleVector3(L.StartPoint, L.EndPoint)
End Function

Public Function Line2Direction(L As Line2) As Vector2
    Line2Direction = NormalVector2(ToVector2(L.StartPoint, L.EndPoint))
End Function

Public Function Line3Direction(L As Line3) As Vector3
    Line3Direction = NormalVector3(ToVector3(L.StartPoint, L.EndPoint))
End Function

Public Function LineFromBeam(Beam As Beam3, Length As Double) As Line3
    LineFromBeam = MakeLine3(Beam.StartPoint, AddVector3(Beam.StartPoint, MulVector3(Beam.Direction, Length)))
End Function

