Attribute VB_Name = "Mouse"
Option Explicit

Dim Lock_X As Long
Dim Lock_Y As Long
Dim Last_X As Long
Dim Last_Y As Long
Public MouseIsLocked As Boolean
Dim MouseOffset As Vector2
Dim MoveIndex As Long
Const MovesPerLock As Long = 3 '2 or less would never apply the offset

Public Function LockMouse()
    MouseIsLocked = True
    Lock_X = frmMain.DGE.Windows_GetCursorPos_X
    Lock_Y = frmMain.DGE.Windows_GetCursorPos_Y
    Last_X = Lock_X
    Last_Y = Lock_Y
    MoveIndex = 0
    MouseOffset = MakeVector2(0, 0)
End Function

Public Function UnlockMouse()
    MouseIsLocked = False
End Function

Public Function Mouse_GetOffsetSinceLock() As Vector2 ' Use to get height for boxes
    If MouseIsLocked Then
        If KeyDown_Truth(vbKeyEscape) Then
            UnlockMouse
            Mouse_GetOffsetSinceLock = MakeVector2(0, 0)
            Exit Function
        End If
        Dim New_X As Long
        Dim New_Y As Long
        MoveIndex = (MoveIndex + 1) Mod MovesPerLock
        New_X = frmMain.DGE.Windows_GetCursorPos_X
        New_Y = frmMain.DGE.Windows_GetCursorPos_Y
        If MoveIndex = MovesPerLock - 1 Then
            'Lock after a while
            frmMain.DGE.Windows_SetCursorPos Lock_X, Lock_Y
        ElseIf MoveIndex > 0 Then
            'Not our own mouse move
            MouseOffset.X = MouseOffset.X + (New_X - Last_X)
            MouseOffset.Y = MouseOffset.Y + (New_Y - Last_Y)
        End If
        Mouse_GetOffsetSinceLock = MouseOffset
        Last_X = New_X
        Last_Y = New_Y
    Else
        Mouse_GetOffsetSinceLock = MakeVector2(0, 0)
    End If
End Function
