Attribute VB_Name = "PolarMath"

Option Explicit

Public Type Polar
    Longitude As Double 'In radians
    Lattitude As Double 'In radians
End Type

Public Function MakePolar(Longitude As Double, Lattitude As Double) As Polar
    MakePolar.Longitude = Longitude
    MakePolar.Lattitude = Lattitude
End Function

'The result is normalized and orthogonal so that it's transpose equals it's inverse.
Public Function Polar_GetAxisSystem(P As Polar) As Matrix3
    'Right
    Polar_GetAxisSystem.XAxis.X = Cos(P.Longitude)
    Polar_GetAxisSystem.XAxis.Y = 0
    Polar_GetAxisSystem.XAxis.Z = -Sin(P.Longitude)
    'Up
    Polar_GetAxisSystem.YAxis.X = Sin(P.Longitude) * -Sin(P.Lattitude)
    Polar_GetAxisSystem.YAxis.Y = Cos(P.Lattitude)
    Polar_GetAxisSystem.YAxis.Z = Cos(P.Longitude) * -Sin(P.Lattitude)
    'Forward
    Polar_GetAxisSystem.ZAxis.X = Sin(P.Longitude) * Cos(P.Lattitude)
    Polar_GetAxisSystem.ZAxis.Y = Sin(P.Lattitude)
    Polar_GetAxisSystem.ZAxis.Z = Cos(P.Longitude) * Cos(P.Lattitude)
End Function
