Attribute VB_Name = "Tools"

Option Explicit

Public Enum ToolEnum
    None
    SetDrawTarget
    CreateBox
    SelectCells
    Move
    Split
    RemovePlane
End Enum
Private CurrentTool As ToolEnum
Private RoundToGrid As Boolean

'Settings
Dim GridDenominator As Long

Public Function Tools_Init()
    GridDenominator = 1
End Function

Public Function Tools_GetCurrentTool() As ToolEnum
    Tools_GetCurrentTool = CurrentTool
End Function

Public Function Tools_IsRounded() As Boolean
    Tools_IsRounded = RoundToGrid
End Function

Public Sub Tools_SetCurrentTool(NewTool As ToolEnum)
    'Change tool
    CurrentTool = NewTool
    'Default settings
    RoundToGrid = True
    'Custom settings
    Select Case CurrentTool
    Case None, ToolEnum.SelectCells
        RoundToGrid = False
    End Select
End Sub

Public Function Tools_RoundToGrid(V As Vector3) As FractionPoint
    If RoundToGrid Then
        Tools_RoundToGrid.X = MakeFraction(Int((V.X * Tools_GetGridDenominator) + 0.5), Tools_GetGridDenominator)
        Tools_RoundToGrid.Y = MakeFraction(Int((V.Y * Tools_GetGridDenominator) + 0.5), Tools_GetGridDenominator)
        Tools_RoundToGrid.Z = MakeFraction(Int((V.Z * Tools_GetGridDenominator) + 0.5), Tools_GetGridDenominator)
    Else
        Tools_RoundToGrid.X = MakeFraction(Int((V.X * 512) + 0.5), 512)
        Tools_RoundToGrid.Y = MakeFraction(Int((V.Y * 512) + 0.5), 512)
        Tools_RoundToGrid.Z = MakeFraction(Int((V.Z * 512) + 0.5), 512)
    End If
End Function

Public Sub Tools_SetGridDenominator(ByVal Denominator As Long)
    GridDenominator = Denominator
End Sub

Public Function Tools_GetGridSize() As Double
    Tools_GetGridSize = 1 / GridDenominator
End Function

Public Function Tools_GetGridDenominator() As Long
    Tools_GetGridDenominator = GridDenominator
End Function

Public Sub Tools_MouseDown_InitialFlat(Shift As Integer, MousePosition As FractionPoint)
    Select Case Tools_GetCurrentTool
    Case ToolEnum.Move
        If ShiftHasShift(Shift) Then
            BrushSet.Duplicate
        End If
        DragState_Initiate DragStateEnum.Offset
    Case ToolEnum.SetDrawTarget
        DrawTarget = MousePosition
    Case ToolEnum.CreateBox
        DragState_Initiate DragStateEnum.Box_Base
    Case ToolEnum.Split
        DragState_Initiate DragStateEnum.InfinitePlane_2D
    Case ToolEnum.SelectCells
        DragState_Initiate DragStateEnum.Rectangle
    End Select
    BrushSet.DoneRecordingHistory
End Sub

Public Sub Tools_MouseDown_InitialPerspective(Shift As Integer, Beam As Beam3)
    Select Case Tools_GetCurrentTool
    Case ToolEnum.SelectCells
        If ShiftHasCtrl(Shift) And Not ShiftHasAlt(Shift) Then
            'Include
            BrushSet.SelectCell Beam, True
        ElseIf ShiftHasAlt(Shift) And Not ShiftHasCtrl(Shift) Then
            'Exclude
            BrushSet.SelectCell Beam, False
        Else
            'Select one
            BrushSet.DeselectAll
            BrushSet.SelectCell Beam, True
        End If
    Case ToolEnum.RemovePlane
        BrushSet.RemovePlaneUsingBeam Beam
    End Select
    BrushSet.DoneRecordingHistory
End Sub

Public Sub Tools_CompleteInfinitePlane(Shift As Integer, P As FractionPlane)
    Select Case Tools_GetCurrentTool
    Case ToolEnum.Split
        BrushSet.Split P
    End Select
    BrushSet.DoneRecordingHistory
End Sub

Public Sub Tools_CompleteTransform(System As Matrix3, Translation As FractionPoint)
    Select Case Tools_GetCurrentTool
    Case ToolEnum.Move
        BrushSet.ApplyTranslation Translation
    End Select
    BrushSet.DoneRecordingHistory
End Sub

Public Sub Tools_CompleteBox(Shift As Integer, CompletedBox As FractionBox)
    Select Case Tools_GetCurrentTool
    Case ToolEnum.CreateBox
        If ShiftHasAlt(Shift) Then
            BrushSet.CarveUsingBox CompletedBox, False
        Else
            BrushSet.AddBox CompletedBox, 0, True ' TODO: Select a material
        End If
    End Select
    BrushSet.DoneRecordingHistory
End Sub

Public Sub Tools_CompleteRectangle(Shift As Integer, InfiniteBox As FractionBox)
    Select Case Tools_GetCurrentTool
    Case ToolEnum.SelectCells
        If ShiftHasCtrl(Shift) And Not ShiftHasAlt(Shift) Then
            'Include
            BrushSet.SelectCellsUsingBox ApproximateFractionBox(InfiniteBox), True
        ElseIf ShiftHasAlt(Shift) And Not ShiftHasCtrl(Shift) Then
            'Exclude
            BrushSet.SelectCellsUsingBox ApproximateFractionBox(InfiniteBox), False
        Else
            'Select one
            BrushSet.DeselectAll
            BrushSet.SelectCellsUsingBox ApproximateFractionBox(InfiniteBox), True
        End If
    End Select
End Sub
