VERSION 5.00
Object = "{FE69BD77-3946-4641-8613-6FC7144F2E05}#12.0#0"; "DFPGE12.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00000000&
   Caption         =   "Quarry level editor by David Piuva"
   ClientHeight    =   9780
   ClientLeft      =   60
   ClientTop       =   630
   ClientWidth     =   16470
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   652
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   1098
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer RenderTimer 
      Enabled         =   0   'False
      Interval        =   20
      Left            =   60
      Top             =   60
   End
   Begin VB.Frame frmTools 
      BackColor       =   &H00579AA6&
      BorderStyle     =   0  'None
      Caption         =   "txtInput"
      Height          =   9555
      Left            =   14820
      TabIndex        =   1
      Top             =   0
      Width           =   1515
      Begin VB.OptionButton chTool 
         Caption         =   "Remove plane"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   6
         Left            =   60
         Style           =   1  'Graphical
         TabIndex        =   13
         ToolTipText     =   "Click on a surface to remove it"
         Top             =   2340
         Width           =   1395
      End
      Begin VB.Frame Frame1 
         BackColor       =   &H00579AA6&
         Caption         =   "Grid size"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1635
         Left            =   60
         TabIndex        =   8
         Top             =   2760
         Width           =   1395
         Begin VB.OptionButton optGrid 
            BackColor       =   &H00579AA6&
            Caption         =   "1 / 8"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   3
            Left            =   180
            TabIndex        =   12
            Top             =   1200
            Width           =   855
         End
         Begin VB.OptionButton optGrid 
            BackColor       =   &H00579AA6&
            Caption         =   "1 / 4"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   2
            Left            =   180
            TabIndex        =   11
            Top             =   900
            Width           =   855
         End
         Begin VB.OptionButton optGrid 
            BackColor       =   &H00579AA6&
            Caption         =   "1 / 2"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   1
            Left            =   180
            TabIndex        =   10
            Top             =   600
            Width           =   855
         End
         Begin VB.OptionButton optGrid 
            BackColor       =   &H00579AA6&
            Caption         =   "1"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   0
            Left            =   180
            TabIndex        =   9
            Top             =   300
            Value           =   -1  'True
            Width           =   855
         End
      End
      Begin VB.OptionButton chTool 
         Caption         =   "Split"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   5
         Left            =   60
         Style           =   1  'Graphical
         TabIndex        =   7
         ToolTipText     =   "Split selected cells by drawing a line"
         Top             =   1920
         Width           =   1395
      End
      Begin VB.OptionButton chTool 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   675
         Index           =   4
         Left            =   780
         Picture         =   "frmMain.frx":08CA
         Style           =   1  'Graphical
         TabIndex        =   6
         ToolTipText     =   "Move selected cells (Hold shift to duplicate)"
         Top             =   780
         Width           =   675
      End
      Begin VB.OptionButton chTool 
         Caption         =   "Select cells"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   3
         Left            =   60
         Style           =   1  'Graphical
         TabIndex        =   5
         ToolTipText     =   "Select cells"
         Top             =   1500
         Width           =   1395
      End
      Begin VB.OptionButton chTool 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   675
         Index           =   2
         Left            =   60
         Picture         =   "frmMain.frx":1BCC
         Style           =   1  'Graphical
         TabIndex        =   4
         ToolTipText     =   "Create box (Hold alt to carve)"
         Top             =   780
         Width           =   675
      End
      Begin VB.OptionButton chTool 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   675
         Index           =   1
         Left            =   780
         Picture         =   "frmMain.frx":2ECE
         Style           =   1  'Graphical
         TabIndex        =   3
         ToolTipText     =   "Set draw target"
         Top             =   60
         Width           =   675
      End
      Begin VB.OptionButton chTool 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   675
         Index           =   0
         Left            =   60
         Style           =   1  'Graphical
         TabIndex        =   2
         ToolTipText     =   "Nothing"
         Top             =   60
         Value           =   -1  'True
         Width           =   675
      End
   End
   Begin DFPGELib.DFPGE DGE 
      Height          =   9735
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   14835
      _Version        =   786432
      _ExtentX        =   26167
      _ExtentY        =   17171
      _StockProps     =   0
   End
   Begin VB.Menu mnuFile 
      Caption         =   "File"
      Begin VB.Menu mnuNew 
         Caption         =   "New"
      End
      Begin VB.Menu mnuSaveClipboard 
         Caption         =   "Save to clipboard"
      End
      Begin VB.Menu mnuLoadClipboard 
         Caption         =   "Load from clipboard"
      End
      Begin VB.Menu mnuExportModel 
         Caption         =   "Export to model"
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "Edit"
      Begin VB.Menu mnuUndo 
         Caption         =   "Undo"
         Shortcut        =   ^Z
      End
      Begin VB.Menu mnuRedo 
         Caption         =   "Redo"
         Shortcut        =   ^R
      End
      Begin VB.Menu mnuCopy 
         Caption         =   "Copy to clipboard"
         Shortcut        =   ^C
      End
      Begin VB.Menu mnuPaste 
         Caption         =   "Paste from clipboard"
         Shortcut        =   ^V
      End
   End
   Begin VB.Menu mnuSelect 
      Caption         =   "Select"
      Begin VB.Menu mnuSelectAll 
         Caption         =   "All"
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuSelectNone 
         Caption         =   "None"
         Shortcut        =   ^N
      End
   End
   Begin VB.Menu mnuActions 
      Caption         =   "Actions"
      Begin VB.Menu mnuDelete 
         Caption         =   "Delete selected cells"
         Shortcut        =   +{DEL}
      End
      Begin VB.Menu mnuMirror 
         Caption         =   "Mirror around draw target X"
         Index           =   0
      End
      Begin VB.Menu mnuMirror 
         Caption         =   "Mirror around draw target Y"
         Index           =   1
      End
      Begin VB.Menu mnuMirror 
         Caption         =   "Mirror around draw target Z"
         Index           =   2
      End
      Begin VB.Menu mnuCarve 
         Caption         =   "Carve with selection"
      End
      Begin VB.Menu mnuMerge 
         Caption         =   "Merge selected cells"
         Shortcut        =   ^M
      End
   End
   Begin VB.Menu mnuDebug 
      Caption         =   "Debug"
      Begin VB.Menu mnuValidate 
         Caption         =   "Validate"
      End
      Begin VB.Menu mnuRefresh 
         Caption         =   "Refresh"
      End
   End
   Begin VB.Menu mnuLayout 
      Caption         =   "Layout"
      Index           =   0
      Begin VB.Menu mnuSelectLayout 
         Caption         =   "Single"
         Index           =   0
      End
      Begin VB.Menu mnuSelectLayout 
         Caption         =   "Vertical"
         Index           =   1
      End
      Begin VB.Menu mnuSelectLayout 
         Caption         =   "Horizontal"
         Index           =   2
      End
      Begin VB.Menu mnuSelectLayout 
         Caption         =   "Quad"
         Checked         =   -1  'True
         Index           =   3
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'Bugs/Untested:
'   * DrawTab_Final is covering an offset bug by subtracting 3 from center X.
'   * If two sufraces are overlapping then no shapes are visible in the final geometry.
'       Find a way to detect overlapping geometry.
'   * Moving with the final graphics moves the whole model even when nothing is selected.
'       Should editing be allowed at all in final view or should it just change back to preview?
'       There can be a step that prepares surfaces like the final version but does not waste time on optimizing triangles every time something changed.
'   * Moving around fragmented infinite shapes will eventually start overlapping or vanish.
'       Should moving infinite shapes be allowed or should there be subtracting brushes on the ground that can be moved instead?
'   * Perspective lines are too small at far away and rotating in a weird way because they were made for orthogonal cameras.

'TODO:
'   * Improve the intersection test of cells when carving by getting the intersection of the two cells or something faster like finding the plane separating the two.
'       Without this, additive brushes will fragment everything around them or overlap for no reason.
'   * Clip polygons to reduce the number of pixels to draw and allow looking from inside solid geometry when making tunnels.
'       This must be done at the same time as the brush system.
'           * Each cell is given a setting, add, subtract or detail.
'           * When building physics, just have a temporary set of cells to generate from the persistent set.
'               The list of cells should be placed in a class with optional undo history.
'                   Take advantage of having the history as a dynamic memory allocation to only allocate when needed for the main set.
'           * When building graphics, a dynamic polygon mesh is created without regard to how convex hulls are made.
'               Just make the most efficient way to get graphics without any simplified preview mode since preview will be replaced by a grid of brushes from the main set.
'       Sets:
'           * Main brushes
'               Generating preview wireframe
'               Persistent with loading and saving
'           * Physics
'               Only exists while exporting to a model
'           * Graphics
'               Will use data from both physics and brushes if needed to generate polygons
'               It is good if only the brush set is needed as it speeds up generation while still editing
'               Only using brushes can be good by just treating air as solid and solid as air, removing all hidden surfaces and flipping polygons
'                   This can be good for precision but really requires all hidden surfaces to be removed or there will be a freaking wall comming from nowhere.
'   * Make layers of cells that add, subtract, add, subtract,... and place themselves as details.
'       All preview before having build geometry will be wireframe previews with the old geometry or nothing as the background.
'       A global flag will say if the infinity should start with an infinite box or not.
'           The box can also be cut in half to give an infinite floor at Y = 0.
'       Do it like in most FPS level editors so that the fragmentation of the result will not make the management of cells useless.
'           Details may overlap but generated geometry may not to prevent flickering and holes.
'           Generated geometry can remove detail's triangles by occlusion to prevent them from being generated but not the other way around since details may overlap with each other.
'       There are additive, subtractive and detail cells.
'           Detail cells will not interact with other cells during geometry building and will not be affected by subtractive cells as they are always added last.
'           All cells can be cut into using other cells in case that more control is needed.
'           Moving a window will be easy and walls will look clean while editing.
'               The final edge colors will be replaced by an overlapping wire-frame model of the brushes.
'           Generation of final geometry:
'               For each non-detail cell
'                   If additive then
'                       Carve and add
'                   If subtractive then
'                       Carve
'               For each detail cell
'                   Add
'           Letting a subtracting cell have its own material placed into cuts is optional but doing so will reduce seams and allow more polygons to be merged.
'           Generated polygons must be represented in fraction points while optimizing until it is time to generate the final triangles.
'           There should be no holes from rounding errors visible in the end result by letting each point on a surface subdivide neighboring surfaces to match edge to edge.
'               Each edge of a polygon must correspond to another edge in the opposite direction in a neighboring surface.
'               Polygons that are not visible will still exist until this has been confirmed to assure the user that everything is good.
'       When rendering, use one model for the raw brushes for wireframe, another for carved geometry and another for detail geometry.
'           Multiple sets can make generation more efficient and is a must when hitting an upper limit in triangle count.
'           Physics will have very poor performance if compound shapes have too many child hulls so splitting the level up is good for performance.
'   * It might be possible to use 16-bit integers without loss of precision since all calculations clamp to 16-bits before any operation is performed.
'       Then do the computations in 32-bits and raise an exception or truncate if the result after reducing with GCD does not fit into 16-bit integers.'
'       Alternatively, make functions in the graphics engine for performing very large integer operations using multiples of 32 bit integers.
'           64 or 128 bits in an old language?
'           Approximate division results to floating point values in 32 or 64 bits.
'   Make new tools and actions:
'       * Uniform scaling using a scalar fraction.
'           Usually the 1/2 and 2/1 fractions since the grid works in powers of two to maximize the greatest common denominator.
'       * Rotate selected cells 90 degrees (Hold shift to leave a copy behind)
'           The draw target is not enough information because each view has a different depth axis to rotate around.
'   * Make a way to save level files in folders and get materials from there to select.
'       Add the possibility of having light sources and loaded models later.
'       Most parts will have to be polished in the model editor before it is ready to be reused.
'   * Make the shaders for selection and non-selection into the same shader since only one line differs.
'   * Multi-set
'       * Try to place everything in the geometry module into a class since that will mostly work in VB6 from classes being modules
'           The the pointer to the current set can change and all views change what is seen and edited while the other sets are stored away
'           Then save multiple sets capable of generating different models into the same level file
'               No connections to items or instancing in a world yet
'       * Allow creating infinite volumes that have triangles generated within a level bound
'           Moving will regenerate the shapes according to the bounds
'       * Make a selection of media folder when creating a new level to get the materials from the correct game
'       * The game's folder should also include a file with the meta tags for each storage type so that the editor can show a nice menu with settings
'           From the media folder, a tag layout file is selected to extend the default settings with content in the game specific strings
'               Example:
'                   Global:
'                       Title:String
'                       StartScript:String
'                   Item:
'                       SpawnScript:String
'                       EndScript:String
'                       TeamIndex:0..15 (Stored as string but selected as an integer from the specified range)
'               Not having a tag layout file will fall back on direct text editing of the content like the game will get it
'                   The editor can also ask for a layout file to be created
'       * Make an item type layer
'       * Make an instance layer

'Optimize:
'   * Sort generated triangles based on plane distance from the center to minimize drawn pixels.
'       Planes facing away from the center are drawn first.
'       Planes facing the center are drawn last.
'   * Sort materials with the heaviest shaders last.
'       The faster shaders will execute first and then prevent heavy pixels behind from being calculated.

'Occlusion:
'   * Allow manually adjusting visibility of instances using convex visibility hulls.
'       Only a camera inside the visibility hull may have the static instance drawn.
'       Random rays from bouncing balls without gravity can tell which rooms can be seem from different locations and generate the hulls with approximations.
'       Occlusion must be handled by the game but the editor can suggest different ways to implement it with example code.
'   * Manually placed occlusion planes can hide dynamic bodies when the culling shape is within an occlusion plane frustum projected from the camera.
'       A plane for the occlusion plane itself and a plane intersecting each edge on the polygon and the camera.

'Data structure:
'   Global:
'       Default sky model with default settings
'       Game specific string for custom settings
'       Ocean level/no water
'   Materials:
'       Textures, shaders, projection...
'   Nodes:
'       Game specific string for custom settings
'           Spawn locations, path nodes, game logic...
'   Models:
'       * Stored models
'           Stored as cells generating models and compound collision shapes
'       * Loaded models
'           Stored as filenames
'   Item types:
'       * Stored types
'           Model reference
'           Uniform scale
'           Restitution, friction, mass, local inertia...
'           Game specific string for custom settings
'       * Loaded types
'           Stored as filenames and item names so that one file can contain a set of many items
'       * Composite types
'           Can include multiple moving parts and constraints to the world and itself
'           Useful for doors, elevators and other things
'       Each item type may contain a list of light sources
'           Dynamic items will move connected light sources
'           An item can be told to turn the light on/off from the instance settings to make them unique
'           Some instances might have their light sources flickering or completely broken
'   Item instances:
'       Item type reference
'       Static/Dynamic
'       Position, yaw, pitch, roll (same as world editor)
'       Instance color
'       Game specific string for custom settings

'Worst causes of solved bugs:
'   * A hole filler that was declared as static became an uninitialized variable causing problems only after the first cut.
'   * A correct index was given but the index was relative to the wrong collection when making a partial copy from source to destination.
'   * It looked as if culling failed but it was just an uninitialized transform being applied every render.

'Requirements:
'   * Make it possible to create a level without having to save any file first.
'       There will be some default materials that can be used without having to specify a media folder.
'       When saving to a file, these have to be copied to the destination.
'   * Try to not have any non standard dll/ocx component other than the graphics engine for compatibility with newer versions of Windows.
'   * Use passive rendering by using a flag to tell if something has changed.
'       The user might have minimized the application and does not want to drain the laptop battery when not doing anything.

Option Explicit

Private Sub DGE_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Views_MouseDown Button, Shift, X / Screen.TwipsPerPixelX, Y / Screen.TwipsPerPixelY
End Sub

Private Sub DGE_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Views_MouseMove Button, Shift, X / Screen.TwipsPerPixelX, Y / Screen.TwipsPerPixelY
End Sub

Private Sub DGE_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Views_MouseUp Button, Shift, X / Screen.TwipsPerPixelX, Y / Screen.TwipsPerPixelY
End Sub

Private Sub DGE_KeyDown(KeyCode As Integer, Shift As Integer)
    Views_KeyDown KeyCode, Shift
End Sub
    
Private Sub DGE_KeyUp(KeyCode As Integer, Shift As Integer)
    Views_KeyUp KeyCode, Shift
End Sub

Private Sub Form_Load()
    Randomize Timer
    If DGE.Engine_Initiate Then
        RE
        InsertStringToEngine App.Path & "\Graphics": DGE.Engine_SetCurrentDirectory_InSB: RE
        Tools_Init
        Graphics_Init
        DragState_Init
        Views_Init
        Geometry_Init
        
        'Tests
        RegressionTestStringFunctions
        RegressionTest_Fraction
        RegressionTest_Geometry
        
        RenderTimer.Enabled = True
    Else
        MsgBox "Failed to load engine.", vbCritical, "Error!"
        End
    End If
    RE
End Sub

Private Sub Form_Resize()
    Dim WorkSpace As Rect
    WorkSpace = GetRectFromWindow(Me)
    Const ToolWidth = 100
    Place DGE, SetRight(WorkSpace, WorkSpace.Right - ToolWidth)
    Place frmTools, SetLeft(WorkSpace, WorkSpace.Right - ToolWidth)
    Views_Resize
End Sub

Private Sub SelectTool(Index As Integer)
    chTool(Index).Value = True
    Tools_SetCurrentTool (Index)
End Sub

Private Sub mnuCarve_Click()
    BrushSet.CarveUsingSelection
End Sub

Private Sub mnuCopy_Click()
    Clipboard.Clear
    Clipboard.SetText BrushSet.SerializeSet("", True)
End Sub

Private Sub mnuMerge_Click()
    BrushSet.MergeSelected
End Sub

Private Sub mnuMirror_Click(Index As Integer)
    BrushSet.MirrorSelected Index
End Sub

Private Sub mnuNew_Click()
    BrushSet.Reset
End Sub

Private Sub mnuPaste_Click()
    BrushSet.DeselectAll
    BrushSet.ParseSet Clipboard.GetText(), True, True
End Sub

Private Sub mnuRefresh_Click()
    BrushSet.Refresh
End Sub

Private Sub mnuSaveClipboard_Click()
    Clipboard.Clear
    Clipboard.SetText BrushSet.SerializeSet("", False)
End Sub

Private Sub mnuLoadClipboard_Click()
    BrushSet.Reset
    BrushSet.ParseSet Clipboard.GetText(), False, False
End Sub

Private Sub mnuDelete_Click()
    BrushSet.DeleteSelected
    BrushSet.DoneRecordingHistory
End Sub

Private Sub mnuExportModel_Click()
    SaveModelToFile "OutputWorld.dmf", Geometry_GetGeometryModel
End Sub

Private Sub mnuRedo_Click()
    BrushSet.Redo
End Sub

Private Sub mnuSelectAll_Click()
    BrushSet.SelectAll
End Sub

Private Sub mnuSelectNone_Click()
    BrushSet.DeselectAll
End Sub

Private Sub SelectLayout(Index As Integer)
    Dim I As Integer
    For I = 0 To mnuSelectLayout.Count - 1
        mnuSelectLayout(I).Checked = (I = Index)
    Next I
    Select Case Index
    Case 0
        Views_SetLayout ViewLayout.SingleView
    Case 1
        Views_SetLayout ViewLayout.VerticalView
    Case 2
        Views_SetLayout ViewLayout.HorizontalView
    Case 3
        Views_SetLayout ViewLayout.QuadView
    End Select
End Sub

Private Sub mnuSelectLayout_Click(Index As Integer)
    SelectLayout Index
End Sub

Private Sub chTool_Click(Index As Integer)
    SelectTool Index
End Sub

Private Sub mnuUndo_Click()
    BrushSet.Undo
End Sub

Private Sub optGrid_Click(Index As Integer)
    Tools_SetGridDenominator 2 ^ Index
End Sub

Private Sub RenderTimer_Timer()
    Views_Tick
    Views_DrawGUI
End Sub
