
// You may modify this to move more data from the vertex shader to the pixel shader.
// It needs at least the position to work.
struct VS_to_PS {
	float4 Pos : SV_POSITION;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_to_PS VS( VS_structure input ) {
	VS_to_PS output = (VS_to_PS)0;
	
	// Convert vertice positions from object space to 2D projection
	output.Pos = mul( mul( mul( input.Pos, ObjectToWorld ), WorldToCamera ), CameraToImage );
	
	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_to_PS input) : SV_Target {
	// Show a green color in the editor to show that a special type of shader is making the shadows faster
	return float4(0.0f, 1.0f, 0.0f, 0.0f);
}
