Attribute VB_Name = "PlaneMath"

Option Explicit

'Invariant: |Normal| = 1
Public Type Plane
    Point As Vector3
    Normal As Vector3
End Type

Public Function MakePlane(Point As Vector3, Normal As Vector3) As Plane
    MakePlane.Point = Point
    MakePlane.Normal = Normal
End Function

Public Function FlipPlane(P As Plane) As Plane
    FlipPlane.Point = P.Point
    FlipPlane.Normal = NegVector3(P.Normal)
End Function

'Negative distance if inside
Public Function PointToSurfaceDistance(Point As Vector3, Surface As Plane) As Single
    PointToSurfaceDistance = DotProduct(SubVector3(Point, Surface.Point), Surface.Normal)
End Function
