Attribute VB_Name = "Shaders"

Option Explicit

'Draw shaders
Public DrawShader_Circle As Long
Public DrawShader_Circle_EllipseCut As Long
Public DrawShader_Color As Long
Public DrawShader_ThinLine As Long
Public DrawShader_1Tex As Long
Public DrawShader_Clamped_1Tex As Long
Public DrawShader_Clamped_NN_1Tex As Long
Public DrawShader_Stripes As Long
Public DrawShader_ThinLine_Dotted As Long
Public DrawShader_FullQuad_Border_1Tex As Long
Public DrawShader_FullQuad_Add_Border_2Tex As Long

'Material shaders
Public MaterialShader_WireFrame As Long
Public MaterialShader_WireFrame_Selection As Long
Public MaterialShader_WireFrame_UV1 As Long
Public MaterialShader_WireFrame_Selection_UV1 As Long
Public MaterialShader_WireFrame_UV2 As Long
Public MaterialShader_WireFrame_Selection_UV2 As Long
Public MaterialShader_Position As Long

Public Function LoadDrawShader(Filename As String) As Long
    InsertStringToEngine "Graphics/" & Filename
    LoadDrawShader = frmMain.DGE.Shader_LoadAsDrawShader_InSB: RE
End Function

Public Function LoadMaterialShader(Filename As String) As Long
    InsertStringToEngine "Graphics/" & Filename
    LoadMaterialShader = frmMain.DGE.Shader_LoadAsMaterial_InSB: RE
End Function

Public Sub Shader_Init()
    'Load draw shaders
    DrawShader_Circle = LoadDrawShader("Editor_D_Circle_Filled")
    DrawShader_Circle_EllipseCut = LoadDrawShader("Editor_D_Circle_EllipseCut")
    DrawShader_Color = LoadDrawShader("Editor_D_FullQuad_Color")
    DrawShader_ThinLine = LoadDrawShader("Editor_D_ThinLine")
    DrawShader_1Tex = LoadDrawShader("Editor_D_FullQuad_1Tex")
    DrawShader_Clamped_1Tex = LoadDrawShader("Editor_D_FullQuad_Clamped_1Tex")
    DrawShader_Clamped_NN_1Tex = LoadDrawShader("Editor_D_FullQuad_Clamped_NN_1Tex")
    DrawShader_Stripes = LoadDrawShader("Editor_D_Stripes")
    DrawShader_ThinLine_Dotted = LoadDrawShader("Editor_D_ThinLine_Dotted")
    DrawShader_FullQuad_Border_1Tex = LoadDrawShader("Editor_D_FullQuad_Border_1Tex")
    DrawShader_FullQuad_Add_Border_2Tex = LoadDrawShader("Editor_D_FullQuad_Add_Border_2Tex")
    
    'Load material shaders
    frmMain.DGE.Shader_UseAsDefaultMaterialShader LoadMaterialShader("Editor_DefaultMaterialShader")
    MaterialShader_WireFrame = LoadMaterialShader("Editor_M_Wire")
    MaterialShader_WireFrame_Selection = LoadMaterialShader("Editor_M_WireSelection")
    MaterialShader_WireFrame_UV1 = LoadMaterialShader("Editor_M_Wire_UV1")
    MaterialShader_WireFrame_Selection_UV1 = LoadMaterialShader("Editor_M_WireSelection_UV1")
    MaterialShader_WireFrame_UV2 = LoadMaterialShader("Editor_M_Wire_UV2")
    MaterialShader_WireFrame_Selection_UV2 = LoadMaterialShader("Editor_M_WireSelection_UV2")
    MaterialShader_Position = LoadMaterialShader("Editor_M_Position")
End Sub
